/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.impl;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import org.simpleflatmapper.csv.CellValueReader;
import org.simpleflatmapper.csv.CellValueReaderFactory;
import org.simpleflatmapper.csv.CsvColumnDefinition;
import org.simpleflatmapper.csv.CsvColumnKey;
import org.simpleflatmapper.csv.ParsingContextFactoryBuilder;
import org.simpleflatmapper.csv.impl.DelayedGetter;
import org.simpleflatmapper.csv.impl.InstantiatorOnReader;
import org.simpleflatmapper.csv.impl.cellreader.BooleanCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedBooleanCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedByteCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedCharCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedDoubleCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedFloatCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedIntegerCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedLongCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.BoxedShortCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.ByteCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.CellSetterImpl;
import org.simpleflatmapper.csv.impl.cellreader.CharCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.DefaultValueDelayedCallSetterFactory;
import org.simpleflatmapper.csv.impl.cellreader.DelayedCellSetterFactoryImpl;
import org.simpleflatmapper.csv.impl.cellreader.DoubleCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.FloatCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.IntegerCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.LongCellValueReader;
import org.simpleflatmapper.csv.impl.cellreader.ShortCellValueReader;
import org.simpleflatmapper.csv.impl.primitive.BooleanCellSetter;
import org.simpleflatmapper.csv.impl.primitive.BooleanDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.BooleanDelayedGetter;
import org.simpleflatmapper.csv.impl.primitive.ByteCellSetter;
import org.simpleflatmapper.csv.impl.primitive.ByteDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.ByteDelayedGetter;
import org.simpleflatmapper.csv.impl.primitive.CharCellSetter;
import org.simpleflatmapper.csv.impl.primitive.CharDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.CharDelayedGetter;
import org.simpleflatmapper.csv.impl.primitive.DoubleCellSetter;
import org.simpleflatmapper.csv.impl.primitive.DoubleDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.DoubleDelayedGetter;
import org.simpleflatmapper.csv.impl.primitive.FloatCellSetter;
import org.simpleflatmapper.csv.impl.primitive.FloatDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.FloatDelayedGetter;
import org.simpleflatmapper.csv.impl.primitive.IntCellSetter;
import org.simpleflatmapper.csv.impl.primitive.IntDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.IntDelayedGetter;
import org.simpleflatmapper.csv.impl.primitive.LongCellSetter;
import org.simpleflatmapper.csv.impl.primitive.LongDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.LongDelayedGetter;
import org.simpleflatmapper.csv.impl.primitive.ShortCellSetter;
import org.simpleflatmapper.csv.impl.primitive.ShortDelayedCellSetterFactory;
import org.simpleflatmapper.csv.impl.primitive.ShortDelayedGetter;
import org.simpleflatmapper.csv.mapper.CellSetter;
import org.simpleflatmapper.csv.mapper.CsvMapperCellHandler;
import org.simpleflatmapper.csv.mapper.DelayedCellSetterFactory;
import org.simpleflatmapper.map.MapperBuilderErrorHandler;
import org.simpleflatmapper.map.property.DefaultValueProperty;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.Instantiator;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.ObjectSetterFactory;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.instantiator.InstantiatorDefinitions;
import org.simpleflatmapper.reflect.meta.ClassMeta;
import org.simpleflatmapper.reflect.meta.DefaultPropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.reflect.setter.NullSetter;
import org.simpleflatmapper.util.ErrorDoc;
import org.simpleflatmapper.util.Predicate;
import org.simpleflatmapper.util.TypeHelper;

public final class CellSetterFactory {
    public static final InstantiatorDefinitions.CompatibilityScorer COMPATIBILITY_SCORER = new InstantiatorDefinitions.CompatibilityScorer(){

        public int score(InstantiatorDefinition id) {
            Class type = TypeHelper.toBoxedClass((Class)id.getParameters()[0].getType());
            if (type == String.class || type == CharSequence.class) {
                return 10;
            }
            if (Number.class.isAssignableFrom(type)) {
                return 9;
            }
            if (Date.class.isAssignableFrom(type)) {
                return 8;
            }
            return 0;
        }
    };
    private final CellValueReaderFactory cellValueReaderFactory;
    private final MapperBuilderErrorHandler mapperBuilderErrorHandler;

    public CellSetterFactory(CellValueReaderFactory cellValueReaderFactory, MapperBuilderErrorHandler mapperBuilderErrorHandler) {
        this.cellValueReaderFactory = cellValueReaderFactory;
        this.mapperBuilderErrorHandler = mapperBuilderErrorHandler;
    }

    public <T, P> CellSetter<T> getPrimitiveCellSetter(Class<?> clazz, CellValueReader<? extends P> reader, Setter<? super T, ? super P> setter) {
        if (Boolean.TYPE.equals(clazz)) {
            return new BooleanCellSetter(ObjectSetterFactory.toBooleanSetter(setter), this.booleanReader(reader));
        }
        if (Byte.TYPE.equals(clazz)) {
            return new ByteCellSetter(ObjectSetterFactory.toByteSetter(setter), this.byteReader(reader));
        }
        if (Character.TYPE.equals(clazz)) {
            return new CharCellSetter(ObjectSetterFactory.toCharacterSetter(setter), this.charReader(reader));
        }
        if (Short.TYPE.equals(clazz)) {
            return new ShortCellSetter(ObjectSetterFactory.toShortSetter(setter), this.shortReader(reader));
        }
        if (Integer.TYPE.equals(clazz)) {
            return new IntCellSetter(ObjectSetterFactory.toIntSetter(setter), this.intReader(reader));
        }
        if (Long.TYPE.equals(clazz)) {
            return new LongCellSetter(ObjectSetterFactory.toLongSetter(setter), this.longReader(reader));
        }
        if (Float.TYPE.equals(clazz)) {
            return new FloatCellSetter(ObjectSetterFactory.toFloatSetter(setter), this.floatReader(reader));
        }
        if (Double.TYPE.equals(clazz)) {
            return new DoubleCellSetter(ObjectSetterFactory.toDoubleSetter(setter), this.doubleReader(reader));
        }
        throw new IllegalArgumentException("Invalid primitive type " + clazz);
    }

    private DoubleCellValueReader doubleReader(CellValueReader<?> reader) {
        if (reader instanceof DoubleCellValueReader) {
            return (DoubleCellValueReader)reader;
        }
        return new BoxedDoubleCellValueReader(reader);
    }

    private FloatCellValueReader floatReader(CellValueReader<?> reader) {
        if (reader instanceof FloatCellValueReader) {
            return (FloatCellValueReader)reader;
        }
        return new BoxedFloatCellValueReader(reader);
    }

    private LongCellValueReader longReader(CellValueReader<?> reader) {
        if (reader instanceof LongCellValueReader) {
            return (LongCellValueReader)reader;
        }
        return new BoxedLongCellValueReader(reader);
    }

    private IntegerCellValueReader intReader(CellValueReader<?> reader) {
        if (reader instanceof IntegerCellValueReader) {
            return (IntegerCellValueReader)reader;
        }
        return new BoxedIntegerCellValueReader(reader);
    }

    private ShortCellValueReader shortReader(CellValueReader<?> reader) {
        if (reader instanceof ShortCellValueReader) {
            return (ShortCellValueReader)reader;
        }
        return new BoxedShortCellValueReader(reader);
    }

    private CharCellValueReader charReader(CellValueReader<?> reader) {
        if (reader instanceof CharCellValueReader) {
            return (CharCellValueReader)reader;
        }
        return new BoxedCharCellValueReader(reader);
    }

    private ByteCellValueReader byteReader(CellValueReader<?> reader) {
        if (reader instanceof ByteCellValueReader) {
            return (ByteCellValueReader)reader;
        }
        return new BoxedByteCellValueReader(reader);
    }

    private BooleanCellValueReader booleanReader(CellValueReader<?> reader) {
        if (reader instanceof BooleanCellValueReader) {
            return (BooleanCellValueReader)reader;
        }
        return new BoxedBooleanCellValueReader(reader);
    }

    private <T, P> DelayedCellSetterFactory<T, P> getPrimitiveDelayedCellSetter(Class<?> clazz, CellValueReader<? extends P> reader, Setter<? super T, ? super P> setter) {
        if (Boolean.TYPE.equals(clazz)) {
            return new BooleanDelayedCellSetterFactory(ObjectSetterFactory.toBooleanSetter(setter), this.booleanReader(reader));
        }
        if (Byte.TYPE.equals(clazz)) {
            return new ByteDelayedCellSetterFactory(ObjectSetterFactory.toByteSetter(setter), this.byteReader(reader));
        }
        if (Character.TYPE.equals(clazz)) {
            return new CharDelayedCellSetterFactory(ObjectSetterFactory.toCharacterSetter(setter), this.charReader(reader));
        }
        if (Short.TYPE.equals(clazz)) {
            return new ShortDelayedCellSetterFactory(ObjectSetterFactory.toShortSetter(setter), this.shortReader(reader));
        }
        if (Integer.TYPE.equals(clazz)) {
            return new IntDelayedCellSetterFactory(ObjectSetterFactory.toIntSetter(setter), this.intReader(reader));
        }
        if (Long.TYPE.equals(clazz)) {
            return new LongDelayedCellSetterFactory(ObjectSetterFactory.toLongSetter(setter), this.longReader(reader));
        }
        if (Float.TYPE.equals(clazz)) {
            return new FloatDelayedCellSetterFactory(ObjectSetterFactory.toFloatSetter(setter), this.floatReader(reader));
        }
        if (Double.TYPE.equals(clazz)) {
            return new DoubleDelayedCellSetterFactory(ObjectSetterFactory.toDoubleSetter(setter), this.doubleReader(reader));
        }
        throw new IllegalArgumentException("Invalid primitive type " + clazz);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T, P> Getter<CsvMapperCellHandler<T>, P> newDelayedGetter(CsvColumnKey key, Type type) {
        void var4_14;
        Class clazz = TypeHelper.toClass((Type)type);
        int columnIndex = key.getIndex();
        if (clazz.isPrimitive()) {
            if (Boolean.TYPE.equals(clazz)) {
                BooleanDelayedGetter booleanDelayedGetter = new BooleanDelayedGetter(columnIndex);
                return var4_14;
            } else if (Byte.TYPE.equals(clazz)) {
                ByteDelayedGetter byteDelayedGetter = new ByteDelayedGetter(columnIndex);
                return var4_14;
            } else if (Character.TYPE.equals(clazz)) {
                CharDelayedGetter charDelayedGetter = new CharDelayedGetter(columnIndex);
                return var4_14;
            } else if (Short.TYPE.equals(clazz)) {
                ShortDelayedGetter shortDelayedGetter = new ShortDelayedGetter(columnIndex);
                return var4_14;
            } else if (Integer.TYPE.equals(clazz)) {
                IntDelayedGetter intDelayedGetter = new IntDelayedGetter(columnIndex);
                return var4_14;
            } else if (Long.TYPE.equals(clazz)) {
                LongDelayedGetter longDelayedGetter = new LongDelayedGetter(columnIndex);
                return var4_14;
            } else if (Float.TYPE.equals(clazz)) {
                FloatDelayedGetter floatDelayedGetter = new FloatDelayedGetter(columnIndex);
                return var4_14;
            } else {
                if (!Double.TYPE.equals(clazz)) throw new IllegalArgumentException("Unexpected primitive " + clazz);
                DoubleDelayedGetter doubleDelayedGetter = new DoubleDelayedGetter(columnIndex);
            }
            return var4_14;
        } else {
            DelayedGetter delayedGetter = new DelayedGetter(columnIndex);
        }
        return var4_14;
    }

    private <P> CellValueReader<P> getReader(PropertyMeta<?, P> pm, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        CellValueReader<Object> reader = null;
        if (columnDefinition.hasCustomSourceFrom(pm.getOwnerType())) {
            reader = columnDefinition.getCustomReader();
        }
        if (reader == null) {
            reader = this.cellValueReaderFromFactory(pm, index, columnDefinition, parsingContextFactoryBuilder);
        }
        if (reader == null) {
            this.mapperBuilderErrorHandler.accessorNotFound("Could not find reader for " + pm.getPath() + " type " + pm.getPropertyType() + " See " + ErrorDoc.toUrl((String)"CSFM_GETTER_NOT_FOUND"));
        }
        return reader;
    }

    private <P> CellValueReader<P> cellValueReaderFromFactory(PropertyMeta<?, ?> pm, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        ClassMeta classMeta;
        InstantiatorDefinition id;
        Type propertyType = pm.getPropertyType();
        CellValueReader reader = null;
        if (columnDefinition.hasCustomReaderFactory()) {
            CellValueReaderFactory factory = columnDefinition.getCustomCellValueReaderFactory();
            reader = factory.getReader(propertyType, index, columnDefinition, parsingContextFactoryBuilder);
        }
        if (reader == null) {
            reader = this.cellValueReaderFactory.getReader(propertyType, index, columnDefinition, parsingContextFactoryBuilder);
        }
        if (reader == null && !pm.isSelf() && (id = InstantiatorDefinitions.lookForCompatibleOneArgument((Collection)(classMeta = pm.getPropertyClassMeta()).getInstantiatorDefinitions(), (InstantiatorDefinitions.CompatibilityScorer)COMPATIBILITY_SCORER)) != null) {
            Parameter parameter = id.getParameters()[0];
            PropertyMeta property = classMeta.newPropertyFinder(new Predicate<PropertyMeta<?, ?>>(){

                public boolean test(PropertyMeta<?, ?> propertyMeta) {
                    return propertyMeta.isConstructorProperty() || propertyMeta.isSubProperty() && ((SubPropertyMeta)propertyMeta).getOwnerProperty().isConstructorProperty();
                }
            }).findProperty(DefaultPropertyNameMatcher.exact((String)parameter.getName()));
            reader = this.cellValueReaderFromFactory(property, index, columnDefinition, parsingContextFactoryBuilder);
            if (reader != null) {
                Instantiator instantiator = classMeta.getReflectionService().getInstantiatorFactory().getOneArgIdentityInstantiator(id, classMeta.getReflectionService().builderIgnoresNullValues());
                return new InstantiatorOnReader(instantiator, reader);
            }
        }
        return reader;
    }

    public <T, P> CellSetter<T> getCellSetter(PropertyMeta<T, P> prop, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        Class propertyClass = TypeHelper.toClass((Type)prop.getPropertyType());
        CellValueReader<P> reader = this.getReader(prop, index, columnDefinition, parsingContextFactoryBuilder);
        if (propertyClass.isPrimitive()) {
            return this.getPrimitiveCellSetter(propertyClass, reader, this.getSetter(prop));
        }
        return new CellSetterImpl<T, P>(reader, this.getSetter(prop));
    }

    public <T, P> DelayedCellSetterFactory<T, P> getDelayedCellSetter(PropertyMeta<T, P> prop, int index, CsvColumnDefinition columnDefinition, ParsingContextFactoryBuilder parsingContextFactoryBuilder) {
        Class propertyClass = TypeHelper.toClass((Type)prop.getPropertyType());
        CellValueReader<P> reader = this.getReader(prop, index, columnDefinition, parsingContextFactoryBuilder);
        Setter<T, P> setter = prop.isConstructorProperty() ? null : this.getSetter(prop);
        DelayedCellSetterFactory<T, P> factory = propertyClass.isPrimitive() ? this.getPrimitiveDelayedCellSetter(propertyClass, reader, setter) : new DelayedCellSetterFactoryImpl<T, P>(reader, setter);
        DefaultValueProperty defaultValueProperty = (DefaultValueProperty)columnDefinition.lookFor(DefaultValueProperty.class);
        if (defaultValueProperty != null) {
            factory = new DefaultValueDelayedCallSetterFactory<T, P>(factory, defaultValueProperty, setter);
        }
        return factory;
    }

    private <T, P> Setter<? super T, ? super P> getSetter(PropertyMeta<T, P> prop) {
        Setter setter = prop.getSetter();
        if (NullSetter.isNull((Setter)setter)) {
            return null;
        }
        return setter;
    }
}

