/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.simpleflatmapper.csv.CsvParser;
import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CellUtil;
import org.simpleflatmapper.util.CheckedConsumer;
import org.simpleflatmapper.util.ErrorHelper;

public final class YamlCommentStringArrayConsumer<RC extends CheckedConsumer<? super String[]>, CC extends CheckedConsumer<? super String>>
implements CellConsumer {
    public static final int DEFAULT_MAX_NUMBER_OF_CELL_PER_ROW = 0x4000000;
    private final RC rowConsumer;
    private final CC commentConsumer;
    private final char separatorChar;
    private final char escapeChar;
    private final int maxNumberOfCellPerRow;
    private int currentIndex;
    private int currentLength = 8;
    private String[] currentRow = new String[this.currentLength];
    private StringBuilder commentBuilder = new StringBuilder();
    private boolean currentRowIsComment;

    private YamlCommentStringArrayConsumer(RC rowConsumer, CC commentConsumer, char separatorChar, char escapeChar, int maxNumberOfCellPerRow) {
        this.rowConsumer = rowConsumer;
        this.separatorChar = separatorChar;
        this.escapeChar = escapeChar;
        this.maxNumberOfCellPerRow = maxNumberOfCellPerRow;
        this.commentConsumer = commentConsumer;
    }

    @Override
    public void newCell(char[] chars, int offset, int length) {
        if (this.currentRowIsComment || this.currentIndex == 0 && length > 0 && chars[offset] == '#') {
            if (this.currentRowIsComment) {
                this.commentBuilder.append(this.separatorChar);
            } else {
                this.currentRowIsComment = true;
            }
            this.commentBuilder.append(chars, offset, length);
        } else {
            this.ensureCapacity();
            this.currentRow[this.currentIndex] = CellUtil.toUnescapedString(chars, offset, offset + length, this.escapeChar);
            ++this.currentIndex;
        }
    }

    private void ensureCapacity() {
        if (this.currentIndex >= this.currentLength) {
            if (this.currentLength >= this.maxNumberOfCellPerRow) {
                throw new ArrayIndexOutOfBoundsException("Reach maximum number of cell per row " + this.currentIndex);
            }
            this.currentLength *= 2;
            this.currentRow = Arrays.copyOf(this.currentRow, this.currentLength);
        }
    }

    @Override
    public boolean endOfRow() {
        try {
            return this._endOfRow();
        }
        catch (Exception e) {
            return (Boolean)ErrorHelper.rethrow((Throwable)e);
        }
    }

    private boolean _endOfRow() throws Exception {
        if (!this.currentRowIsComment) {
            this.rowConsumer.accept((Object)Arrays.copyOf(this.currentRow, this.currentIndex));
            Arrays.fill(this.currentRow, 0, this.currentIndex, null);
            this.currentIndex = 0;
            return true;
        }
        this.commentConsumer.accept((Object)this.commentBuilder.toString());
        this.commentBuilder.setLength(0);
        this.currentRowIsComment = false;
        return false;
    }

    public RC rowConsumer() {
        return this.rowConsumer;
    }

    public CC commentConsumer() {
        return this.commentConsumer;
    }

    @Override
    public void end() {
        if (this.currentIndex > 0 || this.currentRowIsComment) {
            this.endOfRow();
        }
    }

    public static <RC extends CheckedConsumer<? super String[]>, CC extends CheckedConsumer<? super String>> YamlCommentStringArrayConsumer<RC, CC> newInstance(RC handler, CC commentConsumer, char separatorChar, char escapeChar, int maxNumberOfCellPerRow) {
        return new YamlCommentStringArrayConsumer<RC, CC>(handler, commentConsumer, separatorChar, escapeChar, maxNumberOfCellPerRow);
    }

    public static <RC extends CheckedConsumer<? super String[]>, CC extends CheckedConsumer<? super String>> YamlCommentStringArrayConsumer<RC, CC> newInstance(RC handler, CC commentConsumer, char separatorChar, char escapeChar) {
        return YamlCommentStringArrayConsumer.newInstance(handler, commentConsumer, separatorChar, escapeChar, 0x4000000);
    }

    public static void readWithComments(CsvParser.DSL dsl, Reader reader, CheckedConsumer<String[]> rowCollector, CheckedConsumer<String> commentCollector) throws IOException {
        YamlCommentStringArrayConsumer<CheckedConsumer<String[]>, CheckedConsumer<String>> cellConsumer = YamlCommentStringArrayConsumer.newInstance(rowCollector, commentCollector, dsl.separator(), dsl.quote());
        dsl.parse(reader, cellConsumer);
    }
}

