/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import org.simpleflatmapper.csv.parser.CellConsumer;
import org.simpleflatmapper.csv.parser.CharBuffer;
import org.simpleflatmapper.csv.parser.CharConsumer;

public class UnescapeCharConsumer
extends CharConsumer {
    protected final char separatorChar;
    protected final char escapeChar;

    public UnescapeCharConsumer(CharBuffer csvBuffer, char separatorChar, char escapeChar) {
        super(csvBuffer);
        this.separatorChar = separatorChar;
        this.escapeChar = escapeChar;
    }

    @Override
    public final void consumeAllBuffer(CellConsumer cellConsumer) {
        int currentIndex;
        int bufferLength = this.csvBuffer.getBufferSize();
        char[] chars = this.csvBuffer.getCharBuffer();
        int currentState = this._currentState;
        for (currentIndex = this._currentIndex; currentIndex < bufferLength; ++currentIndex) {
            char character = chars[currentIndex];
            if (character != this.escapeChar) {
                if ((currentState & 1) == 0) {
                    if (character == this.separatorChar) {
                        this.newCell(currentIndex, cellConsumer);
                        currentState = 4;
                        continue;
                    }
                    if (character == '\n') {
                        if ((currentState & 2) == 0) {
                            this.endOfRow(currentIndex, cellConsumer);
                            currentState = 0;
                            continue;
                        }
                        this.csvBuffer.mark = currentIndex + 1;
                    } else if (character == '\r') {
                        this.endOfRow(currentIndex, cellConsumer);
                        currentState = 2;
                        continue;
                    }
                }
                currentState &= 0xFFFFFFF9;
                continue;
            }
            currentState ^= 1;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
    }

    @Override
    public final boolean consumeToNextRow(CellConsumer cellConsumer) {
        int currentIndex;
        int bufferLength = this.csvBuffer.getBufferSize();
        char[] chars = this.csvBuffer.getCharBuffer();
        int currentState = this._currentState;
        for (currentIndex = this._currentIndex; currentIndex < bufferLength; ++currentIndex) {
            char character = chars[currentIndex];
            if (character != this.escapeChar) {
                if ((currentState & 1) == 0) {
                    if (character == this.separatorChar) {
                        this.newCell(currentIndex, cellConsumer);
                        currentState = 0;
                        continue;
                    }
                    if (character == '\n') {
                        if ((currentState & 2) == 0) {
                            if (this.endOfRow(currentIndex, cellConsumer)) {
                                this._currentIndex = currentIndex + 1;
                                this._currentState = 0;
                                return true;
                            }
                            currentState = 0;
                            continue;
                        }
                        this.csvBuffer.mark(currentIndex + 1);
                    } else if (character == '\r') {
                        if (this.endOfRow(currentIndex, cellConsumer)) {
                            this._currentIndex = currentIndex + 1;
                            this._currentState = 2;
                            return true;
                        }
                        currentState = 2;
                        continue;
                    }
                }
                currentState &= 0xFFFFFFF9;
                continue;
            }
            currentState ^= 1;
        }
        this._currentState = currentState;
        this._currentIndex = currentIndex;
        return false;
    }

    @Override
    protected void newCell(int end, CellConsumer cellConsumer) {
        char[] chars = this.csvBuffer.buffer;
        int strStart = this.csvBuffer.mark;
        int strEnd = end;
        if (strStart < strEnd && chars[strStart] == this.escapeChar) {
            strEnd = this.unescape(chars, ++strStart, strEnd);
        }
        cellConsumer.newCell(chars, strStart, strEnd - strStart);
        this.csvBuffer.mark = end + 1;
    }

    protected final int unescape(char[] chars, int start, int end) {
        for (int i = start; i < end - 1; ++i) {
            if (chars[i] != this.escapeChar) continue;
            return this.removeEscapeChars(chars, end, i);
        }
        if (start < end && this.escapeChar == chars[end - 1]) {
            return end - 1;
        }
        return end;
    }

    private int removeEscapeChars(char[] chars, int end, int firstEscapeChar) {
        int j = firstEscapeChar;
        boolean escaped = true;
        for (int i = firstEscapeChar + 1; i < end; ++i) {
            boolean bl = escaped = chars[i] == this.escapeChar && !escaped;
            if (escaped) continue;
            chars[j++] = chars[i];
        }
        return j;
    }
}

