/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.csv.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.simpleflatmapper.csv.parser.BufferOverflowException;
import org.simpleflatmapper.csv.parser.CharBuffer;

public final class ReaderCharBuffer
extends CharBuffer {
    private final int maxBufferSize;
    private final Reader reader;
    private int resizeThreshold;

    public ReaderCharBuffer(int bufferSize, int maxBufferLength, Reader reader) {
        super(new char[bufferSize], 0);
        this.maxBufferSize = maxBufferLength;
        this.reader = reader;
        this.calculateResizeThreshold();
    }

    @Override
    public int fillBuffer() throws IOException {
        int length = this.reader.read(this.buffer, this.bufferSize, this.buffer.length - this.bufferSize);
        this.bufferSize += Math.max(0, length);
        return length;
    }

    @Override
    public int shiftBufferToMark() throws BufferOverflowException {
        int lMark = this.mark;
        int usedLength = Math.max(this.bufferSize - lMark, 0);
        if (usedLength > this.resizeThreshold) {
            this.resize(usedLength);
        }
        System.arraycopy(this.buffer, lMark, this.buffer, 0, usedLength);
        this.bufferSize = usedLength;
        this.mark = 0;
        return lMark;
    }

    private void resize(int requireLength) throws BufferOverflowException {
        int newBufferSize = Math.min(this.maxBufferSize, this.buffer.length << 1);
        if (newBufferSize <= requireLength) {
            throw new BufferOverflowException("The content in the csv cell exceed the maxSizeBuffer " + this.maxBufferSize + ", see CsvParser.DSL.maxSizeBuffer(int) to change the default value");
        }
        this.buffer = Arrays.copyOf(this.buffer, newBufferSize);
        this.calculateResizeThreshold();
    }

    private void calculateResizeThreshold() {
        this.resizeThreshold = (this.buffer.length >> 2) * 3;
    }
}

