/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import org.simpleflatmapper.converter.Context;
import org.simpleflatmapper.converter.ContextualConverter;

public class ObjectToJavaOffsetTimeConverter
implements ContextualConverter<Object, OffsetTime> {
    private final ZoneId zone;

    public ObjectToJavaOffsetTimeConverter(ZoneId zoneId) {
        this.zone = zoneId;
    }

    @Override
    public OffsetTime convert(Object o, Context context) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            Instant instant = Instant.ofEpochMilli(((Date)o).getTime());
            return instant.atOffset(this.zone.getRules().getOffset(instant)).toOffsetTime();
        }
        if (o instanceof Instant) {
            Instant instant = (Instant)o;
            return instant.atOffset(this.zone.getRules().getOffset(instant)).toOffsetTime();
        }
        if (o instanceof OffsetTime) {
            return (OffsetTime)o;
        }
        if (o instanceof LocalDateTime) {
            return ((LocalDateTime)o).atZone(this.zone).toOffsetDateTime().toOffsetTime();
        }
        if (o instanceof LocalTime) {
            return ((LocalTime)o).atOffset(this.zone.getRules().getOffset(Instant.now()));
        }
        if (o instanceof TemporalAccessor) {
            return OffsetTime.from((TemporalAccessor)o);
        }
        throw new IllegalArgumentException("Cannot convert " + String.valueOf(o) + " to OffsetTime");
    }
}

