/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl.time;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.simpleflatmapper.converter.Converter;

public class ObjectToJavaOffsetDateTimeConverter
implements Converter<Object, OffsetDateTime> {
    private final ZoneId zone;

    public ObjectToJavaOffsetDateTimeConverter(ZoneId zoneId) {
        this.zone = zoneId;
    }

    @Override
    public OffsetDateTime convert(Object o) throws Exception {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            Instant instant = Instant.ofEpochMilli(((Date)o).getTime());
            return instant.atOffset(this.zone.getRules().getOffset(instant));
        }
        if (o instanceof Instant) {
            Instant instant = (Instant)o;
            return instant.atOffset(this.zone.getRules().getOffset(instant));
        }
        if (o instanceof OffsetDateTime) {
            return (OffsetDateTime)o;
        }
        if (o instanceof ZonedDateTime) {
            return ((ZonedDateTime)o).toOffsetDateTime();
        }
        if (o instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)o;
            return localDateTime.atOffset(this.zone.getRules().getOffset(localDateTime));
        }
        if (o instanceof LocalDate) {
            LocalDateTime localDateTime = ((LocalDate)o).atTime(0, 0);
            return localDateTime.atOffset(this.zone.getRules().getOffset(localDateTime));
        }
        throw new IllegalArgumentException("Cannot convert " + o + " to OffsetDateTime");
    }
}

