/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.util.Date;
import java.util.UUID;
import org.simpleflatmapper.converter.AbstractConverterFactory;
import org.simpleflatmapper.converter.AbstractConverterFactoryProducer;
import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.ConverterFactory;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.converter.ConvertingTypes;
import org.simpleflatmapper.converter.ToStringConverter;
import org.simpleflatmapper.converter.impl.CharSequenceBigDecimal;
import org.simpleflatmapper.converter.impl.CharSequenceBigInteger;
import org.simpleflatmapper.converter.impl.CharSequenceBooleanConverter;
import org.simpleflatmapper.converter.impl.CharSequenceByteConverter;
import org.simpleflatmapper.converter.impl.CharSequenceCharacterConverter;
import org.simpleflatmapper.converter.impl.CharSequenceDoubleConverter;
import org.simpleflatmapper.converter.impl.CharSequenceFloatConverter;
import org.simpleflatmapper.converter.impl.CharSequenceIntegerConverter;
import org.simpleflatmapper.converter.impl.CharSequenceLongConverter;
import org.simpleflatmapper.converter.impl.CharSequenceShortConverter;
import org.simpleflatmapper.converter.impl.CharSequenceToDateConverter;
import org.simpleflatmapper.converter.impl.CharSequenceToEnumConverter;
import org.simpleflatmapper.converter.impl.CharSequenceUUIDConverter;
import org.simpleflatmapper.converter.impl.NumberBigDecimalConverter;
import org.simpleflatmapper.converter.impl.NumberBigIntegerConverter;
import org.simpleflatmapper.converter.impl.NumberByteConverter;
import org.simpleflatmapper.converter.impl.NumberDoubleConverter;
import org.simpleflatmapper.converter.impl.NumberFloatConverter;
import org.simpleflatmapper.converter.impl.NumberIntegerConverter;
import org.simpleflatmapper.converter.impl.NumberLongConverter;
import org.simpleflatmapper.converter.impl.NumberShortConverter;
import org.simpleflatmapper.converter.impl.NumberToEnumConverter;
import org.simpleflatmapper.converter.impl.ObjectToEnumConverter;
import org.simpleflatmapper.converter.impl.ToStringToURLConverter;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.TypeHelper;
import org.simpleflatmapper.util.date.DateFormatSupplier;
import org.simpleflatmapper.util.date.DefaultDateFormatSupplier;

public class JavaBaseConverterFactoryProducer
extends AbstractConverterFactoryProducer {
    public void produce(Consumer<? super ConverterFactory<?, ?>> consumer) {
        this.constantConverter(consumer, Number.class, Byte.class, new NumberByteConverter());
        this.constantConverter(consumer, Number.class, Short.class, new NumberShortConverter());
        this.constantConverter(consumer, Number.class, Integer.class, new NumberIntegerConverter());
        this.constantConverter(consumer, Number.class, Long.class, new NumberLongConverter());
        this.constantConverter(consumer, Number.class, Float.class, new NumberFloatConverter());
        this.constantConverter(consumer, Number.class, Double.class, new NumberDoubleConverter());
        this.constantConverter(consumer, Number.class, BigDecimal.class, new NumberBigDecimalConverter());
        this.constantConverter(consumer, Number.class, BigInteger.class, new NumberBigIntegerConverter());
        this.constantConverter(consumer, CharSequence.class, Byte.class, new CharSequenceByteConverter());
        this.constantConverter(consumer, CharSequence.class, BigInteger.class, new CharSequenceBigInteger());
        this.constantConverter(consumer, CharSequence.class, BigDecimal.class, new CharSequenceBigDecimal());
        this.constantConverter(consumer, CharSequence.class, Character.class, new CharSequenceCharacterConverter());
        this.constantConverter(consumer, CharSequence.class, Short.class, new CharSequenceShortConverter());
        this.constantConverter(consumer, CharSequence.class, Integer.class, new CharSequenceIntegerConverter());
        this.constantConverter(consumer, CharSequence.class, Long.class, new CharSequenceLongConverter());
        this.constantConverter(consumer, CharSequence.class, Float.class, new CharSequenceFloatConverter());
        this.constantConverter(consumer, CharSequence.class, Double.class, new CharSequenceDoubleConverter());
        this.constantConverter(consumer, CharSequence.class, UUID.class, new CharSequenceUUIDConverter());
        this.constantConverter(consumer, CharSequence.class, Boolean.class, new CharSequenceBooleanConverter());
        this.factoryConverter(consumer, new AbstractConverterFactory<CharSequence, Date>(CharSequence.class, Date.class){

            @Override
            public Converter<? super CharSequence, ? extends Date> newConverter(ConvertingTypes targetedTypes, Object ... params) {
                String format = this.getFormat(params);
                if (format != null) {
                    return new CharSequenceToDateConverter(format);
                }
                return null;
            }

            private String getFormat(Object[] params) {
                String defaultValue = null;
                if (params != null) {
                    for (Object o : params) {
                        if (o instanceof DefaultDateFormatSupplier) {
                            defaultValue = ((DefaultDateFormatSupplier)o).get();
                            continue;
                        }
                        if (!(o instanceof DateFormatSupplier)) continue;
                        return ((DateFormatSupplier)o).get();
                    }
                }
                return defaultValue;
            }
        });
        this.factoryConverter(consumer, new AbstractConverterFactory<CharSequence, Enum>(CharSequence.class, Enum.class){

            @Override
            public Converter<? super CharSequence, ? extends Enum> newConverter(ConvertingTypes targetedTypes, Object ... params) {
                return new CharSequenceToEnumConverter(TypeHelper.toClass((Type)targetedTypes.getTo()));
            }

            @Override
            public ConvertingScore score(ConvertingTypes targetedTypes) {
                if (TypeHelper.isAssignable(Enum.class, (Type)targetedTypes.getTo())) {
                    return new ConvertingScore(ConvertingTypes.getSourceScore(this.convertingTypes.getFrom(), targetedTypes.getFrom()), 256);
                }
                return ConvertingScore.NO_MATCH;
            }
        });
        this.factoryConverter(consumer, new AbstractConverterFactory<Number, Enum>(Number.class, Enum.class){

            @Override
            public Converter<? super Number, ? extends Enum> newConverter(ConvertingTypes targetedTypes, Object ... params) {
                return new NumberToEnumConverter(TypeHelper.toClass((Type)targetedTypes.getTo()));
            }

            @Override
            public ConvertingScore score(ConvertingTypes targetedTypes) {
                if (TypeHelper.isAssignable(Enum.class, (Type)targetedTypes.getTo())) {
                    return new ConvertingScore(ConvertingTypes.getSourceScore(this.convertingTypes.getFrom(), targetedTypes.getFrom()), 256);
                }
                return ConvertingScore.NO_MATCH;
            }
        });
        this.factoryConverter(consumer, new AbstractConverterFactory<Object, Enum>(Object.class, Enum.class){

            @Override
            public Converter<? super Object, ? extends Enum> newConverter(ConvertingTypes targetedTypes, Object ... params) {
                return new ObjectToEnumConverter(TypeHelper.toClass((Type)targetedTypes.getTo()));
            }

            @Override
            public ConvertingScore score(ConvertingTypes targetedTypes) {
                if (TypeHelper.isAssignable(Enum.class, (Type)targetedTypes.getTo())) {
                    return new ConvertingScore(ConvertingTypes.getSourceScore(this.convertingTypes.getFrom(), targetedTypes.getFrom()), 256);
                }
                return ConvertingScore.NO_MATCH;
            }
        });
        this.constantConverter(consumer, Object.class, String.class, ToStringConverter.INSTANCE);
        this.constantConverter(consumer, Object.class, URL.class, new ToStringToURLConverter());
    }
}

