/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.impl.time;

import java.time.format.DateTimeParseException;
import org.simpleflatmapper.converter.Converter;

public class MultiDateTimeFormatterConverter<I, O>
implements Converter<I, O> {
    private final Converter<I, O>[] converters;

    public MultiDateTimeFormatterConverter(Converter<I, O>[] converters) {
        this.converters = converters;
    }

    @Override
    public O convert(I in) throws Exception {
        for (int i = this.converters.length - 1; i >= 0; --i) {
            Converter<I, O> converter = this.converters[i];
            try {
                return converter.convert(in);
            }
            catch (DateTimeParseException dateTimeParseException) {
                continue;
            }
        }
        throw new DateTimeParseException("Unable to parse " + in, String.valueOf(in), 0);
    }
}

