/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import org.simpleflatmapper.converter.Converter;
import org.simpleflatmapper.converter.UncheckedConverter;
import org.simpleflatmapper.util.ErrorHelper;

public final class UncheckedConverterHelper {
    private UncheckedConverterHelper() {
    }

    public static <I, O> UncheckedConverter<I, O> toUnchecked(Converter<I, O> converter) {
        return new UncheckedConverterImpl<I, O>(converter);
    }

    private static class UncheckedConverterImpl<I, O>
    implements UncheckedConverter<I, O> {
        private final Converter<I, O> converter;

        public UncheckedConverterImpl(Converter<I, O> converter) {
            this.converter = converter;
        }

        @Override
        public O convert(I in) {
            try {
                return this.converter.convert(in);
            }
            catch (Exception e) {
                return (O)ErrorHelper.rethrow((Throwable)e);
            }
        }
    }
}

