/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter;

import java.lang.reflect.Type;
import org.simpleflatmapper.converter.ConvertingScore;
import org.simpleflatmapper.util.TypeHelper;

public class ConvertingTypes {
    private static final int MAX_SCORE = 256;
    private static final int NOT_COMPATIBLE = -1;
    private final Type from;
    private final Type to;

    public ConvertingTypes(Type from, Type to) {
        this.from = from;
        this.to = to;
    }

    public ConvertingScore score(ConvertingTypes targetedTypes) {
        int targetScore = ConvertingTypes.getTargetScore(this.to, targetedTypes.getTo());
        int sourceScore = ConvertingTypes.getSourceScore(this.from, targetedTypes.getFrom());
        return new ConvertingScore(sourceScore, targetScore);
    }

    public static int getSourceScore(Type from, Type target) {
        if (!TypeHelper.isAssignable((Type)from, (Type)target)) {
            return -1;
        }
        if (TypeHelper.areEquals((Type)from, (Type)target)) {
            return 256;
        }
        return Math.max(256 - ConvertingTypes.distanceToParent(target, from), 0);
    }

    public static int distanceToParent(Type target, Type parent) {
        int distance = 0;
        Class currentClass = TypeHelper.toClass((Type)target);
        while (currentClass != null && !ConvertingTypes.isParentThere(currentClass, parent)) {
            currentClass = currentClass.getSuperclass();
            ++distance;
        }
        return distance;
    }

    private static boolean isParentThere(Class<?> currentClass, Type parent) {
        if (TypeHelper.areEquals((Type)parent, currentClass)) {
            return true;
        }
        for (Class<?> interfaceClass : currentClass.getInterfaces()) {
            if (!TypeHelper.areEquals((Type)parent, interfaceClass)) continue;
            return true;
        }
        return false;
    }

    public static int getTargetScore(Type from, Type target) {
        if (!TypeHelper.isAssignable((Type)target, (Type)from)) {
            return -1;
        }
        if (TypeHelper.areEquals((Type)from, (Type)target)) {
            return 256;
        }
        return Math.max(256 - ConvertingTypes.distanceToParent(from, target), 0);
    }

    public Type getFrom() {
        return this.from;
    }

    public Type getTo() {
        return this.to;
    }
}

