/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.converter.joda.impl;

import java.util.ArrayList;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.simpleflatmapper.util.Supplier;
import org.simpleflatmapper.util.SupplierHelper;
import org.simpleflatmapper.util.date.DateFormatSupplier;
import org.simpleflatmapper.util.date.DefaultDateFormatSupplier;

public final class JodaTimeHelper {
    private JodaTimeHelper() {
    }

    public static DateTimeFormatter getDateTimeFormatter(Object ... properties) {
        DateTimeZone dateTimeZone = JodaTimeHelper.getDateTimeZone(properties);
        DefaultDateFormatSupplier defaultDateFormatSupplier = null;
        for (Object prop : properties) {
            DateTimeFormatter dateTimeFormatter = JodaTimeHelper.toDateTimeFormater(prop, dateTimeZone);
            if (dateTimeFormatter != null) {
                return dateTimeFormatter;
            }
            if (!(prop instanceof DefaultDateFormatSupplier)) continue;
            defaultDateFormatSupplier = (DefaultDateFormatSupplier)prop;
        }
        if (defaultDateFormatSupplier != null) {
            return JodaTimeHelper.withZone(defaultDateFormatSupplier.get(), dateTimeZone);
        }
        return null;
    }

    private static DateTimeFormatter toDateTimeFormater(Object prop, DateTimeZone dateTimeZone) {
        if (SupplierHelper.isSupplierOf((Object)prop, DateTimeFormatter.class)) {
            return JodaTimeHelper.withZone((DateTimeFormatter)((Supplier)prop).get(), dateTimeZone);
        }
        if (prop instanceof DateFormatSupplier) {
            return JodaTimeHelper.withZone(((DateFormatSupplier)prop).get(), dateTimeZone);
        }
        if (prop instanceof DateTimeFormatter) {
            return (DateTimeFormatter)prop;
        }
        return null;
    }

    public static DateTimeFormatter[] getDateTimeFormatters(Object ... properties) {
        ArrayList<DateTimeFormatter> dtf = new ArrayList<DateTimeFormatter>();
        DateTimeZone dateTimeZone = JodaTimeHelper.getDateTimeZone(properties);
        DefaultDateFormatSupplier defaultDateFormatSupplier = null;
        for (Object prop : properties) {
            DateTimeFormatter df = JodaTimeHelper.toDateTimeFormater(prop, dateTimeZone);
            if (df != null) {
                dtf.add(df);
                continue;
            }
            if (!(prop instanceof DefaultDateFormatSupplier)) continue;
            defaultDateFormatSupplier = (DefaultDateFormatSupplier)prop;
        }
        if (dtf.isEmpty()) {
            if (defaultDateFormatSupplier == null) {
                throw new IllegalStateException("No date format specified");
            }
            dtf.add(JodaTimeHelper.withZone(defaultDateFormatSupplier.get(), dateTimeZone));
        }
        return dtf.toArray(new DateTimeFormatter[0]);
    }

    private static DateTimeFormatter withZone(String format, DateTimeZone zoneId) {
        return JodaTimeHelper.withZone(DateTimeFormat.forPattern((String)format), zoneId);
    }

    private static DateTimeFormatter withZone(DateTimeFormatter dateTimeFormatter, DateTimeZone zoneId) {
        if (zoneId != null) {
            return dateTimeFormatter.withZone(zoneId);
        }
        if (dateTimeFormatter.getZone() == null) {
            return dateTimeFormatter.withZone(DateTimeZone.getDefault());
        }
        return dateTimeFormatter;
    }

    public static DateTimeZone getDateTimeZoneOrDefault(Object ... params) {
        DateTimeZone p = JodaTimeHelper.getDateTimeZone(params);
        if (p != null) {
            return p;
        }
        return DateTimeZone.getDefault();
    }

    private static DateTimeZone getDateTimeZone(Object[] params) {
        if (params != null) {
            for (Object p : params) {
                if (p instanceof DateTimeZone) {
                    return (DateTimeZone)p;
                }
                if (p instanceof TimeZone) {
                    return DateTimeZone.forTimeZone((TimeZone)((TimeZone)p));
                }
                if (SupplierHelper.isSupplierOf((Object)p, DateTimeZone.class)) {
                    return (DateTimeZone)((Supplier)p).get();
                }
                if (!SupplierHelper.isSupplierOf((Object)p, TimeZone.class)) continue;
                return DateTimeZone.forTimeZone((TimeZone)((TimeZone)((Supplier)p).get()));
            }
        }
        return null;
    }
}

