/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsclient.parser.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.simple4j.wsclient.exception.SystemException;
import org.simple4j.wsclient.parser.IParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser
implements IParser {
    private static Logger logger = LoggerFactory.getLogger(XMLParser.class);
    private ThreadLocal<Map<String, List<Node>>> xpathEvalCacheTL = new ThreadLocal();
    private boolean removePrefix = true;
    private List<String> listElementXpaths = new ArrayList<String>();
    private List<String> attributedElementXpaths = new ArrayList<String>();
    private String textNodeKey = "TEXT";

    public boolean isRemovePrefix() {
        return this.removePrefix;
    }

    public void setRemovePrefix(boolean removePrefix) {
        this.removePrefix = removePrefix;
    }

    public List<String> getListElementXpaths() {
        return this.listElementXpaths;
    }

    public void setListElementXpaths(List<String> listElementXpaths) {
        this.listElementXpaths = listElementXpaths;
    }

    public List<String> getAttributedElementXpaths() {
        return this.attributedElementXpaths;
    }

    public void setAttributedElementXpaths(List<String> attributedElementXpaths) {
        this.attributedElementXpaths = attributedElementXpaths;
    }

    public String getTextNodeKey() {
        return this.textNodeKey;
    }

    public void setTextNodeKey(String textNodeKey) {
        this.textNodeKey = textNodeKey;
    }

    @Override
    public Map<String, ? extends Object> parseData(String inputXMLStr) {
        try {
            Document document;
            byte[] inputXMLBA = inputXMLStr.getBytes();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream bais = new ByteArrayInputStream(inputXMLBA);
            Document node = document = builder.parse(bais);
            this.xpathEvalCacheTL.set(new HashMap());
            Map<String, ? extends Object> convertedMap = this.convert2Collections(node, null);
            return convertedMap;
        }
        catch (IOException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            throw new SystemException("XML_PARSE_FAILED", e);
        }
    }

    private Map<String, ? extends Object> convert2Collections(Node node, Node parent) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        NodeList childNodes;
        logger.trace("processing node:" + node.getNodeName());
        logger.trace("processing node no prefix:" + this.handlePrefix(node.getNodeName()));
        logger.trace("processing nodelocalname:" + node.getLocalName());
        logger.trace(node.getPrefix());
        logger.trace(node.getNamespaceURI());
        logger.trace(node.getBaseURI());
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (node == null) {
            return ret;
        }
        if (node.getNodeType() == 8) {
            return ret;
        }
        if (node.getNodeType() == 3 || node.getNodeType() == 4) {
            ret.put(this.getTextNodeKey(), node.getNodeValue());
            return ret;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                String prefixHandledAttributeName = this.handlePrefix(attribute.getNodeName());
                if (prefixHandledAttributeName.equalsIgnoreCase("nill") && "true".equalsIgnoreCase(attribute.getNodeValue())) {
                    return null;
                }
                ret.put(prefixHandledAttributeName, attribute.getNodeValue());
            }
        }
        if ((childNodes = node.getChildNodes()) != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Object value;
                Node child = childNodes.item(i);
                if (child.getNodeType() != 1 && child.getNodeType() != 4 && child.getNodeType() != 3) continue;
                Map<String, ? extends Object> tempMap = this.convert2Collections(child, node);
                String childNodeName = this.handlePrefix(child.getNodeName());
                logger.trace(childNodeName + " processed values:" + tempMap);
                if (child.getNodeType() == 4 || child.getNodeType() == 3) {
                    if (childNodes.getLength() != 1) continue;
                    ret.putAll(tempMap);
                    continue;
                }
                boolean isListElement = this.doesNodeMatchAnyXpath(child, this.getListElementXpaths());
                if (isListElement) {
                    value = this.processAttributedElements(child, tempMap);
                    List<Object> values = null;
                    if (!ret.containsKey(childNodeName)) {
                        values = new ArrayList();
                        ret.put(childNodeName, values);
                    } else {
                        values = (List)ret.get(childNodeName);
                    }
                    values.add(value);
                    continue;
                }
                value = this.processAttributedElements(child, tempMap);
                if (ret.containsKey(childNodeName)) {
                    Object obj = ret.get(childNodeName);
                    ArrayList<Object> values = null;
                    if (obj instanceof List) {
                        values = (ArrayList<Object>)obj;
                    } else {
                        values = new ArrayList<Object>();
                        values.add(obj);
                        ret.put(childNodeName, values);
                    }
                    values.add(value);
                    continue;
                }
                ret.put(childNodeName, value);
            }
        }
        return ret;
    }

    private Object processAttributedElements(Node child, Map<String, ? extends Object> tempMap) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        Object value = tempMap;
        if (!this.doesNodeMatchAnyXpath(child, this.getAttributedElementXpaths()) && tempMap != null && tempMap.containsKey(this.getTextNodeKey()) && tempMap.size() == 1) {
            value = tempMap.get(this.getTextNodeKey());
        }
        return value;
    }

    private boolean doesNodeMatchAnyXpath(Node child, List<String> xpaths) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        boolean isListElement = false;
        for (int j = 0; j < xpaths.size() && !isListElement; ++j) {
            String listElementXpath = xpaths.get(j);
            isListElement = this.doesNodeMatchXpath(child, listElementXpath);
        }
        return isListElement;
    }

    private String handlePrefix(String nodeName) {
        if (this.removePrefix) {
            if (nodeName.contains(":")) {
                return nodeName.replaceFirst("^.*:", "");
            }
            return nodeName;
        }
        return nodeName;
    }

    private boolean doesNodeMatchXpath(Node node, String xpathExpression) throws XPathExpressionException, ParserConfigurationException, SAXException, IOException {
        List<Node> xpathMatchedNodes = this.xpathEvalCacheTL.get().get(xpathExpression);
        if (xpathMatchedNodes == null) {
            xpathMatchedNodes = this.evaluate(node, xpathExpression);
            this.xpathEvalCacheTL.get().put(xpathExpression, xpathMatchedNodes);
        }
        for (int index = 0; index < xpathMatchedNodes.size(); ++index) {
            if (!node.isSameNode(xpathMatchedNodes.get(index))) continue;
            xpathMatchedNodes.remove(index);
            return true;
        }
        return false;
    }

    private List<Node> evaluate(Node node, String xpathExpression) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException {
        ArrayList<Node> ret = new ArrayList<Node>();
        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        XPathExpression expr = xpath.compile(xpathExpression);
        NodeList xpathMatchedNodeList = (NodeList)expr.evaluate(node.getOwnerDocument(), XPathConstants.NODESET);
        for (int index = 0; index < xpathMatchedNodeList.getLength(); ++index) {
            ret.add(xpathMatchedNodeList.item(index));
        }
        return ret;
    }
}

