/*
 * Decompiled with CFR 0.152.
 */
package org.simple4j.wsclient.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;

public class HTTPWSResponse {
    private Map<String, List<String>> responseHeaders = null;
    private String responseBodyAsString = null;
    private int statusCode = -1;
    private String statusLine = null;
    private String statusText = null;
    private String contentType = null;
    private String contentEncoding = null;

    public HTTPWSResponse(HttpResponse response) throws ParseException, IOException {
        StatusLine statusLineObj = response.getStatusLine();
        this.statusLine = statusLineObj.toString();
        this.statusCode = statusLineObj.getStatusCode();
        this.statusText = statusLineObj.getReasonPhrase();
        this.responseHeaders = this.getHeaders(response.getAllHeaders());
        HttpEntity entity = response.getEntity();
        this.contentType = entity.getContentType().getValue();
        if (entity.getContentEncoding() != null) {
            this.contentEncoding = entity.getContentEncoding().getValue();
        }
        this.responseBodyAsString = entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
    }

    private Map<String, List<String>> getHeaders(Header[] responseHeaders) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (int i = 0; i < responseHeaders.length; ++i) {
            ArrayList<String> responseFooter = (ArrayList<String>)ret.get(responseHeaders[i].getName());
            if (responseFooter == null) {
                responseFooter = new ArrayList<String>();
            }
            responseFooter.add(responseHeaders[i].getValue());
        }
        return ret;
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseBodyAsString() {
        return this.responseBodyAsString;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        builder.append("[responseHeaders=");
        builder.append(this.responseHeaders);
        builder.append(", responseBodyAsString=");
        builder.append(this.responseBodyAsString);
        builder.append(", statusCode=");
        builder.append(this.statusCode);
        builder.append(", statusLine=");
        builder.append(this.statusLine);
        builder.append(", statusText=");
        builder.append(this.statusText);
        builder.append(", contentType=");
        builder.append(this.contentType);
        builder.append(", contentEncoding=");
        builder.append(this.contentEncoding);
        builder.append("]");
        return builder.toString();
    }
}

