/*
 * Decompiled with CFR 0.152.
 */
package org.simple.eventbus.handler;

import android.os.Handler;
import android.os.HandlerThread;
import org.simple.eventbus.Subscription;
import org.simple.eventbus.handler.DefaultEventHandler;
import org.simple.eventbus.handler.EventHandler;

public class AsyncEventHandler
implements EventHandler {
    DispatcherThread mDispatcherThread;
    EventHandler mEventHandler = new DefaultEventHandler();

    public AsyncEventHandler() {
        this.mDispatcherThread = new DispatcherThread(AsyncEventHandler.class.getSimpleName());
        this.mDispatcherThread.start();
    }

    @Override
    public void handleEvent(final Subscription subscription, final Object event) {
        this.mDispatcherThread.post(new Runnable(){

            @Override
            public void run() {
                AsyncEventHandler.this.mEventHandler.handleEvent(subscription, event);
            }
        });
    }

    class DispatcherThread
    extends HandlerThread {
        protected Handler mAsyncHandler;

        public DispatcherThread(String name) {
            super(name);
        }

        public void post(Runnable runnable) {
            if (this.mAsyncHandler == null) {
                throw new NullPointerException("mAsyncHandler == null, please call start() first.");
            }
            this.mAsyncHandler.post(runnable);
        }

        public synchronized void start() {
            super.start();
            this.mAsyncHandler = new Handler(this.getLooper());
        }
    }
}

