/*
 * Decompiled with CFR 0.152.
 */
package org.simple.eventbus;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simple.eventbus.EventType;
import org.simple.eventbus.Subscriber;
import org.simple.eventbus.Subscription;
import org.simple.eventbus.TargetMethod;

public class SubsciberMethodHunter {
    Map<EventType, CopyOnWriteArrayList<Subscription>> mSubcriberMap;

    public SubsciberMethodHunter(Map<EventType, CopyOnWriteArrayList<Subscription>> subscriberMap) {
        this.mSubcriberMap = subscriberMap;
    }

    public void findSubcribeMethods(Object subscriber) {
        if (this.mSubcriberMap == null) {
            throw new NullPointerException("the mSubcriberMap is null. ");
        }
        for (Class<?> clazz = subscriber.getClass(); clazz != null && !this.isSystemCalss(clazz.getName()); clazz = clazz.getSuperclass()) {
            Method[] allMethods = clazz.getDeclaredMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                Class<?>[] paramsTypeClass;
                Method method = allMethods[i];
                Subscriber annotation = method.getAnnotation(Subscriber.class);
                if (annotation == null || (paramsTypeClass = method.getParameterTypes()) == null || paramsTypeClass.length != 1) continue;
                Class<?> paramType = this.convertType(paramsTypeClass[0]);
                EventType eventType = new EventType(paramType, annotation.tag());
                TargetMethod subscribeMethod = new TargetMethod(method, eventType, annotation.mode());
                this.subscibe(eventType, subscribeMethod, subscriber);
            }
        }
    }

    private void subscibe(EventType event, TargetMethod method, Object subscriber) {
        Subscription newSubscription;
        CopyOnWriteArrayList<Subscription> subscriptionLists = this.mSubcriberMap.get(event);
        if (subscriptionLists == null) {
            subscriptionLists = new CopyOnWriteArrayList();
        }
        if (subscriptionLists.contains(newSubscription = new Subscription(subscriber, method))) {
            return;
        }
        subscriptionLists.add(newSubscription);
        this.mSubcriberMap.put(event, subscriptionLists);
    }

    public void removeMethodsFromMap(Object subscriber) {
        Iterator<CopyOnWriteArrayList<Subscription>> iterator = this.mSubcriberMap.values().iterator();
        while (iterator.hasNext()) {
            CopyOnWriteArrayList<Subscription> subscriptions = iterator.next();
            if (subscriptions != null) {
                LinkedList<Subscription> foundSubscriptions = new LinkedList<Subscription>();
                for (Subscription subscription : subscriptions) {
                    Object cacheObject = subscription.subscriber.get();
                    if (!this.isObjectsEqual(cacheObject, subscriber) && cacheObject != null) continue;
                    foundSubscriptions.add(subscription);
                }
                subscriptions.removeAll(foundSubscriptions);
            }
            if (subscriptions != null && subscriptions.size() != 0) continue;
            iterator.remove();
        }
    }

    private boolean isObjectsEqual(Object cachedObj, Object subscriber) {
        return cachedObj != null && cachedObj.equals(subscriber);
    }

    private Class<?> convertType(Class<?> eventType) {
        Class<Object> returnClass = eventType;
        if (eventType.equals(Boolean.TYPE)) {
            returnClass = Boolean.class;
        } else if (eventType.equals(Integer.TYPE)) {
            returnClass = Integer.class;
        } else if (eventType.equals(Float.TYPE)) {
            returnClass = Float.class;
        } else if (eventType.equals(Double.TYPE)) {
            returnClass = Double.class;
        }
        return returnClass;
    }

    private boolean isSystemCalss(String name) {
        return name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("android.");
    }
}

