/*
 * Decompiled with CFR 0.152.
 */
package org.simple.eventbus;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import org.simple.eventbus.EventType;
import org.simple.eventbus.SubsciberMethodHunter;
import org.simple.eventbus.Subscription;
import org.simple.eventbus.ThreadMode;
import org.simple.eventbus.handler.AsyncEventHandler;
import org.simple.eventbus.handler.DefaultEventHandler;
import org.simple.eventbus.handler.EventHandler;
import org.simple.eventbus.handler.UIThreadEventHandler;
import org.simple.eventbus.matchpolicy.DefaultMatchPolicy;
import org.simple.eventbus.matchpolicy.MatchPolicy;

public final class EventBus {
    private static final String DESCRIPTOR = EventBus.class.getSimpleName();
    private String mDesc = DESCRIPTOR;
    private final Map<EventType, CopyOnWriteArrayList<Subscription>> mSubcriberMap = new ConcurrentHashMap<EventType, CopyOnWriteArrayList<Subscription>>();
    private List<EventType> mStickyEvents = Collections.synchronizedList(new LinkedList());
    ThreadLocal<Queue<EventType>> mLocalEvents = new ThreadLocal<Queue<EventType>>(){

        @Override
        protected Queue<EventType> initialValue() {
            return new ConcurrentLinkedQueue<EventType>();
        }
    };
    EventDispatcher mDispatcher = new EventDispatcher();
    SubsciberMethodHunter mMethodHunter = new SubsciberMethodHunter(this.mSubcriberMap);
    private static EventBus sDefaultBus;

    private EventBus() {
        this(DESCRIPTOR);
    }

    public EventBus(String desc) {
        this.mDesc = desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBus getDefault() {
        if (sDefaultBus != null) return sDefaultBus;
        Class<EventBus> clazz = EventBus.class;
        synchronized (EventBus.class) {
            if (sDefaultBus != null) return sDefaultBus;
            sDefaultBus = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sDefaultBus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object subscriber) {
        if (subscriber == null) {
            return;
        }
        EventBus eventBus = this;
        synchronized (eventBus) {
            this.mMethodHunter.findSubcribeMethods(subscriber);
        }
    }

    public void registerSticky(Object subscriber) {
        this.register(subscriber);
        this.mDispatcher.dispatchStickyEvents(subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void unregister(Object subscriber) {
        if (subscriber == null) {
            return;
        }
        EventBus eventBus = this;
        synchronized (eventBus) {
            this.mMethodHunter.removeMethodsFromMap(subscriber);
        }
    }

    public void post(Object event) {
        this.post(event, "default_tag");
    }

    public void post(Object event, String tag) {
        this.mLocalEvents.get().offer(new EventType(event.getClass(), tag));
        this.mDispatcher.dispatchEvents(event);
    }

    public void postSticky(Object event) {
        this.postSticky(event, "default_tag");
    }

    public void postSticky(Object event, String tag) {
        EventType eventType = new EventType(event.getClass(), tag);
        eventType.event = event;
        this.mStickyEvents.add(eventType);
        this.mDispatcher.handleStickyEvent(eventType, null);
    }

    public void removeStickyEvent(Class<?> eventClass) {
        this.removeStickyEvent(eventClass, "default_tag");
    }

    public void removeStickyEvent(Class<?> eventClass, String tag) {
        Iterator<EventType> iterator = this.mStickyEvents.iterator();
        while (iterator.hasNext()) {
            EventType eventType = iterator.next();
            if (!eventType.paramClass.equals(eventClass) || !eventType.tag.equals(tag)) continue;
            iterator.remove();
        }
    }

    public List<EventType> getStickyEvents() {
        return this.mStickyEvents;
    }

    public void setMatchPolicy(MatchPolicy policy) {
        this.mDispatcher.mMatchPolicy = policy;
    }

    public void setUIThreadEventHandler(EventHandler handler) {
        this.mDispatcher.mUIThreadEventHandler = handler;
    }

    public void setPostThreadHandler(EventHandler handler) {
        this.mDispatcher.mPostThreadHandler = handler;
    }

    public void setAsyncEventHandler(EventHandler handler) {
        this.mDispatcher.mAsyncEventHandler = handler;
    }

    public Map<EventType, CopyOnWriteArrayList<Subscription>> getSubscriberMap() {
        return this.mSubcriberMap;
    }

    public Queue<EventType> getEventQueue() {
        return this.mLocalEvents.get();
    }

    public synchronized void clear() {
        this.mLocalEvents.get().clear();
        this.mSubcriberMap.clear();
    }

    public String getDescriptor() {
        return this.mDesc;
    }

    private class EventDispatcher {
        EventHandler mUIThreadEventHandler = new UIThreadEventHandler();
        EventHandler mPostThreadHandler = new DefaultEventHandler();
        EventHandler mAsyncEventHandler = new AsyncEventHandler();
        private Map<EventType, List<EventType>> mCacheEventTypes = new ConcurrentHashMap<EventType, List<EventType>>();
        MatchPolicy mMatchPolicy = new DefaultMatchPolicy();

        private EventDispatcher() {
        }

        void dispatchStickyEvents(Object subscriber) {
            for (EventType eventType : EventBus.this.mStickyEvents) {
                this.handleStickyEvent(eventType, subscriber);
            }
        }

        void dispatchEvents(Object aEvent) {
            Queue<EventType> eventsQueue = EventBus.this.mLocalEvents.get();
            while (eventsQueue.size() > 0) {
                this.deliveryEvent(eventsQueue.poll(), aEvent);
            }
        }

        private void deliveryEvent(EventType type, Object aEvent) {
            Class<?> eventClass = aEvent.getClass();
            List<EventType> eventTypes = null;
            if (this.mCacheEventTypes.containsKey(eventClass)) {
                eventTypes = this.mCacheEventTypes.get(type);
            } else {
                eventTypes = this.mMatchPolicy.findMatchEventTypes(type, aEvent);
                this.mCacheEventTypes.put(type, eventTypes);
            }
            for (EventType eventType : eventTypes) {
                this.handleEvent(eventType, aEvent);
            }
        }

        private void handleStickyEvent(EventType eventType, Object subscriber) {
            List subscriptions = (List)EventBus.this.mSubcriberMap.get(eventType);
            if (subscriptions == null) {
                return;
            }
            for (Subscription subItem : subscriptions) {
                ThreadMode mode = subItem.threadMode;
                EventHandler eventHandler = this.getEventHandler(mode);
                if (!this.isTarget(subItem, subscriber) || !subItem.eventType.equals(eventType)) continue;
                eventHandler.handleEvent(subItem, eventType.event);
            }
        }

        private boolean isTarget(Subscription item, Object subscriber) {
            return subscriber == null || subscriber != null && item.subscriber.get().equals(subscriber);
        }

        private void handleEvent(EventType eventType, Object aEvent) {
            List subscriptions = (List)EventBus.this.mSubcriberMap.get(eventType);
            if (subscriptions == null) {
                return;
            }
            for (Subscription subscription : subscriptions) {
                ThreadMode mode = subscription.threadMode;
                EventHandler eventHandler = this.getEventHandler(mode);
                eventHandler.handleEvent(subscription, aEvent);
            }
        }

        private EventHandler getEventHandler(ThreadMode mode) {
            if (mode == ThreadMode.ASYNC) {
                return this.mAsyncEventHandler;
            }
            if (mode == ThreadMode.POST) {
                return this.mPostThreadHandler;
            }
            return this.mUIThreadEventHandler;
        }
    }
}

