/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.message;

import java.util.Optional;
import org.signal.libsignal.internal.FilterExceptions;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.protocol.InvalidKeyException;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.signal.libsignal.protocol.ecc.ECPublicKey;

public final class DecryptionErrorMessage
extends NativeHandleGuard.SimpleOwner {
    @Override
    protected void release(long nativeHandle) {
        Native.DecryptionErrorMessage_Destroy(nativeHandle);
    }

    DecryptionErrorMessage(long nativeHandle) {
        super(nativeHandle);
    }

    public DecryptionErrorMessage(byte[] serialized) throws InvalidKeyException, InvalidMessageException {
        super(FilterExceptions.filterExceptions(InvalidKeyException.class, InvalidMessageException.class, () -> Native.DecryptionErrorMessage_Deserialize(serialized)));
    }

    public static DecryptionErrorMessage forOriginalMessage(byte[] originalBytes, int messageType, long timestamp, int originalSenderDeviceId) {
        return new DecryptionErrorMessage(FilterExceptions.filterExceptions(() -> Native.DecryptionErrorMessage_ForOriginalMessage(originalBytes, messageType, timestamp, originalSenderDeviceId)));
    }

    public byte[] serialize() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::DecryptionErrorMessage_GetSerialized));
    }

    public Optional<ECPublicKey> getRatchetKey() {
        long keyHandle = this.guardedMap(Native::DecryptionErrorMessage_GetRatchetKey);
        if (keyHandle == 0L) {
            return Optional.empty();
        }
        return Optional.of(new ECPublicKey(keyHandle));
    }

    public long getTimestamp() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::DecryptionErrorMessage_GetTimestamp));
    }

    public int getDeviceId() {
        return FilterExceptions.filterExceptions(() -> this.guardedMapChecked(Native::DecryptionErrorMessage_GetDeviceId));
    }

    public static DecryptionErrorMessage extractFromSerializedContent(byte[] serializedContentBytes) throws InvalidMessageException {
        return new DecryptionErrorMessage(FilterExceptions.filterExceptions(InvalidMessageException.class, () -> Native.DecryptionErrorMessage_ExtractFromSerializedContent(serializedContentBytes)));
    }
}

