/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.protocol.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.protocol.logging.SignalProtocolLogger;
import org.signal.libsignal.protocol.logging.SignalProtocolLoggerProvider;

public class Log {
    private Log() {
    }

    public static void v(String tag, String msg) {
        Log.log(2, tag, msg);
    }

    public static void v(String tag, String msg, Throwable tr) {
        Log.log(2, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static void d(String tag, String msg) {
        Log.log(3, tag, msg);
    }

    public static void d(String tag, String msg, Throwable tr) {
        Log.log(3, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static void i(String tag, String msg) {
        Log.log(4, tag, msg);
    }

    public static void i(String tag, String msg, Throwable tr) {
        Log.log(4, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static void w(String tag, String msg) {
        Log.log(5, tag, msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        Log.log(5, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    public static void w(String tag, Throwable tr) {
        Log.log(5, tag, Log.getStackTraceString(tr));
    }

    public static void e(String tag, String msg) {
        Log.log(6, tag, msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        Log.log(6, tag, msg + "\n" + Log.getStackTraceString(tr));
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private static void log(int priority, String tag, String msg) {
        SignalProtocolLogger logger = SignalProtocolLoggerProvider.getProvider();
        if (logger != null) {
            logger.log(priority, tag, msg);
        }
    }

    @CalledFromNative
    private static void logFromRust(int priority, String msg) {
        Log.log(priority, "libsignal", msg);
    }
}

