/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Objects;
import java.util.function.Function;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509v1CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequest;
import org.shredzone.acme4j.Identifier;

public final class CertificateUtils {
    public static final ASN1ObjectIdentifier ACME_VALIDATION = new ASN1ObjectIdentifier("1.3.6.1.5.5.7.1.31").intern();

    private CertificateUtils() {
    }

    public static PKCS10CertificationRequest readCSR(InputStream in) throws IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new InputStreamReader(in, StandardCharsets.US_ASCII));){
            Object parsedObj = pemParser.readObject();
            if (!(parsedObj instanceof PKCS10CertificationRequest)) {
                throw new IOException("Not a PKCS10 CSR");
            }
            PKCS10CertificationRequest pKCS10CertificationRequest = (PKCS10CertificationRequest)parsedObj;
            return pKCS10CertificationRequest;
        }
    }

    public static X509Certificate createTlsAlpn01Certificate(KeyPair keypair, Identifier id, byte[] acmeValidation) throws IOException {
        Objects.requireNonNull(keypair, "keypair");
        Objects.requireNonNull(id, "id");
        if (acmeValidation == null || acmeValidation.length != 32) {
            throw new IllegalArgumentException("Bad acmeValidation parameter");
        }
        long now = System.currentTimeMillis();
        X500Name issuer = new X500Name("CN=acme.invalid");
        BigInteger serial = BigInteger.valueOf(now);
        Instant notBefore = Instant.ofEpochMilli(now);
        Instant notAfter = notBefore.plus(Duration.ofDays(7L));
        JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(issuer, serial, Date.from(notBefore), Date.from(notAfter), issuer, keypair.getPublic());
        GeneralName[] gns = new GeneralName[1];
        switch (id.getType()) {
            case "dns": {
                gns[0] = new GeneralName(2, id.getDomain());
                break;
            }
            case "ip": {
                gns[0] = new GeneralName(7, id.getIP().getHostAddress());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Identifier type " + id.getType());
            }
        }
        certBuilder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(gns));
        certBuilder.addExtension(ACME_VALIDATION, true, (ASN1Encodable)new DEROctetString(acmeValidation));
        return CertificateUtils.buildCertificate(arg_0 -> ((JcaX509v3CertificateBuilder)certBuilder).build(arg_0), keypair.getPrivate());
    }

    public static X509Certificate createTestRootCertificate(String subject, Instant notBefore, Instant notAfter, KeyPair keypair) {
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(notBefore, "notBefore");
        Objects.requireNonNull(notAfter, "notAfter");
        Objects.requireNonNull(keypair, "keypair");
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(new X500Name(subject), BigInteger.valueOf(System.currentTimeMillis()), Date.from(notBefore), Date.from(notAfter), new X500Name(subject), keypair.getPublic());
        return CertificateUtils.buildCertificate(arg_0 -> ((JcaX509v1CertificateBuilder)certBuilder).build(arg_0), keypair.getPrivate());
    }

    public static X509Certificate createTestIntermediateCertificate(String subject, Instant notBefore, Instant notAfter, PublicKey intermediatePublicKey, X509Certificate issuer, PrivateKey issuerPrivateKey) {
        Objects.requireNonNull(subject, "subject");
        Objects.requireNonNull(notBefore, "notBefore");
        Objects.requireNonNull(notAfter, "notAfter");
        Objects.requireNonNull(intermediatePublicKey, "intermediatePublicKey");
        Objects.requireNonNull(issuer, "issuer");
        Objects.requireNonNull(issuerPrivateKey, "issuerPrivateKey");
        JcaX509v1CertificateBuilder certBuilder = new JcaX509v1CertificateBuilder(new X500Name(issuer.getIssuerX500Principal().getName()), BigInteger.valueOf(System.currentTimeMillis()), Date.from(notBefore), Date.from(notAfter), new X500Name(subject), intermediatePublicKey);
        return CertificateUtils.buildCertificate(arg_0 -> ((JcaX509v1CertificateBuilder)certBuilder).build(arg_0), issuerPrivateKey);
    }

    public static X509Certificate createTestCertificate(PKCS10CertificationRequest csr, Instant notBefore, Instant notAfter, X509Certificate issuer, PrivateKey issuerPrivateKey) {
        Objects.requireNonNull(csr, "csr");
        Objects.requireNonNull(notBefore, "notBefore");
        Objects.requireNonNull(notAfter, "notAfter");
        Objects.requireNonNull(issuer, "issuer");
        Objects.requireNonNull(issuerPrivateKey, "issuerPrivateKey");
        try {
            ASN1Encodable[] extensions;
            JcaPKCS10CertificationRequest jcaCsr = new JcaPKCS10CertificationRequest(csr);
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(new X500Name(issuer.getIssuerX500Principal().getName()), BigInteger.valueOf(System.currentTimeMillis()), Date.from(notBefore), Date.from(notAfter), csr.getSubject(), jcaCsr.getPublicKey());
            Attribute[] attr = csr.getAttributes(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest);
            if (attr.length > 0 && (extensions = attr[0].getAttrValues().toArray()).length > 0 && extensions[0] instanceof Extensions) {
                GeneralNames san = GeneralNames.fromExtensions((Extensions)((Extensions)extensions[0]), (ASN1ObjectIdentifier)Extension.subjectAlternativeName);
                boolean critical = csr.getSubject().getRDNs().length == 0;
                certBuilder.addExtension(Extension.subjectAlternativeName, critical, (ASN1Encodable)san);
            }
            return CertificateUtils.buildCertificate(arg_0 -> ((JcaX509v3CertificateBuilder)certBuilder).build(arg_0), issuerPrivateKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | CertIOException ex) {
            throw new IllegalArgumentException("Invalid CSR", ex);
        }
    }

    private static X509Certificate buildCertificate(Function<ContentSigner, X509CertificateHolder> builder, PrivateKey privateKey) {
        try {
            JcaContentSignerBuilder signerBuilder = new JcaContentSignerBuilder("SHA256withRSA");
            byte[] cert = builder.apply(signerBuilder.build(privateKey)).getEncoded();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(cert));
        }
        catch (IOException | CertificateException | OperatorCreationException ex) {
            throw new IllegalArgumentException("Could not build certificate", ex);
        }
    }
}

