/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider.pebble;

import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.shredzone.acme4j.connector.HttpConnector;
import org.shredzone.acme4j.connector.NetworkSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PebbleHttpConnector
extends HttpConnector {
    private static final Logger LOG = LoggerFactory.getLogger(PebbleHttpConnector.class);
    private static final AtomicReference<SSLContext> SSL_CONTEXT_REF = new AtomicReference();

    public PebbleHttpConnector(NetworkSettings settings) {
        super(settings);
    }

    @Override
    public HttpClient.Builder createClientBuilder() {
        HttpClient.Builder builder = super.createClientBuilder();
        builder.sslContext(this.createSSLContext());
        return builder;
    }

    protected SSLContext createSSLContext() {
        if (SSL_CONTEXT_REF.get() == null) {
            try {
                KeyStore keystore = this.readPemFile("/pebble.minica.pem").or(() -> this.readPemFile("/META-INF/pebble.minica.pem")).or(() -> this.readPemFile("/org/shredzone/acme4j/provider/pebble/pebble.minica.pem")).orElseThrow(() -> new RuntimeException("Could not find a Pebble root certificate"));
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keystore);
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, tmf.getTrustManagers(), null);
                SSL_CONTEXT_REF.set(sslContext);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                throw new RuntimeException("Could not create truststore", ex);
            }
        }
        return Objects.requireNonNull(SSL_CONTEXT_REF.get());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<KeyStore> readPemFile(String resource) {
        try (InputStream in = this.getClass().getResourceAsStream(resource);){
            if (in == null) {
                Optional<KeyStore> optional2 = Optional.empty();
                return optional2;
            }
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(in);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null, "acme4j".toCharArray());
            keystore.setCertificateEntry("pebble", cert);
            Optional<KeyStore> optional = Optional.of(keystore);
            return optional;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
            LOG.error("Failed to read PEM from resource '{}'", (Object)resource, (Object)ex);
            return Optional.empty();
        }
    }
}

