/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.connector;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.Session;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeRetryAfterException;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;

public interface Connection
extends AutoCloseable {
    public void resetNonce(Session var1) throws AcmeException;

    public int sendRequest(URL var1, Session var2, @Nullable ZonedDateTime var3) throws AcmeException;

    public int sendCertificateRequest(URL var1, Login var2) throws AcmeException;

    public int sendSignedPostAsGetRequest(URL var1, Login var2) throws AcmeException;

    public int sendSignedRequest(URL var1, JSONBuilder var2, Login var3) throws AcmeException;

    public int sendSignedRequest(URL var1, JSONBuilder var2, Session var3, KeyPair var4) throws AcmeException;

    public JSON readJsonResponse() throws AcmeException;

    public List<X509Certificate> readCertificates() throws AcmeException;

    public Optional<Instant> getRetryAfter();

    @Deprecated
    default public void handleRetryAfter(String message) throws AcmeException {
        Optional<Instant> retryAfter = this.getRetryAfter();
        if (retryAfter.isPresent()) {
            throw new AcmeRetryAfterException(message, retryAfter.get());
        }
    }

    public Optional<String> getNonce();

    public URL getLocation();

    public Optional<ZonedDateTime> getLastModified();

    public Optional<ZonedDateTime> getExpiration();

    public Collection<URL> getLinks(String var1);

    @Override
    public void close();
}

