/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j;

import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.security.KeyPair;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.shredzone.acme4j.AcmeJsonResource;
import org.shredzone.acme4j.Authorization;
import org.shredzone.acme4j.Certificate;
import org.shredzone.acme4j.Identifier;
import org.shredzone.acme4j.Login;
import org.shredzone.acme4j.PollableResource;
import org.shredzone.acme4j.Problem;
import org.shredzone.acme4j.Status;
import org.shredzone.acme4j.connector.Connection;
import org.shredzone.acme4j.exception.AcmeException;
import org.shredzone.acme4j.exception.AcmeNotSupportedException;
import org.shredzone.acme4j.toolbox.JSON;
import org.shredzone.acme4j.toolbox.JSONBuilder;
import org.shredzone.acme4j.util.CSRBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Order
extends AcmeJsonResource
implements PollableResource {
    private static final long serialVersionUID = 5435808648658292177L;
    private static final Logger LOG = LoggerFactory.getLogger(Order.class);
    @Nullable
    private transient Certificate certificate = null;
    @Nullable
    private transient Certificate autoRenewalCertificate = null;
    @Nullable
    private transient List<Authorization> authorizations = null;

    protected Order(Login login, URL location) {
        super(login, location);
    }

    @Override
    public Status getStatus() {
        return this.getJSON().get("status").asStatus();
    }

    public Optional<Problem> getError() {
        return this.getJSON().get("error").map(v -> v.asProblem(this.getLocation()));
    }

    public Optional<Instant> getExpires() {
        return this.getJSON().get("expires").map(JSON.Value::asInstant);
    }

    public List<Identifier> getIdentifiers() {
        return this.getJSON().get("identifiers").asArray().stream().map(JSON.Value::asIdentifier).collect(Collectors.toUnmodifiableList());
    }

    public Optional<Instant> getNotBefore() {
        return this.getJSON().get("notBefore").map(JSON.Value::asInstant);
    }

    public Optional<Instant> getNotAfter() {
        return this.getJSON().get("notAfter").map(JSON.Value::asInstant);
    }

    public List<Authorization> getAuthorizations() {
        if (this.authorizations == null) {
            Login login = this.getLogin();
            this.authorizations = this.getJSON().get("authorizations").asArray().stream().map(JSON.Value::asURL).map(login::bindAuthorization).collect(Collectors.toList());
        }
        return Collections.unmodifiableList(this.authorizations);
    }

    public URL getFinalizeLocation() {
        return this.getJSON().get("finalize").asURL();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Certificate getCertificate() {
        if (this.certificate == null) {
            this.certificate = this.getJSON().get("star-certificate").optional().or(() -> this.getJSON().get("certificate").optional()).map(JSON.Value::asURL).map(this.getLogin()::bindCertificate).orElseThrow(() -> new IllegalStateException("Order is not completed"));
        }
        return this.certificate;
    }

    @Deprecated
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public Certificate getAutoRenewalCertificate() {
        if (this.autoRenewalCertificate == null) {
            this.autoRenewalCertificate = this.getJSON().get("star-certificate").optional().map(JSON.Value::asURL).map(this.getLogin()::bindCertificate).orElseThrow(() -> new IllegalStateException("Order is in an invalid state"));
        }
        return this.autoRenewalCertificate;
    }

    public boolean isAutoRenewalCertificate() {
        return this.getJSON().contains("star-certificate");
    }

    public void execute(KeyPair domainKeyPair) throws AcmeException {
        this.execute(domainKeyPair, csrBuilder -> {});
    }

    public void execute(KeyPair domainKeyPair, Consumer<CSRBuilder> builderConsumer) throws AcmeException {
        try {
            CSRBuilder csrBuilder = new CSRBuilder();
            csrBuilder.addIdentifiers(this.getIdentifiers());
            builderConsumer.accept(csrBuilder);
            csrBuilder.sign(domainKeyPair);
            this.execute(csrBuilder.getCSR());
        }
        catch (IOException ex) {
            throw new AcmeException("Failed to create CSR", ex);
        }
    }

    public void execute(PKCS10CertificationRequest csr) throws AcmeException {
        try {
            this.execute(csr.getEncoded());
        }
        catch (IOException ex) {
            throw new AcmeException("Invalid CSR", ex);
        }
    }

    public void execute(byte[] csr) throws AcmeException {
        LOG.debug("finalize");
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.putBase64("csr", csr);
            conn.sendSignedRequest(this.getFinalizeLocation(), claims, this.getLogin());
        }
        this.invalidate();
    }

    public Status waitUntilReady(Duration timeout) throws AcmeException, InterruptedException {
        return this.waitForStatus(EnumSet.of(Status.READY, Status.VALID, Status.INVALID), timeout);
    }

    public Status waitForCompletion(Duration timeout) throws AcmeException, InterruptedException {
        return this.waitForStatus(EnumSet.of(Status.VALID, Status.INVALID), timeout);
    }

    public boolean isAutoRenewing() {
        return this.getJSON().get("auto-renewal").optional().isPresent();
    }

    public Optional<Instant> getAutoRenewalStartDate() {
        return this.getJSON().getFeature("auto-renewal").map(JSON.Value::asObject).orElseGet(JSON::empty).get("start-date").optional().map(JSON.Value::asInstant);
    }

    public Instant getAutoRenewalEndDate() {
        return this.getJSON().getFeature("auto-renewal").map(JSON.Value::asObject).orElseGet(JSON::empty).get("end-date").asInstant();
    }

    public Duration getAutoRenewalLifetime() {
        return this.getJSON().getFeature("auto-renewal").optional().map(JSON.Value::asObject).orElseGet(JSON::empty).get("lifetime").asDuration();
    }

    public Optional<Duration> getAutoRenewalLifetimeAdjust() {
        return this.getJSON().getFeature("auto-renewal").optional().map(JSON.Value::asObject).orElseGet(JSON::empty).get("lifetime-adjust").optional().map(JSON.Value::asDuration);
    }

    public boolean isAutoRenewalGetEnabled() {
        return this.getJSON().getFeature("auto-renewal").optional().map(JSON.Value::asObject).orElseGet(JSON::empty).get("allow-certificate-get").optional().map(JSON.Value::asBoolean).orElse(false);
    }

    public void cancelAutoRenewal() throws AcmeException {
        if (!this.getSession().getMetadata().isAutoRenewalEnabled()) {
            throw new AcmeNotSupportedException("auto-renewal");
        }
        LOG.debug("cancel");
        try (Connection conn = this.getSession().connect();){
            JSONBuilder claims = new JSONBuilder();
            claims.put("status", "canceled");
            conn.sendSignedRequest(this.getLocation(), claims, this.getLogin());
            this.setJSON(conn.readJsonResponse());
        }
    }

    public String getProfile() {
        return this.getJSON().getFeature("profile").asString();
    }

    @Override
    protected void invalidate() {
        super.invalidate();
        this.certificate = null;
        this.autoRenewalCertificate = null;
        this.authorizations = null;
    }
}

