/*
 * Decompiled with CFR 0.152.
 */
package mjson;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Json {
    public static final Factory defaultFactory;
    private static Factory globalFactory;
    private static ThreadLocal<Factory> threadFactory;
    Json enclosing = null;
    static NullJson topnull;
    static Escaper escaper;

    static String fetchContent(URL url) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)url.getContent());
            StringBuilder content = new StringBuilder();
            char[] buf = new char[1024];
            int n = reader.read(buf);
            while (n > -1) {
                content.append(buf, 0, n);
                n = reader.read(buf);
            }
            String string = content.toString();
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            if (reader != null) {
                try {
                    ((java.io.Reader)reader).close();
                }
                catch (Throwable t) {}
            }
        }
    }

    static Json resolvePointer(String pointerRepresentation, Json top) {
        String[] parts = pointerRepresentation.split("/");
        Json result = top;
        for (String p : parts) {
            if (p.length() == 0) continue;
            p = p.replace("~1", "/").replace("~0", "~");
            if (result.isArray()) {
                result = result.at(Integer.parseInt(p));
                continue;
            }
            if (result.isObject()) {
                result = result.at(p);
                continue;
            }
            throw new RuntimeException("Can't resolve pointer " + pointerRepresentation + " on document " + top.toString(200));
        }
        return result;
    }

    static URI makeAbsolute(URI base, String ref) throws Exception {
        URI refuri;
        if (base != null && !new URI(ref).isAbsolute()) {
            StringBuilder sb = new StringBuilder().append(base.getScheme()).append("://").append(base.getHost());
            if (base.getPort() > -1) {
                sb.append(":").append(Integer.toString(base.getPort()));
            }
            if (!ref.startsWith("/")) {
                sb.append(base.getPath()).append(ref.startsWith("#") ? "" : "/");
            }
            refuri = new URI(sb.append(ref).toString());
        } else {
            refuri = new URI(ref);
        }
        return refuri;
    }

    static Json resolveRef(URI base, Json refdoc, URI refuri, Map<String, Json> resolved, Map<Json, Json> expanded) throws Exception {
        if (!(!refuri.isAbsolute() || base != null && base.isAbsolute() && base.getScheme().equals(refuri.getScheme()) && base.getHost().equals(refuri.getHost()) && base.getPort() == refuri.getPort() && base.getPath().equals(refuri.getPath()))) {
            refuri = refuri.normalize();
            URI docuri = new URI(refuri.getScheme() + "://" + refuri.getHost() + (refuri.getPort() > -1 ? ":" + refuri.getPort() : "") + refuri.getPath());
            refdoc = Json.read(Json.fetchContent(docuri.toURL()));
            refdoc = Json.expandReferences(refdoc, refdoc, docuri, resolved, expanded);
        }
        if (refuri.getFragment() == null) {
            return refdoc;
        }
        return Json.resolvePointer(refuri.getFragment(), refdoc);
    }

    static Json expandReferences(Json json, Json topdoc, URI base, Map<String, Json> resolved, Map<Json, Json> expanded) throws Exception {
        if (expanded.containsKey(json)) {
            return json;
        }
        if (json.isObject()) {
            if (json.has("id") && json.at("id").isString()) {
                base = base.resolve(json.at("id").asString());
            }
            if (json.has("$ref")) {
                URI refuri = base.resolve(json.at("$ref").asString());
                Json ref = resolved.get(refuri.toString());
                if (ref == null) {
                    ref = Json.resolveRef(base, topdoc, refuri, resolved, expanded);
                    resolved.put(refuri.toString(), ref);
                    ref = Json.expandReferences(ref, topdoc, base, resolved, expanded);
                    resolved.put(refuri.toString(), ref);
                }
                json = ref;
            } else {
                Json O = Json.object();
                for (Map.Entry<String, Json> e : json.asJsonMap().entrySet()) {
                    O.set(e.getKey(), Json.expandReferences(e.getValue(), topdoc, base, resolved, expanded));
                }
                json.with(O);
            }
        } else if (json.isArray()) {
            for (int i = 0; i < json.asJsonList().size(); ++i) {
                Json el = Json.expandReferences(json.at(i), topdoc, base, resolved, expanded);
                json.set(i, (Object)el);
            }
        }
        expanded.put(json, json);
        return json;
    }

    public static Schema schema(Json S) {
        return new DefaultSchema(null, S);
    }

    public static Schema schema(URI uri) {
        try {
            return new DefaultSchema(uri, Json.read(Json.fetchContent(uri.toURL())));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Schema schema(Json S, URI uri) {
        return new DefaultSchema(uri, S);
    }

    private static Factory factory() {
        Factory f = threadFactory.get();
        return f != null ? f : globalFactory;
    }

    public static void setGlobalFactory(Factory factory) {
        globalFactory = factory;
    }

    public static void attachFactory(Factory factory) {
        threadFactory.set(factory);
    }

    public static void dettachFactory() {
        threadFactory.remove();
    }

    public static Json read(String jsonAsString) {
        return (Json)new Reader().read(jsonAsString);
    }

    public static Json read(URL location) {
        return (Json)new Reader().read(Json.fetchContent(location));
    }

    public static Json read(CharacterIterator it) {
        return (Json)new Reader().read(it);
    }

    public static Json nil() {
        return Json.factory().nil();
    }

    public static Json object() {
        return Json.factory().object();
    }

    public static Json object(Object ... args) {
        Json j = Json.object();
        if (args.length % 2 != 0) {
            throw new IllegalArgumentException("An even number of arguments is expected.");
        }
        for (int i = 0; i < args.length; ++i) {
            j.set(args[i].toString(), Json.factory().make(args[++i]));
        }
        return j;
    }

    public static Json array() {
        return Json.factory().array();
    }

    public static Json array(Object ... args) {
        Json A = Json.array();
        for (Object x : args) {
            A.add(Json.factory().make(x));
        }
        return A;
    }

    public static Json make(Object anything) {
        return Json.factory().make(anything);
    }

    protected Json() {
    }

    protected Json(Json enclosing) {
        this.enclosing = enclosing;
    }

    public String toString(int maxCharacters) {
        return this.toString();
    }

    public void attachTo(Json enclosing) {
        this.enclosing = enclosing;
    }

    public final Json up() {
        return this.enclosing;
    }

    public Json dup() {
        return this;
    }

    public Json at(int index) {
        throw new UnsupportedOperationException();
    }

    public Json at(String property) {
        throw new UnsupportedOperationException();
    }

    public final Json at(String property, Json def) {
        Json x = this.at(property);
        if (x == null) {
            this.set(property, def);
            return def;
        }
        return x;
    }

    public final Json at(String property, Object def) {
        return this.at(property, Json.make(def));
    }

    public boolean has(String property) {
        throw new UnsupportedOperationException();
    }

    public boolean is(String property, Object value) {
        throw new UnsupportedOperationException();
    }

    public boolean is(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public Json add(Json el) {
        throw new UnsupportedOperationException();
    }

    public final Json add(Object anything) {
        return this.add(Json.make(anything));
    }

    public Json atDel(String property) {
        throw new UnsupportedOperationException();
    }

    public Json atDel(int index) {
        throw new UnsupportedOperationException();
    }

    public Json delAt(String property) {
        throw new UnsupportedOperationException();
    }

    public Json delAt(int index) {
        throw new UnsupportedOperationException();
    }

    public Json remove(Json el) {
        throw new UnsupportedOperationException();
    }

    public final Json remove(Object anything) {
        return this.remove(Json.make(anything));
    }

    public Json set(String property, Json value) {
        throw new UnsupportedOperationException();
    }

    public final Json set(String property, Object value) {
        return this.set(property, Json.make(value));
    }

    public Json set(int index, Object value) {
        throw new UnsupportedOperationException();
    }

    public Json with(Json object) {
        throw new UnsupportedOperationException();
    }

    public Object getValue() {
        throw new UnsupportedOperationException();
    }

    public boolean asBoolean() {
        throw new UnsupportedOperationException();
    }

    public String asString() {
        throw new UnsupportedOperationException();
    }

    public int asInteger() {
        throw new UnsupportedOperationException();
    }

    public float asFloat() {
        throw new UnsupportedOperationException();
    }

    public double asDouble() {
        throw new UnsupportedOperationException();
    }

    public long asLong() {
        throw new UnsupportedOperationException();
    }

    public short asShort() {
        throw new UnsupportedOperationException();
    }

    public byte asByte() {
        throw new UnsupportedOperationException();
    }

    public char asChar() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> asMap() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Json> asJsonMap() {
        throw new UnsupportedOperationException();
    }

    public List<Object> asList() {
        throw new UnsupportedOperationException();
    }

    public List<Json> asJsonList() {
        throw new UnsupportedOperationException();
    }

    public boolean isNull() {
        return false;
    }

    public boolean isString() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isArray() {
        return false;
    }

    public boolean isObject() {
        return false;
    }

    public boolean isPrimitive() {
        return this.isString() || this.isNumber() || this.isBoolean();
    }

    public String pad(String callback) {
        return callback != null && callback.length() > 0 ? callback + "(" + this.toString() + ");" : this.toString();
    }

    static {
        globalFactory = defaultFactory = new DefaultFactory();
        threadFactory = new ThreadLocal();
        topnull = new NullJson();
        escaper = new Escaper(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Reader {
        private static final Object OBJECT_END = new Object();
        private static final Object ARRAY_END = new Object();
        private static final Object COLON = new Object();
        private static final Object COMMA = new Object();
        public static final int FIRST = 0;
        public static final int CURRENT = 1;
        public static final int NEXT = 2;
        private static Map<Character, Character> escapes = new HashMap<Character, Character>();
        private CharacterIterator it;
        private char c;
        private Object token;
        private StringBuffer buf = new StringBuffer();

        private Reader() {
        }

        private char next() {
            if (this.it.getIndex() == this.it.getEndIndex()) {
                throw new RuntimeException("Reached end of input at the " + this.it.getIndex() + "th character.");
            }
            this.c = this.it.next();
            return this.c;
        }

        private char previous() {
            this.c = this.it.previous();
            return this.c;
        }

        private void skipWhiteSpace() {
            do {
                if (Character.isWhitespace(this.c)) continue;
                if (this.c != '/') break;
                this.next();
                if (this.c == '*') {
                    while (this.c != '\uffff' && (this.next() != '*' || this.next() != '/')) {
                    }
                    if (this.c != '\uffff') continue;
                    throw new RuntimeException("Unterminated comment while parsing JSON string.");
                }
                if (this.c == '/') {
                    while (this.c != '\n' && this.c != '\uffff') {
                        this.next();
                    }
                } else {
                    this.previous();
                    break;
                }
            } while (this.next() != '\uffff');
        }

        public Object read(CharacterIterator ci, int start) {
            this.it = ci;
            switch (start) {
                case 0: {
                    this.c = this.it.first();
                    break;
                }
                case 1: {
                    this.c = this.it.current();
                    break;
                }
                case 2: {
                    this.c = this.it.next();
                }
            }
            return this.read();
        }

        public Object read(CharacterIterator it) {
            return this.read(it, 2);
        }

        public Object read(String string) {
            return this.read(new StringCharacterIterator(string), 0);
        }

        private <T> T read() {
            this.skipWhiteSpace();
            char ch = this.c;
            this.next();
            switch (ch) {
                case '\"': {
                    this.token = this.readString();
                    break;
                }
                case '[': {
                    this.token = this.readArray();
                    break;
                }
                case ']': {
                    this.token = ARRAY_END;
                    break;
                }
                case ',': {
                    this.token = COMMA;
                    break;
                }
                case '{': {
                    this.token = this.readObject();
                    break;
                }
                case '}': {
                    this.token = OBJECT_END;
                    break;
                }
                case ':': {
                    this.token = COLON;
                    break;
                }
                case 't': {
                    if (this.c != 'r' || this.next() != 'u' || this.next() != 'e') {
                        throw new RuntimeException("Invalid JSON token: expected 'true' keyword.");
                    }
                    this.next();
                    this.token = Json.factory().bool(Boolean.TRUE);
                    break;
                }
                case 'f': {
                    if (this.c != 'a' || this.next() != 'l' || this.next() != 's' || this.next() != 'e') {
                        throw new RuntimeException("Invalid JSON token: expected 'false' keyword.");
                    }
                    this.next();
                    this.token = Json.factory().bool(Boolean.FALSE);
                    break;
                }
                case 'n': {
                    if (this.c != 'u' || this.next() != 'l' || this.next() != 'l') {
                        throw new RuntimeException("Invalid JSON token: expected 'null' keyword.");
                    }
                    this.next();
                    this.token = Json.nil();
                    break;
                }
                default: {
                    this.c = this.it.previous();
                    if (Character.isDigit(this.c) || this.c == '-') {
                        this.token = this.readNumber();
                        break;
                    }
                    throw new RuntimeException("Invalid JSON near position: " + this.it.getIndex());
                }
            }
            return (T)this.token;
        }

        private String readObjectKey() {
            Object key = this.read();
            if (key == null) {
                throw new RuntimeException("Missing object key (don't forget to put quotes!).");
            }
            if (key != OBJECT_END) {
                return ((Json)key).asString();
            }
            return key.toString();
        }

        private Json readObject() {
            Json ret = Json.object();
            String key = this.readObjectKey();
            while (this.token != OBJECT_END) {
                this.read();
                if (this.token == OBJECT_END) continue;
                Json value = (Json)this.read();
                ret.set(key, value);
                if (this.read() != COMMA) continue;
                key = this.readObjectKey();
            }
            return ret;
        }

        private Json readArray() {
            Json ret = Json.array();
            Object value = this.read();
            while (this.token != ARRAY_END) {
                ret.add((Json)value);
                if (this.read() == COMMA) {
                    value = this.read();
                    continue;
                }
                if (this.token == ARRAY_END) continue;
                throw new RuntimeException("Unexpected token in array " + this.token);
            }
            return ret;
        }

        private Json readNumber() {
            int length = 0;
            boolean isFloatingPoint = false;
            this.buf.setLength(0);
            if (this.c == '-') {
                this.add();
            }
            length += this.addDigits();
            if (this.c == '.') {
                this.add();
                length += this.addDigits();
                isFloatingPoint = true;
            }
            if (this.c == 'e' || this.c == 'E') {
                this.add();
                if (this.c == '+' || this.c == '-') {
                    this.add();
                }
                this.addDigits();
                isFloatingPoint = true;
            }
            String s = this.buf.toString();
            Number n = isFloatingPoint ? (Number)(length < 17 ? Double.valueOf(s) : new BigDecimal(s)) : (Number)(length < 20 ? Long.valueOf(s) : new BigInteger(s));
            return Json.factory().number(n);
        }

        private int addDigits() {
            int ret = 0;
            while (Character.isDigit(this.c)) {
                this.add();
                ++ret;
            }
            return ret;
        }

        private Json readString() {
            this.buf.setLength(0);
            while (this.c != '\"') {
                if (this.c == '\\') {
                    this.next();
                    if (this.c == 'u') {
                        this.add(this.unicode());
                        continue;
                    }
                    Character value = escapes.get(new Character(this.c));
                    if (value == null) continue;
                    this.add(value.charValue());
                    continue;
                }
                this.add();
            }
            this.next();
            return Json.factory().string(this.buf.toString());
        }

        private void add(char cc) {
            this.buf.append(cc);
            this.next();
        }

        private void add() {
            this.add(this.c);
        }

        private char unicode() {
            int value = 0;
            block5: for (int i = 0; i < 4; ++i) {
                switch (this.next()) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = (value << 4) + this.c - 48;
                        continue block5;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        value = (value << 4) + (this.c - 97) + 10;
                        continue block5;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        value = (value << 4) + (this.c - 65) + 10;
                    }
                }
            }
            return (char)value;
        }

        static {
            escapes.put(new Character('\"'), new Character('\"'));
            escapes.put(new Character('\\'), new Character('\\'));
            escapes.put(new Character('/'), new Character('/'));
            escapes.put(new Character('b'), new Character('\b'));
            escapes.put(new Character('f'), new Character('\f'));
            escapes.put(new Character('n'), new Character('\n'));
            escapes.put(new Character('r'), new Character('\r'));
            escapes.put(new Character('t'), new Character('\t'));
        }
    }

    static final class Escaper {
        private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        private static final Set<Character> JS_ESCAPE_CHARS;
        private static final Set<Character> HTML_ESCAPE_CHARS;
        private final boolean escapeHtmlCharacters;

        Escaper(boolean escapeHtmlCharacters) {
            this.escapeHtmlCharacters = escapeHtmlCharacters;
        }

        public String escapeJsonString(CharSequence plainText) {
            StringBuilder escapedString = new StringBuilder(plainText.length() + 20);
            try {
                this.escapeJsonString(plainText, escapedString);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return escapedString.toString();
        }

        private void escapeJsonString(CharSequence plainText, StringBuilder out) throws IOException {
            int charCount;
            int pos = 0;
            int len = plainText.length();
            block10: for (int i = 0; i < len; i += charCount) {
                int codePoint = Character.codePointAt(plainText, i);
                charCount = Character.charCount(codePoint);
                if (!Escaper.isControlCharacter(codePoint) && !this.mustEscapeCharInJsString(codePoint)) continue;
                out.append(plainText, pos, i);
                pos = i + charCount;
                switch (codePoint) {
                    case 8: {
                        out.append("\\b");
                        continue block10;
                    }
                    case 9: {
                        out.append("\\t");
                        continue block10;
                    }
                    case 10: {
                        out.append("\\n");
                        continue block10;
                    }
                    case 12: {
                        out.append("\\f");
                        continue block10;
                    }
                    case 13: {
                        out.append("\\r");
                        continue block10;
                    }
                    case 92: {
                        out.append("\\\\");
                        continue block10;
                    }
                    case 47: {
                        out.append("\\/");
                        continue block10;
                    }
                    case 34: {
                        out.append("\\\"");
                        continue block10;
                    }
                    default: {
                        Escaper.appendHexJavaScriptRepresentation(codePoint, out);
                    }
                }
            }
            out.append(plainText, pos, len);
        }

        private boolean mustEscapeCharInJsString(int codepoint) {
            if (!Character.isSupplementaryCodePoint(codepoint)) {
                char c = (char)codepoint;
                return JS_ESCAPE_CHARS.contains(Character.valueOf(c)) || this.escapeHtmlCharacters && HTML_ESCAPE_CHARS.contains(Character.valueOf(c));
            }
            return false;
        }

        private static boolean isControlCharacter(int codePoint) {
            return codePoint < 32 || codePoint == 8232 || codePoint == 8233 || codePoint >= 127 && codePoint <= 159;
        }

        private static void appendHexJavaScriptRepresentation(int codePoint, Appendable out) throws IOException {
            if (Character.isSupplementaryCodePoint(codePoint)) {
                char[] surrogates = Character.toChars(codePoint);
                Escaper.appendHexJavaScriptRepresentation(surrogates[0], out);
                Escaper.appendHexJavaScriptRepresentation(surrogates[1], out);
                return;
            }
            out.append("\\u").append(HEX_CHARS[codePoint >>> 12 & 0xF]).append(HEX_CHARS[codePoint >>> 8 & 0xF]).append(HEX_CHARS[codePoint >>> 4 & 0xF]).append(HEX_CHARS[codePoint & 0xF]);
        }

        static {
            HashSet<Character> mandatoryEscapeSet = new HashSet<Character>();
            mandatoryEscapeSet.add(Character.valueOf('\"'));
            mandatoryEscapeSet.add(Character.valueOf('\\'));
            JS_ESCAPE_CHARS = Collections.unmodifiableSet(mandatoryEscapeSet);
            HashSet<Character> htmlEscapeSet = new HashSet<Character>();
            htmlEscapeSet.add(Character.valueOf('<'));
            htmlEscapeSet.add(Character.valueOf('>'));
            htmlEscapeSet.add(Character.valueOf('&'));
            htmlEscapeSet.add(Character.valueOf('='));
            htmlEscapeSet.add(Character.valueOf('\''));
            HTML_ESCAPE_CHARS = Collections.unmodifiableSet(htmlEscapeSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ObjectJson
    extends Json {
        Map<String, Json> object = new HashMap<String, Json>();

        ObjectJson() {
        }

        ObjectJson(Json e) {
            super(e);
        }

        @Override
        public Json dup() {
            ObjectJson j = new ObjectJson();
            for (Map.Entry<String, Json> e : this.object.entrySet()) {
                Json v = e.getValue().dup();
                v.enclosing = j;
                j.object.put(e.getKey(), v);
            }
            return j;
        }

        @Override
        public boolean has(String property) {
            return this.object.containsKey(property);
        }

        @Override
        public boolean is(String property, Object value) {
            Json p = this.object.get(property);
            if (p == null) {
                return false;
            }
            return p.equals(ObjectJson.make(value));
        }

        @Override
        public Json at(String property) {
            return this.object.get(property);
        }

        @Override
        public Json with(Json x) {
            if (x == null) {
                return this;
            }
            if (!x.isObject()) {
                throw new UnsupportedOperationException();
            }
            this.object.putAll(((ObjectJson)x).object);
            return this;
        }

        @Override
        public Json set(String property, Json el) {
            if (property == null) {
                throw new IllegalArgumentException("Null property names are not allowed, value is " + el);
            }
            el.enclosing = this;
            this.object.put(property, el);
            return this;
        }

        @Override
        public Json atDel(String property) {
            Json el = this.object.remove(property);
            if (el != null) {
                el.enclosing = null;
            }
            return el;
        }

        @Override
        public Json delAt(String property) {
            Json el = this.object.remove(property);
            if (el != null) {
                el.enclosing = null;
            }
            return this;
        }

        @Override
        public Object getValue() {
            return this.asMap();
        }

        @Override
        public boolean isObject() {
            return true;
        }

        @Override
        public Map<String, Object> asMap() {
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (Map.Entry<String, Json> e : this.object.entrySet()) {
                m.put(e.getKey(), e.getValue().getValue());
            }
            return m;
        }

        @Override
        public Map<String, Json> asJsonMap() {
            return this.object;
        }

        public String toString() {
            return this.toString(Integer.MAX_VALUE);
        }

        @Override
        public String toString(int maxCharacters) {
            StringBuilder sb = new StringBuilder("{");
            Iterator<Map.Entry<String, Json>> i = this.object.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, Json> x = i.next();
                sb.append('\"');
                sb.append(escaper.escapeJsonString(x.getKey()));
                sb.append('\"');
                sb.append(":");
                String s = x.getValue().toString(maxCharacters);
                if (sb.length() + s.length() > maxCharacters) {
                    s = s.substring(0, Math.max(0, maxCharacters - sb.length()));
                }
                sb.append(s);
                if (i.hasNext()) {
                    sb.append(",");
                }
                if (sb.length() < maxCharacters) continue;
                sb.append("...");
                break;
            }
            sb.append("}");
            return sb.toString();
        }

        public int hashCode() {
            return ((Object)this.object).hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof ObjectJson && ((Object)((ObjectJson)x).object).equals(this.object);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArrayJson
    extends Json {
        List<Json> L = new ArrayList<Json>();

        ArrayJson() {
        }

        ArrayJson(Json e) {
            super(e);
        }

        @Override
        public Json dup() {
            ArrayJson j = new ArrayJson();
            for (Json e : this.L) {
                Json v = e.dup();
                v.enclosing = j;
                j.L.add(v);
            }
            return j;
        }

        @Override
        public Json set(int index, Object value) {
            this.L.set(index, ArrayJson.make(value));
            return this;
        }

        @Override
        public List<Json> asJsonList() {
            return this.L;
        }

        @Override
        public List<Object> asList() {
            ArrayList<Object> A = new ArrayList<Object>();
            for (Json x : this.L) {
                A.add(x.getValue());
            }
            return A;
        }

        @Override
        public boolean is(int index, Object value) {
            if (index < 0 || index >= this.L.size()) {
                return false;
            }
            return this.L.get(index).equals(ArrayJson.make(value));
        }

        @Override
        public Object getValue() {
            return this.asList();
        }

        @Override
        public boolean isArray() {
            return true;
        }

        @Override
        public Json at(int index) {
            return this.L.get(index);
        }

        @Override
        public Json add(Json el) {
            this.L.add(el);
            el.enclosing = this;
            return this;
        }

        @Override
        public Json remove(Json el) {
            this.L.remove(el);
            el.enclosing = null;
            return this;
        }

        @Override
        public Json with(Json object) {
            if (object == null) {
                return this;
            }
            if (!object.isArray()) {
                this.add(object);
            } else {
                this.L.addAll(((ArrayJson)object).L);
            }
            return this;
        }

        @Override
        public Json atDel(int index) {
            Json el = this.L.remove(index);
            if (el != null) {
                el.enclosing = null;
            }
            return el;
        }

        @Override
        public Json delAt(int index) {
            Json el = this.L.remove(index);
            if (el != null) {
                el.enclosing = null;
            }
            return this;
        }

        public String toString() {
            return this.toString(Integer.MAX_VALUE);
        }

        @Override
        public String toString(int maxCharacters) {
            StringBuilder sb = new StringBuilder("[");
            Iterator<Json> i = this.L.iterator();
            while (i.hasNext()) {
                String s = i.next().toString(maxCharacters);
                if (sb.length() + s.length() > maxCharacters) {
                    s = s.substring(0, Math.max(0, maxCharacters - sb.length()));
                } else {
                    sb.append(s);
                }
                if (i.hasNext()) {
                    sb.append(",");
                }
                if (sb.length() < maxCharacters) continue;
                sb.append("...");
                break;
            }
            sb.append("]");
            return sb.toString();
        }

        public int hashCode() {
            return ((Object)this.L).hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof ArrayJson && ((Object)((ArrayJson)x).L).equals(this.L);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NumberJson
    extends Json {
        Number val;

        NumberJson() {
        }

        NumberJson(Json e) {
            super(e);
        }

        NumberJson(Number val, Json e) {
            super(e);
            this.val = val;
        }

        @Override
        public Json dup() {
            return new NumberJson(this.val, null);
        }

        @Override
        public boolean isNumber() {
            return true;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public String asString() {
            return this.val.toString();
        }

        @Override
        public int asInteger() {
            return this.val.intValue();
        }

        @Override
        public float asFloat() {
            return this.val.floatValue();
        }

        @Override
        public double asDouble() {
            return this.val.doubleValue();
        }

        @Override
        public long asLong() {
            return this.val.longValue();
        }

        @Override
        public short asShort() {
            return this.val.shortValue();
        }

        @Override
        public byte asByte() {
            return this.val.byteValue();
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(this.val);
        }

        public String toString() {
            return this.val.toString();
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof NumberJson && this.val.doubleValue() == ((NumberJson)x).val.doubleValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringJson
    extends Json {
        String val;

        StringJson() {
        }

        StringJson(Json e) {
            super(e);
        }

        StringJson(String val, Json e) {
            super(e);
            this.val = val;
        }

        @Override
        public Json dup() {
            return new StringJson(this.val, null);
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public String asString() {
            return this.val;
        }

        @Override
        public int asInteger() {
            return Integer.parseInt(this.val);
        }

        @Override
        public float asFloat() {
            return Float.parseFloat(this.val);
        }

        @Override
        public double asDouble() {
            return Double.parseDouble(this.val);
        }

        @Override
        public long asLong() {
            return Long.parseLong(this.val);
        }

        @Override
        public short asShort() {
            return Short.parseShort(this.val);
        }

        @Override
        public byte asByte() {
            return Byte.parseByte(this.val);
        }

        @Override
        public char asChar() {
            return this.val.charAt(0);
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(this.val);
        }

        public String toString() {
            return '\"' + escaper.escapeJsonString(this.val) + '\"';
        }

        @Override
        public String toString(int maxCharacters) {
            if (this.val.length() <= maxCharacters) {
                return this.toString();
            }
            return '\"' + escaper.escapeJsonString(this.val.subSequence(0, maxCharacters)) + "...\"";
        }

        public int hashCode() {
            return this.val.hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof StringJson && ((StringJson)x).val.equals(this.val);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanJson
    extends Json {
        boolean val;

        BooleanJson() {
        }

        BooleanJson(Json e) {
            super(e);
        }

        BooleanJson(Boolean val, Json e) {
            super(e);
            this.val = val;
        }

        @Override
        public Object getValue() {
            return this.val;
        }

        @Override
        public Json dup() {
            return new BooleanJson(this.val, null);
        }

        @Override
        public boolean asBoolean() {
            return this.val;
        }

        @Override
        public boolean isBoolean() {
            return true;
        }

        public String toString() {
            return this.val ? "true" : "false";
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(this.val);
        }

        public int hashCode() {
            return this.val ? 1 : 0;
        }

        public boolean equals(Object x) {
            return x instanceof BooleanJson && ((BooleanJson)x).val == this.val;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NullJson
    extends Json {
        NullJson() {
        }

        NullJson(Json e) {
            super(e);
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public Json dup() {
            return new NullJson();
        }

        @Override
        public boolean isNull() {
            return true;
        }

        public String toString() {
            return "null";
        }

        @Override
        public List<Object> asList() {
            return Collections.singletonList(null);
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object x) {
            return x instanceof NullJson;
        }
    }

    public static class DefaultFactory
    implements Factory {
        public Json nil() {
            return topnull;
        }

        public Json bool(boolean x) {
            return new BooleanJson(x ? Boolean.TRUE : Boolean.FALSE, null);
        }

        public Json string(String x) {
            return new StringJson(x, null);
        }

        public Json number(Number x) {
            return new NumberJson(x, null);
        }

        public Json array() {
            return new ArrayJson();
        }

        public Json object() {
            return new ObjectJson();
        }

        public Json make(Object anything) {
            if (anything == null) {
                return topnull;
            }
            if (anything instanceof Json) {
                return (Json)anything;
            }
            if (anything instanceof String) {
                return Json.factory().string((String)anything);
            }
            if (anything instanceof Collection) {
                Json L = this.array();
                for (Object x : (Collection)anything) {
                    L.add(Json.factory().make(x));
                }
                return L;
            }
            if (anything instanceof Map) {
                Json O = this.object();
                for (Map.Entry x : ((Map)anything).entrySet()) {
                    O.set(x.getKey().toString(), Json.factory().make(x.getValue()));
                }
                return O;
            }
            if (anything instanceof Boolean) {
                return Json.factory().bool((Boolean)anything);
            }
            if (anything instanceof Number) {
                return Json.factory().number((Number)anything);
            }
            if (anything.getClass().isArray()) {
                Class<?> comp = anything.getClass().getComponentType();
                if (!comp.isPrimitive()) {
                    return Json.array((Object[])anything);
                }
                Json A = this.array();
                if (Boolean.TYPE == comp) {
                    for (boolean b : (boolean[])anything) {
                        A.add(b);
                    }
                } else if (Byte.TYPE == comp) {
                    for (byte b : (byte[])anything) {
                        A.add(b);
                    }
                } else if (Character.TYPE == comp) {
                    for (char b : (char[])anything) {
                        A.add(Character.valueOf(b));
                    }
                } else if (Short.TYPE == comp) {
                    for (short b : (short[])anything) {
                        A.add(b);
                    }
                } else if (Integer.TYPE == comp) {
                    for (int b : (int[])anything) {
                        A.add(b);
                    }
                } else if (Long.TYPE == comp) {
                    for (long b : (long[])anything) {
                        A.add(b);
                    }
                } else if (Float.TYPE == comp) {
                    for (float b : (float[])anything) {
                        A.add(Float.valueOf(b));
                    }
                } else if (Double.TYPE == comp) {
                    for (double b : (double[])anything) {
                        A.add(b);
                    }
                }
                return A;
            }
            throw new IllegalArgumentException("Don't know how to convert to Json : " + anything);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultSchema
    implements Schema {
        static Instruction any = new Instruction(){

            public Json apply(Json param) {
                return null;
            }
        };
        int maxchars = 50;
        URI uri;
        Json theschema;
        Instruction start;

        static Json maybeError(Json errors, Json E) {
            return E == null ? errors : (errors == null ? Json.array() : errors).with(E);
        }

        Instruction compile(Json S, Map<Json, Instruction> compiled) {
            Instruction any;
            Instruction result = compiled.get(S);
            if (result != null) {
                return result;
            }
            Sequence seq = new Sequence();
            compiled.put(S, seq);
            if (S.has("type") && !S.is("type", (Object)"any")) {
                seq.add(new CheckType(S.at("type").isString() ? Json.array().add(S.at("type")) : S.at("type")));
            }
            if (S.has("enum")) {
                seq.add(new CheckEnum(S.at("enum")));
            }
            if (S.has("allOf")) {
                Sequence sub = new Sequence();
                for (Json json : S.at("allOf").asJsonList()) {
                    sub.add(this.compile(json, compiled));
                }
                seq.add(sub);
            }
            if (S.has("anyOf")) {
                any = new CheckAny();
                any.schema = S.at("anyOf");
                for (Json json : any.schema.asJsonList()) {
                    any.alternates.add(this.compile(json, compiled));
                }
                seq.add(any);
            }
            if (S.has("oneOf")) {
                any = new CheckOne();
                ((CheckOne)any).schema = S.at("oneOf");
                for (Json json : ((CheckOne)any).schema.asJsonList()) {
                    ((CheckOne)any).alternates.add(this.compile(json, compiled));
                }
                seq.add(any);
            }
            if (S.has("not")) {
                seq.add(new CheckNot(this.compile(S.at("not"), compiled), S.at("not")));
            }
            if (S.has("required")) {
                for (Json p : S.at("required").asJsonList()) {
                    seq.add(new CheckPropertyPresent(p.asString()));
                }
            }
            CheckObject objectCheck = new CheckObject();
            if (S.has("properties")) {
                for (Map.Entry entry : S.at("properties").asJsonMap().entrySet()) {
                    ArrayList<Instruction> arrayList = objectCheck.props;
                    CheckObject checkObject = objectCheck;
                    checkObject.getClass();
                    arrayList.add(checkObject.new CheckObject.CheckProperty((String)entry.getKey(), this.compile((Json)entry.getValue(), compiled)));
                }
            }
            if (S.has("patternProperties")) {
                for (Map.Entry entry : S.at("patternProperties").asJsonMap().entrySet()) {
                    ArrayList<Instruction> arrayList = objectCheck.patternProps;
                    CheckObject checkObject = objectCheck;
                    checkObject.getClass();
                    arrayList.add(checkObject.new CheckObject.CheckPatternProperty((String)entry.getKey(), this.compile((Json)entry.getValue(), compiled)));
                }
            }
            if (S.has("additionalProperties")) {
                if (S.at("additionalProperties").isObject()) {
                    objectCheck.additionalSchema = this.compile(S.at("additionalProperties"), compiled);
                } else if (!S.at("additionalProperties").asBoolean()) {
                    objectCheck.additionalSchema = null;
                }
            }
            if (S.has("minProperties")) {
                objectCheck.min = S.at("minProperties").asInteger();
            }
            if (S.has("maxProperties")) {
                objectCheck.max = S.at("maxProperties").asInteger();
            }
            if (!objectCheck.props.isEmpty() || !objectCheck.patternProps.isEmpty() || objectCheck.additionalSchema != DefaultSchema.any || objectCheck.min > 0 || objectCheck.max < Integer.MAX_VALUE) {
                seq.add(objectCheck);
            }
            CheckArray arrayCheck = new CheckArray();
            if (S.has("items")) {
                if (S.at("items").isObject()) {
                    arrayCheck.schema = this.compile(S.at("items"), compiled);
                } else {
                    arrayCheck.schemas = new ArrayList();
                    for (Json s : S.at("items").asJsonList()) {
                        arrayCheck.schemas.add(this.compile(s, compiled));
                    }
                }
            }
            if (S.has("additionalItems")) {
                if (S.at("additionalItems").isObject()) {
                    arrayCheck.additionalSchema = this.compile(S.at("additionalItems"), compiled);
                } else if (!S.at("additionalItems").asBoolean()) {
                    arrayCheck.additionalSchema = null;
                }
            }
            if (S.has("uniqueItems")) {
                arrayCheck.uniqueitems = S.at("uniqueItems").asBoolean();
            }
            if (S.has("minItems")) {
                arrayCheck.min = S.at("minItems").asInteger();
            }
            if (S.has("maxItems")) {
                arrayCheck.max = S.at("maxItems").asInteger();
            }
            if (arrayCheck.schema != null || arrayCheck.schemas != null || arrayCheck.additionalSchema != DefaultSchema.any || arrayCheck.uniqueitems != null || arrayCheck.max < Integer.MAX_VALUE || arrayCheck.min > 0) {
                seq.add(arrayCheck);
            }
            CheckNumber checkNumber = new CheckNumber();
            if (S.has("minimum")) {
                checkNumber.min = S.at("minimum").asDouble();
            }
            if (S.has("maximum")) {
                checkNumber.max = S.at("maximum").asDouble();
            }
            if (S.has("multipleOf")) {
                checkNumber.multipleOf = S.at("multipleOf").asDouble();
            }
            if (S.has("exclusiveMinimum")) {
                checkNumber.exclusiveMin = S.at("exclusiveMinimum").asBoolean();
            }
            if (S.has("exclusiveMaximum")) {
                checkNumber.exclusiveMax = S.at("exclusiveMaximum").asBoolean();
            }
            if (!(Double.isNaN(checkNumber.min) && Double.isNaN(checkNumber.max) && Double.isNaN(checkNumber.multipleOf))) {
                seq.add(checkNumber);
            }
            CheckString stringCheck = new CheckString();
            if (S.has("minLength")) {
                stringCheck.min = S.at("minLength").asInteger();
            }
            if (S.has("maxLength")) {
                stringCheck.max = S.at("maxLength").asInteger();
            }
            if (S.has("pattern")) {
                stringCheck.pattern = Pattern.compile(S.at("pattern").asString());
            }
            if (stringCheck.min > 0 || stringCheck.max < Integer.MAX_VALUE || stringCheck.pattern != null) {
                seq.add(stringCheck);
            }
            if (S.has("dependencies")) {
                for (Map.Entry<String, Json> e : S.at("dependencies").asJsonMap().entrySet()) {
                    if (e.getValue().isObject()) {
                        seq.add(new CheckSchemaDependency(e.getKey(), this.compile(e.getValue(), compiled)));
                        continue;
                    }
                    if (e.getValue().isArray()) {
                        seq.add(new CheckPropertyDependency(e.getKey(), e.getValue()));
                        continue;
                    }
                    seq.add(new CheckPropertyDependency(e.getKey(), Json.array(e.getValue())));
                }
            }
            result = seq.seq.size() == 1 ? seq.seq.get(0) : seq;
            compiled.put(S, result);
            return result;
        }

        DefaultSchema(URI uri, Json theschema) {
            try {
                this.uri = uri == null ? new URI("") : uri;
                this.theschema = Json.expandReferences(theschema, theschema, this.uri, new HashMap<String, Json>(), new IdentityHashMap<Json, Json>());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.start = this.compile(this.theschema, new IdentityHashMap<Json, Instruction>());
        }

        @Override
        public Json validate(Json document) {
            Json result = Json.object("ok", true);
            Json errors = (Json)this.start.apply(document);
            return errors == null ? result : result.set("errors", errors).set("ok", (Object)false);
        }

        public Json generate(Json options) {
            Json result = Json.nil();
            return result;
        }

        class CheckPropertyDependency
        implements Instruction {
            Json required;
            String property;

            public CheckPropertyDependency(String property, Json required) {
                this.property = property;
                this.required = required;
            }

            public Json apply(Json param) {
                if (!param.isObject()) {
                    return null;
                }
                if (!param.has(this.property)) {
                    return null;
                }
                Json errors = null;
                for (Json p : this.required.asJsonList()) {
                    if (param.has(p.asString())) continue;
                    errors = DefaultSchema.maybeError(errors, Json.make("Conditionally required property " + p + " missing from object " + param.toString(DefaultSchema.this.maxchars)));
                }
                return errors;
            }
        }

        class CheckSchemaDependency
        implements Instruction {
            Instruction schema;
            String property;

            public CheckSchemaDependency(String property, Instruction schema) {
                this.property = property;
                this.schema = schema;
            }

            public Json apply(Json param) {
                if (!param.isObject()) {
                    return null;
                }
                if (!param.has(this.property)) {
                    return null;
                }
                return (Json)this.schema.apply(param);
            }
        }

        class CheckNot
        implements Instruction {
            Instruction I;
            Json schema;

            public CheckNot(Instruction I, Json schema) {
                this.I = I;
                this.schema = schema;
            }

            public Json apply(Json param) {
                if (this.I.apply(param) != null) {
                    return null;
                }
                return Json.array().add("Element " + param.toString(DefaultSchema.this.maxchars) + " must NOT conform to the schema " + this.schema.toString(DefaultSchema.this.maxchars));
            }
        }

        class CheckOne
        implements Instruction {
            ArrayList<Instruction> alternates = new ArrayList();
            Json schema;

            CheckOne() {
            }

            public Json apply(Json param) {
                int matches = 0;
                for (Instruction I : this.alternates) {
                    if (I.apply(param) != null) continue;
                    ++matches;
                }
                if (matches != 1) {
                    return Json.array().add("Element " + param.toString(DefaultSchema.this.maxchars) + " must conform to exactly one of available sub-schemas, but not more " + this.schema.toString(DefaultSchema.this.maxchars));
                }
                return null;
            }
        }

        class CheckAny
        implements Instruction {
            ArrayList<Instruction> alternates = new ArrayList();
            Json schema;

            CheckAny() {
            }

            public Json apply(Json param) {
                for (Instruction I : this.alternates) {
                    if (I.apply(param) != null) continue;
                    return null;
                }
                return Json.array().add("Element " + param.toString(DefaultSchema.this.maxchars) + " must conform to at least one of available sub-schemas " + this.schema.toString(DefaultSchema.this.maxchars));
            }
        }

        class CheckEnum
        implements Instruction {
            Json theenum;

            public CheckEnum(Json theenum) {
                this.theenum = theenum;
            }

            public Json apply(Json param) {
                for (Json option : this.theenum.asJsonList()) {
                    if (!param.equals(option)) continue;
                    return null;
                }
                return Json.array().add("Element " + param.toString(DefaultSchema.this.maxchars) + " doesn't match any of enumerated possibilities " + this.theenum);
            }
        }

        class CheckType
        implements Instruction {
            Json types;

            public CheckType(Json types) {
                this.types = types;
            }

            public Json apply(Json param) {
                String ptype = param.isString() ? "string" : (param.isObject() ? "object" : (param.isArray() ? "array" : (param.isNumber() ? "number" : (param.isNull() ? "null" : "boolean"))));
                for (Json type : this.types.asJsonList()) {
                    if (type.asString().equals(ptype)) {
                        return null;
                    }
                    if (!type.asString().equals("integer") || !param.isNumber() || param.asDouble() % 1.0 != 0.0) continue;
                    return null;
                }
                return Json.array().add(Json.make("Type mistmatch for " + param.toString(DefaultSchema.this.maxchars) + ", allowed types: " + this.types));
            }
        }

        class Sequence
        implements Instruction {
            ArrayList<Instruction> seq = new ArrayList();

            Sequence() {
            }

            public Json apply(Json param) {
                Json errors = null;
                for (Instruction I : this.seq) {
                    errors = DefaultSchema.maybeError(errors, (Json)I.apply(param));
                }
                return errors;
            }

            public Sequence add(Instruction I) {
                this.seq.add(I);
                return this;
            }
        }

        class CheckObject
        implements Instruction {
            int min = 0;
            int max = Integer.MAX_VALUE;
            HashSet<String> checked = new HashSet();
            Instruction additionalSchema = any;
            ArrayList<Instruction> props = new ArrayList();
            ArrayList<Instruction> patternProps = new ArrayList();

            CheckObject() {
            }

            public Json apply(Json param) {
                Json errors = null;
                if (!param.isObject()) {
                    return errors;
                }
                this.checked.clear();
                for (Instruction instruction : this.props) {
                    errors = DefaultSchema.maybeError(errors, (Json)instruction.apply(param));
                }
                for (Instruction instruction : this.patternProps) {
                    errors = DefaultSchema.maybeError(errors, (Json)instruction.apply(param));
                }
                if (this.additionalSchema != any) {
                    for (Map.Entry entry : param.asJsonMap().entrySet()) {
                        if (this.checked.contains(entry.getKey())) continue;
                        errors = DefaultSchema.maybeError(errors, this.additionalSchema == null ? Json.make("Extra property '" + (String)entry.getKey() + "', schema doesn't allow any properties not explicitly defined:" + param.toString(DefaultSchema.this.maxchars)) : (Json)this.additionalSchema.apply(entry.getValue()));
                    }
                }
                if (param.asJsonMap().size() < this.min) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Object " + param.toString(DefaultSchema.this.maxchars) + " has fewer than the permitted " + this.min + "  number of properties."));
                }
                if (param.asJsonMap().size() > this.max) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Object " + param.toString(DefaultSchema.this.maxchars) + " has more than the permitted " + this.min + "  number of properties."));
                }
                return errors;
            }

            class CheckPatternProperty
            implements Instruction {
                Pattern pattern;
                Instruction schema;

                public CheckPatternProperty(String pattern, Instruction schema) {
                    this.pattern = Pattern.compile(pattern);
                    this.schema = schema;
                }

                public Json apply(Json param) {
                    Json errors = null;
                    for (Map.Entry<String, Json> e : param.asJsonMap().entrySet()) {
                        if (!this.pattern.matcher(e.getKey()).find()) continue;
                        errors = DefaultSchema.maybeError(errors, (Json)this.schema.apply(e.getValue()));
                        CheckObject.this.checked.add(e.getKey());
                    }
                    return errors;
                }
            }

            class CheckProperty
            implements Instruction {
                String name;
                Instruction schema;

                public CheckProperty(String name, Instruction schema) {
                    this.name = name;
                    this.schema = schema;
                }

                public Json apply(Json param) {
                    Json value = param.at(this.name);
                    if (value == null) {
                        return null;
                    }
                    CheckObject.this.checked.add(this.name);
                    return (Json)this.schema.apply(param.at(this.name));
                }
            }
        }

        class CheckPropertyPresent
        implements Instruction {
            String propname;

            public CheckPropertyPresent(String propname) {
                this.propname = propname;
            }

            public Json apply(Json param) {
                if (!param.isObject()) {
                    return null;
                }
                if (param.has(this.propname)) {
                    return null;
                }
                return Json.array().add(Json.make("Required property " + this.propname + " missing from object " + param.toString(DefaultSchema.this.maxchars)));
            }
        }

        class CheckArray
        implements Instruction {
            int min = 0;
            int max = Integer.MAX_VALUE;
            Boolean uniqueitems = null;
            Instruction additionalSchema = any;
            Instruction schema;
            ArrayList<Instruction> schemas;

            CheckArray() {
            }

            public Json apply(Json param) {
                Json errors = null;
                if (!param.isArray()) {
                    return errors;
                }
                if (this.schema == null && this.schemas == null && this.additionalSchema == null) {
                    return errors;
                }
                int size = param.asJsonList().size();
                for (int i = 0; i < size; ++i) {
                    Instruction S = this.schema != null ? this.schema : (this.schemas != null && i < this.schemas.size() ? this.schemas.get(i) : this.additionalSchema);
                    errors = S == null ? DefaultSchema.maybeError(errors, Json.make("Additional items are not permitted: " + param.at(i) + " in " + param.toString(DefaultSchema.this.maxchars))) : DefaultSchema.maybeError(errors, (Json)S.apply(param.at(i)));
                    if (this.uniqueitems == null || !this.uniqueitems.booleanValue() || param.asJsonList().lastIndexOf(param.at(i)) <= i) continue;
                    errors = DefaultSchema.maybeError(errors, Json.make("Element " + param.at(i) + " is duplicate in array."));
                }
                if (size < this.min || size > this.max) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Array  " + param.toString(DefaultSchema.this.maxchars) + " has number of elements outside of the permitted range [" + this.min + "," + this.max + "]."));
                }
                return errors;
            }
        }

        class CheckNumber
        implements Instruction {
            double min = Double.NaN;
            double max = Double.NaN;
            double multipleOf = Double.NaN;
            boolean exclusiveMin = false;
            boolean exclusiveMax = false;

            CheckNumber() {
            }

            public Json apply(Json param) {
                Json errors = null;
                if (!param.isNumber()) {
                    return errors;
                }
                double value = param.asDouble();
                if (!Double.isNaN(this.min) && (value < this.min || this.exclusiveMin && value == this.min)) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Number " + param + " is below allowed minimum " + this.min));
                }
                if (!Double.isNaN(this.max) && (value > this.max || this.exclusiveMax && value == this.max)) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Number " + param + " is above allowed maximum " + this.max));
                }
                if (!Double.isNaN(this.multipleOf) && value / this.multipleOf % 1.0 != 0.0) {
                    errors = DefaultSchema.maybeError(errors, Json.make("Number " + param + " is not a multiple of  " + this.multipleOf));
                }
                return errors;
            }
        }

        class CheckString
        implements Instruction {
            int min = 0;
            int max = Integer.MAX_VALUE;
            Pattern pattern;

            CheckString() {
            }

            public Json apply(Json param) {
                Json errors = null;
                if (!param.isString()) {
                    return errors;
                }
                String s = param.asString();
                int size = s.codePointCount(0, s.length());
                if (size < this.min || size > this.max) {
                    errors = DefaultSchema.maybeError(errors, Json.make("String  " + param.toString(DefaultSchema.this.maxchars) + " has length outside of the permitted range [" + this.min + "," + this.max + "]."));
                }
                if (this.pattern != null && !this.pattern.matcher(s).matches()) {
                    errors = DefaultSchema.maybeError(errors, Json.make("String  " + param.toString(DefaultSchema.this.maxchars) + " does not match regex " + this.pattern.toString()));
                }
                return errors;
            }
        }

        class IsInteger
        implements Instruction {
            IsInteger() {
            }

            public Json apply(Json param) {
                return param.isNumber() && (Number)param.getValue() instanceof Integer ? null : Json.make(param.toString(DefaultSchema.this.maxchars));
            }
        }

        class IsNumber
        implements Instruction {
            IsNumber() {
            }

            public Json apply(Json param) {
                return param.isNumber() ? null : Json.make(param.toString(DefaultSchema.this.maxchars));
            }
        }

        class IsNull
        implements Instruction {
            IsNull() {
            }

            public Json apply(Json param) {
                return param.isNull() ? null : Json.make(param.toString(DefaultSchema.this.maxchars));
            }
        }

        class IsBoolean
        implements Instruction {
            IsBoolean() {
            }

            public Json apply(Json param) {
                return param.isBoolean() ? null : Json.make(param.toString(DefaultSchema.this.maxchars));
            }
        }

        class IsString
        implements Instruction {
            IsString() {
            }

            public Json apply(Json param) {
                return param.isString() ? null : Json.make(param.toString(DefaultSchema.this.maxchars));
            }
        }

        class IsArray
        implements Instruction {
            IsArray() {
            }

            public Json apply(Json param) {
                return param.isArray() ? null : Json.make(param.toString(DefaultSchema.this.maxchars));
            }
        }

        class IsObject
        implements Instruction {
            IsObject() {
            }

            public Json apply(Json param) {
                return param.isObject() ? null : Json.make(param.toString(DefaultSchema.this.maxchars));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static interface Instruction
        extends Function<Json, Json> {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Function<T, R> {
        public R apply(T var1);
    }

    public static interface Schema {
        public Json validate(Json var1);
    }

    public static interface Factory {
        public Json nil();

        public Json bool(boolean var1);

        public Json string(String var1);

        public Json number(Number var1);

        public Json object();

        public Json array();

        public Json make(Object var1);
    }
}

