/*
 * Copyright 2017 University of Rostock
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package sessl.ml3

import sessl.{ConjunctiveReplicationCondition, DisjunctiveReplicationCondition, FixedNumber, ReplicationCondition}

/**
  * Created by Tom Warnke.
  */
trait SupportReplicationConditions {
  this: Experiment =>

  def minReplicationNumber(assignmentId: Int): Int = minReplicationNumber(assignmentId,
    checkAndGetReplicationCondition())

  def enoughReplications(assignmentId: Int): Boolean = enoughReplications(assignmentId,
    checkAndGetReplicationCondition())

  def minReplicationNumber(assignmentId: Int, replicationCondition: ReplicationCondition): Int = {
    val numFinishedRuns = getNumberOfFinishedRunsForAssignment(assignmentId)

    replicationCondition match {
      case f: FixedNumber => f.replications - numFinishedRuns
      case cc: ConjunctiveReplicationCondition =>
        math.max(minReplicationNumber(assignmentId, cc.left), minReplicationNumber(assignmentId, cc.right))
      case dc: DisjunctiveReplicationCondition =>
        math.min(minReplicationNumber(assignmentId, dc.left), minReplicationNumber(assignmentId, dc.right))
    }
  }

  def enoughReplications(assignmentId: Int, replicationCondition: ReplicationCondition): Boolean = {

    val numFinishedRuns = getNumberOfFinishedRunsForAssignment(assignmentId)

    replicationCondition match {
      case f: FixedNumber => numFinishedRuns >= f.replications
      case cc: ConjunctiveReplicationCondition =>
        enoughReplications(assignmentId, cc.left) && enoughReplications(assignmentId, cc.right)
      case dc: DisjunctiveReplicationCondition =>
        enoughReplications(assignmentId, dc.left) || enoughReplications(assignmentId, dc.right)
    }
  }


}
