/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.support.ui;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.NoAlertPresentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.NotFoundException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

@NullMarked
public class ExpectedConditions {
    private static final Logger LOG = Logger.getLogger(ExpectedConditions.class.getName());

    private ExpectedConditions() {
    }

    public static ExpectedCondition<Boolean> titleIs(final String title) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String currentTitle = "";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                return title.equals(this.currentTitle);
            }

            public String toString() {
                return String.format("title to be \"%s\". Current title: \"%s\".", title, this.currentTitle);
            }
        };
    }

    public static ExpectedCondition<Boolean> titleContains(final String title) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String currentTitle = "";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentTitle = driver.getTitle();
                return this.currentTitle != null && this.currentTitle.contains(title);
            }

            public String toString() {
                return String.format("title to contain \"%s\". Current title: \"%s\".", title, this.currentTitle);
            }
        };
    }

    public static ExpectedCondition<Boolean> urlToBe(final String url) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String currentUrl = "";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return this.currentUrl != null && this.currentUrl.equals(url);
            }

            public String toString() {
                return String.format("url to be \"%s\". Current url: \"%s\"", url, this.currentUrl);
            }
        };
    }

    public static ExpectedCondition<Boolean> urlContains(final String fraction) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String currentUrl = "";

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return this.currentUrl != null && this.currentUrl.contains(fraction);
            }

            public String toString() {
                return String.format("url to contain \"%s\". Current url: \"%s\"", fraction, this.currentUrl);
            }
        };
    }

    public static ExpectedCondition<Boolean> urlMatches(String regex) {
        return ExpectedConditions.urlMatches(Pattern.compile(regex));
    }

    public static ExpectedCondition<Boolean> urlMatches(final Pattern regex) {
        return new ExpectedCondition<Boolean>(){
            private final Pattern pattern;
            private @Nullable String currentUrl;
            {
                this.pattern = regex;
            }

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentUrl = driver.getCurrentUrl();
                return this.currentUrl != null && this.pattern.matcher(this.currentUrl).find();
            }

            public String toString() {
                return String.format("url to match the regex \"%s\". Current url: \"%s\"", regex, this.currentUrl);
            }
        };
    }

    public static ExpectedCondition<@Nullable WebElement> presenceOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public @Nullable WebElement apply(WebDriver driver) {
                try {
                    return driver.findElement(locator);
                }
                catch (NoSuchElementException notFound) {
                    return null;
                }
            }

            public String toString() {
                return "presence of element found by " + String.valueOf(locator);
            }
        };
    }

    public static ExpectedCondition<WebElement> visibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<WebElement>(){
            private @Nullable WebDriverException error;

            @Override
            public @Nullable WebElement apply(WebDriver driver) {
                this.error = null;
                try {
                    return ExpectedConditions.elementIfVisible(driver.findElement(locator));
                }
                catch (NoSuchElementException | StaleElementReferenceException elementDisappeared) {
                    this.error = elementDisappeared;
                    return null;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("visibility of element found by %s, but... %s.", locator, ExpectedConditions.shortDescription((Exception)this.error));
                }
                return String.format("visibility of element found by %s", locator);
            }
        };
    }

    public static ExpectedCondition<@Nullable List<WebElement>> visibilityOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){
            private int indexOfInvisibleElement;
            private @Nullable WebElement invisibleElement;

            @Override
            public @Nullable List<WebElement> apply(WebDriver driver) {
                this.indexOfInvisibleElement = -1;
                this.invisibleElement = null;
                List elements = driver.findElements(locator);
                for (int i = 0; i < elements.size(); ++i) {
                    WebElement element = (WebElement)elements.get(i);
                    if (element.isDisplayed()) continue;
                    this.indexOfInvisibleElement = i;
                    this.invisibleElement = element;
                    return null;
                }
                return !elements.isEmpty() ? elements : null;
            }

            public String toString() {
                return this.indexOfInvisibleElement == -1 ? String.format("visibility of all elements located by %s, but no elements were found", locator) : String.format("visibility of all elements located by %s, but element #%s was invisible: %s", locator, this.indexOfInvisibleElement, this.invisibleElement);
            }
        };
    }

    public static ExpectedCondition<@Nullable List<WebElement>> visibilityOfAllElements(WebElement ... elements) {
        return ExpectedConditions.visibilityOfAllElements(List.of(elements));
    }

    public static ExpectedCondition<@Nullable List<WebElement>> visibilityOfAllElements(final List<WebElement> elements) {
        return new ExpectedCondition<List<WebElement>>(){
            private int indexOfInvisibleElement;
            private @Nullable WebElement invisibleElement;

            @Override
            public @Nullable List<WebElement> apply(WebDriver driver) {
                this.indexOfInvisibleElement = -1;
                this.invisibleElement = null;
                for (int i = 0; i < elements.size(); ++i) {
                    WebElement element = (WebElement)elements.get(i);
                    if (element.isDisplayed()) continue;
                    this.indexOfInvisibleElement = i;
                    this.invisibleElement = element;
                    return null;
                }
                return !elements.isEmpty() ? elements : null;
            }

            public String toString() {
                return this.indexOfInvisibleElement == -1 ? String.format("visibility of all %s elements, but no elements were found", elements.size()) : String.format("visibility of all %s elements, but element #%s was invisible: %s", elements.size(), this.indexOfInvisibleElement, this.invisibleElement);
            }
        };
    }

    public static ExpectedCondition<@Nullable WebElement> visibilityOf(final WebElement element) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public @Nullable WebElement apply(WebDriver driver) {
                return ExpectedConditions.elementIfVisible(element);
            }

            public String toString() {
                return "visibility of " + String.valueOf(element);
            }
        };
    }

    private static @Nullable WebElement elementIfVisible(WebElement element) {
        return element.isDisplayed() ? element : null;
    }

    public static ExpectedCondition<@Nullable List<WebElement>> presenceOfAllElementsLocatedBy(final By locator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public @Nullable List<WebElement> apply(WebDriver driver) {
                List elements = driver.findElements(locator);
                return !elements.isEmpty() ? elements : null;
            }

            public String toString() {
                return "presence of any elements located by " + String.valueOf(locator);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElement(final WebElement element, final String text) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String elementText;
            private @Nullable StaleElementReferenceException error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.elementText = null;
                this.error = null;
                try {
                    this.elementText = element.getText();
                    return this.elementText.contains(text);
                }
                catch (StaleElementReferenceException e) {
                    this.error = e;
                    return false;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("element to have text \"%s\", but... %s.", text, ExpectedConditions.shortDescription((Exception)((Object)this.error)));
                }
                return String.format("element to have text \"%s\". Current text: \"%s\".", text, this.elementText);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementLocated(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String elementText;
            private @Nullable WebDriverException error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.elementText = null;
                this.error = null;
                try {
                    this.elementText = driver.findElement(locator).getText();
                    return this.elementText.contains(text);
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    this.error = e;
                    return false;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("element found by %s to contain text \"%s\", but... %s.", locator, text, ExpectedConditions.shortDescription((Exception)this.error));
                }
                return String.format("element found by %s to contain text \"%s\". Current text: \"%s\".", locator, text, this.elementText);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final WebElement element, final String expectedValue) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String actualValue;
            private @Nullable StaleElementReferenceException error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualValue = null;
                this.error = null;
                try {
                    this.actualValue = element.getAttribute("value");
                    return this.actualValue != null && this.actualValue.contains(expectedValue);
                }
                catch (StaleElementReferenceException e) {
                    this.error = e;
                    return false;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("element \"value\" attribute to contain \"%s\", but... %s.", expectedValue, ExpectedConditions.shortDescription((Exception)((Object)this.error)));
                }
                return String.format("element \"value\" attribute to contain \"%s\". Current value: \"%s\".", expectedValue, this.actualValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBePresentInElementValue(final By locator, final String expectedValue) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String actualValue;
            private @Nullable WebDriverException error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualValue = null;
                this.error = null;
                try {
                    this.actualValue = driver.findElement(locator).getAttribute("value");
                    return this.actualValue != null && this.actualValue.contains(expectedValue);
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    this.error = e;
                    return false;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("element found by %s to have \"value\" attribute containing \"%s\", but... %s.", locator, expectedValue, ExpectedConditions.shortDescription((Exception)this.error));
                }
                return String.format("element found by %s to have \"value\" attribute containing \"%s\". Current value: \"%s\".", locator, expectedValue, this.actualValue);
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final String frameLocator) {
        return new ExpectedCondition<WebDriver>(){
            private @Nullable NoSuchFrameException error;

            @Override
            public @Nullable WebDriver apply(WebDriver driver) {
                this.error = null;
                try {
                    return driver.switchTo().frame(frameLocator);
                }
                catch (NoSuchFrameException e) {
                    this.error = e;
                    return null;
                }
            }

            public String toString() {
                return String.format("frame with name or id \"%s\" to be available, but... %s.", frameLocator, ExpectedConditions.shortDescription((Exception)((Object)this.error)));
            }
        };
    }

    public static ExpectedCondition<@Nullable WebDriver> frameToBeAvailableAndSwitchToIt(final By locator) {
        return new ExpectedCondition<WebDriver>(){
            private @Nullable NotFoundException error;

            @Override
            public @Nullable WebDriver apply(WebDriver driver) {
                this.error = null;
                try {
                    WebElement frame = driver.findElement(locator);
                    return driver.switchTo().frame(frame);
                }
                catch (NoSuchElementException | NoSuchFrameException e) {
                    this.error = e;
                    return null;
                }
            }

            public String toString() {
                return String.format("frame to be available: %s, but... %s.", locator, ExpectedConditions.shortDescription((Exception)this.error));
            }
        };
    }

    public static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt(final int frameIndex) {
        return new ExpectedCondition<WebDriver>(){
            private @Nullable NoSuchFrameException error;

            @Override
            public @Nullable WebDriver apply(WebDriver driver) {
                this.error = null;
                try {
                    return driver.switchTo().frame(frameIndex);
                }
                catch (NoSuchFrameException e) {
                    this.error = e;
                    return null;
                }
            }

            public String toString() {
                return String.format("frame #%s to be available, but... %s.", frameIndex, ExpectedConditions.shortDescription((Exception)((Object)this.error)));
            }
        };
    }

    public static ExpectedCondition<@Nullable WebDriver> frameToBeAvailableAndSwitchToIt(final WebElement frame) {
        return new ExpectedCondition<WebDriver>(){
            private @Nullable NoSuchFrameException error;

            @Override
            public @Nullable WebDriver apply(WebDriver driver) {
                this.error = null;
                try {
                    return driver.switchTo().frame(frame);
                }
                catch (NoSuchFrameException e) {
                    this.error = e;
                    return null;
                }
            }

            public String toString() {
                return String.format("frame to be available, but... %s.", ExpectedConditions.shortDescription((Exception)((Object)this.error)));
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementLocated(final By locator) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                try {
                    return !driver.findElement(locator).isDisplayed();
                }
                catch (NoSuchElementException | StaleElementReferenceException elementDisappeared) {
                    return true;
                }
            }

            public String toString() {
                return String.format("element found by %s to become invisible", locator);
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfElementWithText(final By locator, final String text) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable WebElement visibleElement;

            @Override
            public Boolean apply(WebDriver driver) {
                this.visibleElement = null;
                this.visibleElement = driver.findElements(locator).stream().filter(element -> element.getText().equals(text)).filter(element -> !ExpectedConditions.isInvisible(element)).findAny().orElse(null);
                return this.visibleElement == null;
            }

            public String toString() {
                return String.format("element with text \"%s\" located by \"%s\" to become invisible: %s", text, locator, this.visibleElement);
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final By locator) {
        return new ExpectedCondition<WebElement>(){
            private @Nullable String message;

            @Override
            public @Nullable WebElement apply(WebDriver driver) {
                this.message = null;
                try {
                    WebElement element = driver.findElement(locator);
                    if (!element.isDisplayed()) {
                        this.message = "was not visible";
                        return null;
                    }
                    if (!element.isEnabled()) {
                        this.message = "was not enabled";
                        return null;
                    }
                    return element;
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    this.message = "was not found: " + ExpectedConditions.shortDescription((Exception)e);
                    return null;
                }
            }

            public String toString() {
                return String.format("element found by %s to be clickable, but the element %s.", locator, this.message);
            }
        };
    }

    public static ExpectedCondition<WebElement> elementToBeClickable(final WebElement element) {
        return new ExpectedCondition<WebElement>(){
            private @Nullable String message;

            @Override
            public @Nullable WebElement apply(WebDriver driver) {
                this.message = null;
                try {
                    if (!element.isDisplayed()) {
                        this.message = "was not visible";
                        return null;
                    }
                    if (!element.isEnabled()) {
                        this.message = "was not enabled";
                        return null;
                    }
                    return element;
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    this.message = "was not found: " + ExpectedConditions.shortDescription((Exception)e);
                    return null;
                }
            }

            public String toString() {
                return String.format("element to be clickable, but the element %s.", this.message);
            }
        };
    }

    public static ExpectedCondition<Boolean> stalenessOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver ignored) {
                try {
                    element.isEnabled();
                    return false;
                }
                catch (StaleElementReferenceException expected) {
                    return true;
                }
            }

            public String toString() {
                return String.format("element (%s) to become stale", element);
            }
        };
    }

    public static <T> ExpectedCondition<@Nullable T> refreshed(final ExpectedCondition<T> condition) {
        return new ExpectedCondition<T>(){

            @Override
            public @Nullable T apply(WebDriver driver) {
                try {
                    return condition.apply(driver);
                }
                catch (StaleElementReferenceException e) {
                    return null;
                }
            }

            public String toString() {
                return String.format("condition (%s) to be refreshed", condition);
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(WebElement element) {
        return ExpectedConditions.elementSelectionStateToBe(element, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final WebElement element, final boolean selected) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                return element.isSelected() == selected;
            }

            public String toString() {
                return String.format("element (%s) %s selected", element, selected ? "to be" : "not to be");
            }
        };
    }

    public static ExpectedCondition<Boolean> elementToBeSelected(By locator) {
        return ExpectedConditions.elementSelectionStateToBe(locator, true);
    }

    public static ExpectedCondition<Boolean> elementSelectionStateToBe(final By locator, final boolean selected) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable WebDriverException error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.error = null;
                try {
                    WebElement element = driver.findElement(locator);
                    return element.isSelected() == selected;
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    this.error = e;
                    return false;
                }
            }

            public String toString() {
                String message = String.format("element found by %s %s selected", locator, selected ? "to be" : "not to be");
                return this.error == null ? message : String.format("%s, but... %s.", message, ExpectedConditions.shortDescription((Exception)this.error));
            }
        };
    }

    public static ExpectedCondition<@Nullable Alert> alertIsPresent() {
        return new ExpectedCondition<Alert>(){

            @Override
            public @Nullable Alert apply(WebDriver driver) {
                try {
                    return driver.switchTo().alert();
                }
                catch (NoAlertPresentException e) {
                    return null;
                }
            }

            public String toString() {
                return "alert to be present";
            }
        };
    }

    public static ExpectedCondition<Boolean> numberOfWindowsToBe(final int expectedNumberOfWindows) {
        return new ExpectedCondition<Boolean>(){
            private int actualNumberOfWindows;
            private @Nullable WebDriverException error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.error = null;
                this.actualNumberOfWindows = -1;
                try {
                    this.actualNumberOfWindows = driver.getWindowHandles().size();
                    return this.actualNumberOfWindows == expectedNumberOfWindows;
                }
                catch (WebDriverException e) {
                    this.error = e;
                    LOG.log(Level.FINE, "Failed to check number of windows", e);
                    return false;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("number of open windows to be %s, but... %s.", expectedNumberOfWindows, ExpectedConditions.shortDescription((Exception)((Object)this.error)));
                }
                return String.format("number of open windows to be %s, but was: %s", expectedNumberOfWindows, this.actualNumberOfWindows);
            }
        };
    }

    public static ExpectedCondition<Boolean> not(final ExpectedCondition<?> condition) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                Object result = condition.apply(driver);
                return result == null || result.equals(Boolean.FALSE);
            }

            public String toString() {
                return "condition not to be valid: " + String.valueOf(condition);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeToBe(final By locator, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                WebElement element = driver.findElement(locator);
                this.currentValue = ExpectedConditions.getAttributeOrCssValue(element, attribute).orElse(null);
                return value.equals(this.currentValue);
            }

            public String toString() {
                return String.format("element found by %s to have attribute or CSS value \"%s\"=\"%s\". Current value: \"%s\".", locator, attribute, value, this.currentValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> textToBe(final By locator, final String expectedText) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String actualText = null;
            private @Nullable Exception error = null;

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualText = null;
                this.error = null;
                try {
                    this.actualText = driver.findElement(locator).getText();
                    return this.actualText.equals(expectedText);
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    this.error = e;
                    return false;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to check element text", e);
                    this.error = e;
                    return false;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("element found by %s to have text \"%s\", but... %s.", locator, expectedText, ExpectedConditions.shortDescription(this.error));
                }
                return String.format("element found by %s to have text \"%s\". Current text: \"%s\".", locator, expectedText, this.actualText);
            }
        };
    }

    public static ExpectedCondition<Boolean> textMatches(final By locator, final Pattern pattern) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String actualText;
            private @Nullable Exception error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualText = null;
                this.error = null;
                try {
                    this.actualText = driver.findElement(locator).getText();
                    return pattern.matcher(this.actualText).find();
                }
                catch (NoSuchElementException | StaleElementReferenceException e) {
                    this.error = e;
                    return false;
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to check element text", e);
                    this.error = e;
                    return false;
                }
            }

            public String toString() {
                if (this.error != null) {
                    return String.format("text of element found by %s to match pattern \"%s\", but... %s.", locator, pattern.pattern(), ExpectedConditions.shortDescription(this.error));
                }
                return String.format("text of element found by %s to match pattern \"%s\". Current text: \"%s\".", locator, pattern.pattern(), this.actualText);
            }
        };
    }

    public static ExpectedCondition<@Nullable List<WebElement>> numberOfElementsToBeMoreThan(final By locator, final Integer expectedNumber) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer actualNumber = 0;

            @Override
            public @Nullable List<WebElement> apply(WebDriver webDriver) {
                List elements = webDriver.findElements(locator);
                this.actualNumber = elements.size();
                return this.actualNumber > expectedNumber ? elements : null;
            }

            public String toString() {
                return String.format("number of elements found by %s to be more than %s. Found: %s element(s).", locator, expectedNumber, this.actualNumber);
            }
        };
    }

    public static ExpectedCondition<@Nullable List<WebElement>> numberOfElementsToBeLessThan(final By locator, final Integer number) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer currentNumber = 0;

            @Override
            public @Nullable List<WebElement> apply(WebDriver webDriver) {
                List elements = webDriver.findElements(locator);
                this.currentNumber = elements.size();
                return this.currentNumber < number ? elements : null;
            }

            public String toString() {
                return String.format("number of elements found by %s to be less than %s. Found: %s element(s).", locator, number, this.currentNumber);
            }
        };
    }

    public static ExpectedCondition<@Nullable List<WebElement>> numberOfElementsToBe(final By locator, final Integer expectedNumberOfElements) {
        return new ExpectedCondition<List<WebElement>>(){
            private Integer actualNumberOfElements = -1;

            @Override
            public @Nullable List<WebElement> apply(WebDriver webDriver) {
                this.actualNumberOfElements = -1;
                List elements = webDriver.findElements(locator);
                this.actualNumberOfElements = elements.size();
                return this.actualNumberOfElements.equals(expectedNumberOfElements) ? elements : null;
            }

            public String toString() {
                return String.format("number of elements found by %s to be %s. Found: %s element(s).", locator, expectedNumberOfElements, this.actualNumberOfElements);
            }
        };
    }

    public static ExpectedCondition<Boolean> domPropertyToBe(final WebElement element, final String property, final String expectedValue) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String actualValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualValue = element.getDomProperty(property);
                return expectedValue.equals(this.actualValue);
            }

            public String toString() {
                return String.format("DOM property \"%s\" to be \"%s\". Current value: \"%s\".", property, expectedValue, this.actualValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> domAttributeToBe(final WebElement element, final String attribute, final String value) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String currentValue = null;

            @Override
            public Boolean apply(WebDriver driver) {
                this.currentValue = element.getDomAttribute(attribute);
                return value.equals(this.currentValue);
            }

            public String toString() {
                return String.format("DOM attribute \"%s\" to be \"%s\". Current value: \"%s\".", attribute, value, this.currentValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeToBe(final WebElement element, final String attribute, final String expectedValue) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String actualValue;

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualValue = null;
                this.actualValue = ExpectedConditions.getAttributeOrCssValue(element, attribute).orElse(null);
                return expectedValue.equals(this.actualValue);
            }

            public String toString() {
                return String.format("attribute or CSS value \"%s\"=\"%s\". Current value: \"%s\".", attribute, expectedValue, this.actualValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeContains(final WebElement element, final String attribute, final String expectedValue) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable String actualValue;

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualValue = null;
                this.actualValue = ExpectedConditions.getAttributeOrCssValue(element, attribute).orElse(null);
                return this.actualValue != null && this.actualValue.contains(expectedValue);
            }

            public String toString() {
                return String.format("attribute or CSS value \"%s\" to contain \"%s\". Current value: \"%s\".", attribute, expectedValue, this.actualValue);
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeContains(final By locator, final String attributeName, final String expectedValue) {
        return new ExpectedCondition<Boolean>(){
            private Optional<String> actualValue = Optional.empty();

            @Override
            public Boolean apply(WebDriver driver) {
                this.actualValue = Optional.empty();
                this.actualValue = ExpectedConditions.getAttributeOrCssValue(driver.findElement(locator), attributeName);
                return this.actualValue.map(seen -> seen.contains(expectedValue)).orElse(false);
            }

            public String toString() {
                return this.actualValue.map(value -> String.format("element found by %s to have attribute or CSS value \"%s\" containing \"%s\", but the attribute had value \"%s\".", locator, attributeName, expectedValue, value)).orElseGet(() -> String.format("element found by %s to have attribute or CSS value \"%s\" containing \"%s\", but such attribute was not found.", locator, attributeName, expectedValue));
            }
        };
    }

    public static ExpectedCondition<Boolean> attributeToBeNotEmpty(final WebElement element, final String attribute) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                return ExpectedConditions.getAttributeOrCssValue(element, attribute).isPresent();
            }

            public String toString() {
                return String.format("attribute or CSS value \"%s\" not to be empty", attribute);
            }
        };
    }

    private static Optional<String> getAttributeOrCssValue(WebElement element, String name) {
        String value = element.getAttribute(name);
        if (value == null || value.isEmpty()) {
            value = element.getCssValue(name);
        }
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static ExpectedCondition<@Nullable List<WebElement>> visibilityOfNestedElementsLocatedBy(final By parent, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){
            private int indexOfInvisibleElement = -1;
            private @Nullable WebElement invisibleChild;

            @Override
            public @Nullable List<WebElement> apply(WebDriver driver) {
                this.invisibleChild = null;
                this.indexOfInvisibleElement = -1;
                WebElement current = driver.findElement(parent);
                List allChildren = current.findElements(childLocator);
                if (allChildren.isEmpty()) {
                    return null;
                }
                for (int i = 0; i < allChildren.size(); ++i) {
                    if (((WebElement)allChildren.get(i)).isDisplayed()) continue;
                    this.indexOfInvisibleElement = i;
                    this.invisibleChild = (WebElement)allChildren.get(i);
                    return null;
                }
                return allChildren;
            }

            public String toString() {
                if (this.indexOfInvisibleElement == -1) {
                    return String.format("visibility of all child elements located by %s -> %s, but no elements were found.", parent, childLocator);
                }
                return String.format("visibility of all child elements located by %s -> %s, but child element #%s was invisible: %s", parent, childLocator, this.indexOfInvisibleElement, this.invisibleChild);
            }
        };
    }

    public static ExpectedCondition<@Nullable List<WebElement>> visibilityOfNestedElementsLocatedBy(final WebElement element, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){
            private int indexOfInvisibleElement = -1;
            private @Nullable WebElement invisibleChild;

            @Override
            public @Nullable List<WebElement> apply(WebDriver webDriver) {
                this.invisibleChild = null;
                this.indexOfInvisibleElement = -1;
                List allChildren = element.findElements(childLocator);
                if (allChildren.isEmpty()) {
                    return null;
                }
                for (int i = 0; i < allChildren.size(); ++i) {
                    if (((WebElement)allChildren.get(i)).isDisplayed()) continue;
                    this.indexOfInvisibleElement = i;
                    this.invisibleChild = (WebElement)allChildren.get(i);
                    return null;
                }
                return allChildren;
            }

            public String toString() {
                if (this.indexOfInvisibleElement == -1) {
                    return String.format("visibility of all child elements located by %s -> %s, but no elements were found.", element, childLocator);
                }
                return String.format("visibility of all child elements located by %s -> %s, but child element #%s was invisible: %s", element, childLocator, this.indexOfInvisibleElement, this.invisibleChild);
            }
        };
    }

    public static ExpectedCondition<@Nullable WebElement> presenceOfNestedElementLocatedBy(final By locator, final By childLocator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public @Nullable WebElement apply(WebDriver webDriver) {
                WebElement parent = webDriver.findElement(locator);
                try {
                    return parent.findElement(childLocator);
                }
                catch (NoSuchElementException | StaleElementReferenceException notFound) {
                    return null;
                }
            }

            public String toString() {
                return String.format("presence of element found by %s -> %s", locator, childLocator);
            }
        };
    }

    public static ExpectedCondition<@Nullable WebElement> presenceOfNestedElementLocatedBy(final WebElement element, final By childLocator) {
        return new ExpectedCondition<WebElement>(){

            @Override
            public @Nullable WebElement apply(WebDriver webDriver) {
                try {
                    return element.findElement(childLocator);
                }
                catch (NoSuchElementException | StaleElementReferenceException notFound) {
                    return null;
                }
            }

            public String toString() {
                return String.format("presence of child element found by %s", childLocator);
            }
        };
    }

    public static ExpectedCondition<@Nullable List<WebElement>> presenceOfNestedElementsLocatedBy(final By parent, final By childLocator) {
        return new ExpectedCondition<List<WebElement>>(){

            @Override
            public @Nullable List<WebElement> apply(WebDriver driver) {
                List allChildren = driver.findElement(parent).findElements(childLocator);
                return allChildren.isEmpty() ? null : allChildren;
            }

            public String toString() {
                return String.format("presence of element(s) located by %s -> %s", parent, childLocator);
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOfAllElements(WebElement ... elements) {
        return ExpectedConditions.invisibilityOfAllElements(List.of(elements));
    }

    public static ExpectedCondition<Boolean> invisibilityOfAllElements(final List<WebElement> elements) {
        return new ExpectedCondition<Boolean>(){
            private int indexOfVisibleElement;
            private @Nullable WebElement visibleElement;

            @Override
            public Boolean apply(WebDriver webDriver) {
                this.visibleElement = null;
                this.indexOfVisibleElement = -1;
                for (int i = 0; i < elements.size(); ++i) {
                    if (ExpectedConditions.isInvisible((WebElement)elements.get(i))) continue;
                    this.indexOfVisibleElement = i;
                    this.visibleElement = (WebElement)elements.get(i);
                    return false;
                }
                return true;
            }

            public String toString() {
                return String.format("all elements to become invisible, but element #%s was visible: %s", this.indexOfVisibleElement, this.visibleElement);
            }
        };
    }

    public static ExpectedCondition<Boolean> invisibilityOf(final WebElement element) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver webDriver) {
                return ExpectedConditions.isInvisible(element);
            }

            public String toString() {
                return String.format("element %s to become invisible", element);
            }
        };
    }

    private static boolean isInvisible(WebElement element) {
        try {
            return !element.isDisplayed();
        }
        catch (NoSuchElementException | StaleElementReferenceException ignored) {
            return true;
        }
    }

    public static ExpectedCondition<Boolean> or(final ExpectedCondition<?> ... conditions) {
        return new ExpectedCondition<Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                for (ExpectedCondition condition : conditions) {
                    try {
                        Object result = condition.apply(driver);
                        if (!Boolean.TRUE.equals(result) && (result == null || result instanceof Boolean)) continue;
                        return true;
                    }
                    catch (StaleElementReferenceException staleElementReferenceException) {
                        // empty catch block
                    }
                }
                return false;
            }

            public String toString() {
                StringBuilder message = new StringBuilder("at least one condition to be valid:").append(System.lineSeparator());
                for (int i = 0; i < conditions.length; ++i) {
                    message.append(i + 1).append(". ").append(conditions[i]).append(System.lineSeparator());
                }
                return message.toString();
            }
        };
    }

    public static ExpectedCondition<Boolean> and(final ExpectedCondition<?> ... conditions) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable ExpectedCondition<?> failedCondition;
            private int failedConditionIndex = -1;

            @Override
            public Boolean apply(WebDriver driver) {
                this.failedConditionIndex = -1;
                this.failedCondition = null;
                for (int i = 0; i < conditions.length; ++i) {
                    ExpectedCondition condition = conditions[i];
                    Object result = condition.apply(driver);
                    if (result != null && !Boolean.FALSE.equals(result)) continue;
                    this.failedConditionIndex = i;
                    this.failedCondition = condition;
                    return false;
                }
                return true;
            }

            public String toString() {
                return String.format("all conditions to be valid, but condition #%s failed:%nExpected %s", this.failedConditionIndex, this.failedCondition);
            }
        };
    }

    public static ExpectedCondition<Boolean> javaScriptThrowsNoExceptions(final String javaScript) {
        return new ExpectedCondition<Boolean>(){
            private @Nullable WebDriverException error;

            @Override
            public Boolean apply(WebDriver driver) {
                this.error = null;
                try {
                    ((JavascriptExecutor)driver).executeScript(javaScript, new Object[0]);
                    return true;
                }
                catch (JavascriptException jsError) {
                    this.error = jsError;
                    return false;
                }
                catch (WebDriverException unexpectedException) {
                    this.error = unexpectedException;
                    LOG.log(Level.WARNING, String.format("Failed to execute JavaScript `%s`", javaScript), unexpectedException);
                    return false;
                }
            }

            public String toString() {
                return String.format("JS code `%s` to be executable, but... %s", javaScript, ExpectedConditions.shortDescription((Exception)((Object)this.error)));
            }
        };
    }

    public static ExpectedCondition<@Nullable Object> jsReturnsValue(final String javaScript) {
        return new ExpectedCondition<Object>(){
            private @Nullable WebDriverException error;

            @Override
            public @Nullable Object apply(WebDriver driver) {
                this.error = null;
                try {
                    Object value = ((JavascriptExecutor)driver).executeScript(javaScript, new Object[0]);
                    if (value instanceof Collection) {
                        return ((Collection)value).isEmpty() ? null : value;
                    }
                    if (value instanceof String) {
                        return ((String)value).isEmpty() ? null : value;
                    }
                    return value;
                }
                catch (JavascriptException jsError) {
                    this.error = jsError;
                    return null;
                }
                catch (WebDriverException unexpectedException) {
                    this.error = unexpectedException;
                    LOG.log(Level.WARNING, String.format("Failed to execute JavaScript `%s`", javaScript), unexpectedException);
                    return null;
                }
            }

            public String toString() {
                return String.format("JS code `%s` to return a value, but... %s", javaScript, ExpectedConditions.shortDescription((Exception)((Object)this.error)));
            }
        };
    }

    private static String shortDescription(@Nullable Exception exception) {
        if (exception == null) {
            return "";
        }
        String message = Objects.requireNonNullElse(exception.getMessage(), "null");
        return exception.getClass().getName() + ": " + message.split("\\n", 2)[0];
    }
}

