/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.commandhandler;

import com.google.common.collect.ImmutableMap;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.ActiveSessions;
import org.openqa.selenium.remote.server.CommandHandler;

public class GetAllSessions
implements CommandHandler {
    private final ActiveSessions allSessions;
    private final Json json;

    public GetAllSessions(ActiveSessions allSessions, Json json) {
        this.allSessions = Objects.requireNonNull(allSessions);
        this.json = Objects.requireNonNull(json);
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) throws IOException {
        ArrayList value = new ArrayList();
        this.allSessions.getAllSessions().forEach(s -> value.add(ImmutableMap.of((Object)"id", (Object)s.getId().toString(), (Object)"capabilities", s.getCapabilities())));
        ImmutableMap payloadObj = ImmutableMap.of((Object)"status", (Object)0, (Object)"value", value);
        byte[] payload = this.json.toJson((Object)payloadObj).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(200);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(payload.length));
        resp.setContent(payload);
    }
}

