/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium.node;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;

public class ChromeMutator
implements Function<ImmutableCapabilities, ImmutableCapabilities> {
    private final Object binary;

    public ChromeMutator(Capabilities config) {
        this.binary = "chrome".equals(config.getBrowserName()) ? config.getCapability("chrome_binary") : null;
    }

    @Override
    public ImmutableCapabilities apply(ImmutableCapabilities capabilities) {
        if (this.binary == null || !"chrome".equals(capabilities.getBrowserName())) {
            return capabilities;
        }
        HashMap toReturn = new HashMap();
        toReturn.putAll(capabilities.asMap());
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (capabilities.getCapability("goog:chromeOptions") instanceof Map) {
            Map asMap = (Map)capabilities.getCapability("goog:chromeOptions");
            options.putAll(asMap);
        }
        if (!(options.get("binary") instanceof String)) {
            options.put("binary", this.binary);
        }
        toReturn.put("goog:chromeOptions", options);
        return new ImmutableCapabilities(toReturn);
    }
}

