/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils;

import com.google.common.io.CharStreams;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.utils.configuration.GridHubConfiguration;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;
import org.openqa.grid.shared.GridNodeServer;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.NodeW3CStatusServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.internal.HttpClientFactory;
import org.openqa.selenium.remote.server.log.LoggingManager;

public class SelfRegisteringRemote {
    private static final Logger LOG = Logger.getLogger(SelfRegisteringRemote.class.getName());
    private final RegistrationRequest registrationRequest;
    private final HttpClientFactory httpClientFactory;
    private final Map<String, Class<? extends Servlet>> nodeServlets;
    private boolean hasId;
    private GridNodeServer server;

    public SelfRegisteringRemote(RegistrationRequest request) {
        this.registrationRequest = request;
        this.httpClientFactory = new HttpClientFactory();
        this.nodeServlets = new HashMap<String, Class<? extends Servlet>>();
        this.registrationRequest.validate();
        try {
            GridHubConfiguration hubConfiguration = this.getHubConfiguration();
            if (hubConfiguration.timeout != null && hubConfiguration.timeout >= 0) {
                this.registrationRequest.getConfiguration().timeout = hubConfiguration.timeout;
            }
            if (hubConfiguration.browserTimeout != null && hubConfiguration.browserTimeout >= 0) {
                this.registrationRequest.getConfiguration().browserTimeout = hubConfiguration.browserTimeout;
            }
        }
        catch (Exception e) {
            LOG.warning("error getting the parameters from the hub. The node may end up with wrong timeouts." + e.getMessage());
        }
        this.nodeServlets.put("/status", NodeW3CStatusServlet.class);
        this.nodeServlets.put("/wd/hub/status", NodeW3CStatusServlet.class);
        if (!this.registrationRequest.getConfiguration().isWithOutServlet(ResourceServlet.class)) {
            this.nodeServlets.put("/resources/*", ResourceServlet.class);
        }
        if (!this.registrationRequest.getConfiguration().isWithOutServlet(DisplayHelpServlet.class)) {
            this.nodeServlets.put("/*", DisplayHelpServlet.class);
        }
        this.addExtraServlets(this.registrationRequest.getConfiguration().servlets);
    }

    public URL getRemoteURL() {
        String host = this.registrationRequest.getConfiguration().host;
        Integer port = this.registrationRequest.getConfiguration().port;
        String url = "http://" + host + ":" + port;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new GridConfigurationException("error building the node url " + e.getMessage(), e);
        }
    }

    public void setRemoteServer(GridNodeServer server) {
        this.server = server;
    }

    public void startRemoteServer() throws Exception {
        if (this.server == null) {
            throw new GridConfigurationException("no server set to register to the hub");
        }
        this.server.setExtraServlets(this.nodeServlets);
        this.server.boot();
    }

    public void stopRemoteServer() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public void deleteAllBrowsers() {
        this.registrationRequest.getConfiguration().capabilities.clear();
    }

    public void addBrowser(DesiredCapabilities cap, int instances) {
        String s = cap.getBrowserName();
        if (s == null || "".equals(s)) {
            throw new InvalidParameterException(cap + " does seems to be a valid browser.");
        }
        if (cap.getPlatform() == null) {
            cap.setPlatform(Platform.getCurrent());
        }
        cap.setCapability("maxInstances", (Object)instances);
        this.registrationRequest.getConfiguration().capabilities.add((MutableCapabilities)cap);
    }

    public void sendRegistrationRequest() {
        this.registerToHub(false);
    }

    public void startRegistrationProcess() {
        this.fixUpId();
        LOG.fine("Using the json request : " + this.registrationRequest.toJson());
        Boolean register = this.registrationRequest.getConfiguration().register;
        if (register == null) {
            register = false;
        }
        if (!register.booleanValue()) {
            LOG.info("No registration sent ( register = false )");
        } else {
            int registerCycleInterval;
            int n = registerCycleInterval = this.registrationRequest.getConfiguration().registerCycle != null ? this.registrationRequest.getConfiguration().registerCycle : 0;
            if (registerCycleInterval > 0) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        boolean first = true;
                        LOG.info("Starting auto registration thread. Will try to register every " + registerCycleInterval + " ms.");
                        while (true) {
                            try {
                                boolean checkForPresence = true;
                                if (first) {
                                    first = false;
                                    checkForPresence = false;
                                }
                                SelfRegisteringRemote.this.registerToHub(checkForPresence);
                            }
                            catch (GridException e) {
                                LOG.info("Couldn't register this node: " + e.getMessage());
                            }
                            try {
                                Thread.sleep(registerCycleInterval);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            LoggingManager.perSessionLogHandler().clearThreadTempLogs();
                        }
                    }
                }).start();
            } else {
                this.registerToHub(false);
            }
        }
        LoggingManager.perSessionLogHandler().clearThreadTempLogs();
    }

    public void setTimeout(int timeout, int cycle) {
        this.registrationRequest.getConfiguration().timeout = timeout;
        this.registrationRequest.getConfiguration().cleanUpCycle = cycle;
    }

    public void setMaxConcurrent(int max) {
        this.registrationRequest.getConfiguration().maxSession = max;
    }

    public GridNodeConfiguration getConfiguration() {
        return this.registrationRequest.getConfiguration();
    }

    protected GridNodeServer getServer() {
        return this.server;
    }

    protected Map<String, Class<? extends Servlet>> getNodeServlets() {
        return this.nodeServlets;
    }

    private void registerToHub(boolean checkPresenceFirst) {
        if (!checkPresenceFirst || !this.isAlreadyRegistered(this.registrationRequest)) {
            String tmp = "http://" + this.registrationRequest.getConfiguration().getHubHost() + ":" + this.registrationRequest.getConfiguration().getHubPort() + "/grid/register";
            HttpClient client = this.httpClientFactory.getHttpClient();
            try {
                URL registration = new URL(tmp);
                LOG.info("Registering the node to the hub: " + registration);
                BasicHttpEntityEnclosingRequest r = new BasicHttpEntityEnclosingRequest("POST", registration.toExternalForm());
                this.updateConfigWithRealPort();
                String json = this.registrationRequest.toJson().toString();
                r.setEntity((HttpEntity)new StringEntity(json, "UTF-8"));
                HttpHost host = new HttpHost(registration.getHost(), registration.getPort());
                HttpResponse response = client.execute(host, (HttpRequest)r);
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new GridException(String.format("The hub responded with %s:%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
                }
                LOG.info("The node is registered to the hub and ready to use");
            }
            catch (Exception e) {
                throw new GridException("Error sending the registration request: " + e.getMessage());
            }
        } else {
            LOG.fine("The node is already present on the hub. Skipping registration.");
        }
    }

    private void addExtraServlets(List<String> servlets) {
        if (servlets == null || servlets.size() == 0) {
            return;
        }
        for (String s : servlets) {
            Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
            if (servletClass == null) continue;
            String path = "/extra/" + servletClass.getSimpleName() + "/*";
            LOG.info("binding " + servletClass.getCanonicalName() + " to " + path);
            this.nodeServlets.put(path, servletClass);
        }
    }

    private void fixUpId() {
        if (this.hasId) {
            return;
        }
        if (this.registrationRequest.getConfiguration().id == null || this.registrationRequest.getConfiguration().id.isEmpty()) {
            this.registrationRequest.getConfiguration().id = this.registrationRequest.getConfiguration().getRemoteHost();
        }
        this.hasId = true;
    }

    void updateConfigWithRealPort() throws MalformedURLException {
        if (this.registrationRequest.getConfiguration().port != 0) {
            return;
        }
        this.registrationRequest.getConfiguration().port = this.server.getRealPort();
    }

    private GridHubConfiguration getHubConfiguration() throws Exception {
        String hubApi = "http://" + this.registrationRequest.getConfiguration().getHubHost() + ":" + this.registrationRequest.getConfiguration().getHubPort() + "/grid/api/hub";
        HttpClient client = this.httpClientFactory.getHttpClient();
        URL api = new URL(hubApi);
        HttpHost host = new HttpHost(api.getHost(), api.getPort());
        String url = api.toExternalForm();
        BasicHttpRequest r = new BasicHttpRequest("GET", url);
        HttpResponse response = client.execute(host, (HttpRequest)r);
        return GridHubConfiguration.loadFromJSON(SelfRegisteringRemote.extractObject(response));
    }

    private boolean isAlreadyRegistered(RegistrationRequest node) {
        HttpClient client = this.httpClientFactory.getHttpClient();
        try {
            BasicHttpRequest r;
            HttpResponse response;
            String tmp = "http://" + node.getConfiguration().getHubHost() + ":" + node.getConfiguration().getHubPort() + "/grid/api/proxy";
            URL api = new URL(tmp);
            HttpHost host = new HttpHost(api.getHost(), api.getPort());
            String id = node.getConfiguration().id;
            if (id == null) {
                id = node.getConfiguration().getRemoteHost();
            }
            if ((response = client.execute(host, (HttpRequest)(r = new BasicHttpRequest("GET", api.toExternalForm() + "?id=" + id)))).getStatusLine().getStatusCode() != 200) {
                throw new GridException(String.format("The hub responded with %s:%s", response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase()));
            }
            JsonObject o = SelfRegisteringRemote.extractObject(response);
            return o.get("success").getAsBoolean();
        }
        catch (Exception e) {
            throw new GridException("The hub is down or not responding: " + e.getMessage());
        }
    }

    private static JsonObject extractObject(HttpResponse resp) throws IOException {
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(resp.getEntity().getContent()));){
            StringBuilder s = new StringBuilder();
            CharStreams.copy((Readable)rd, (Appendable)s);
            JsonObject jsonObject = new JsonParser().parse(s.toString()).getAsJsonObject();
            return jsonObject;
        }
    }
}

