/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.remote.http.HttpResponse;

class ServletResponseWrappingHttpResponse
extends HttpResponse {
    private final HttpServletResponse resp;

    public ServletResponseWrappingHttpResponse(HttpServletResponse resp) {
        this.resp = (HttpServletResponse)Preconditions.checkNotNull((Object)resp, (Object)"Response to wrap must not be null");
    }

    public int getStatus() {
        return this.resp.getStatus();
    }

    public void setStatus(int status) {
        this.resp.setStatus(status);
    }

    public Iterable<String> getHeaderNames() {
        return this.resp.getHeaderNames();
    }

    public Iterable<String> getHeaders(String name) {
        return this.resp.getHeaders(name);
    }

    public String getHeader(String name) {
        return this.resp.getHeader(name);
    }

    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        this.resp.addHeader(name, value);
    }

    public void removeHeader(String name) {
        throw new UnsupportedOperationException("removeHeader");
    }

    public void setContent(byte[] data) {
        this.resp.setContentLength(data.length);
        this.setContent(new ByteArrayInputStream(data));
    }

    public void setContent(InputStream toStreamFrom) {
        try (ServletOutputStream buffered = this.resp.getOutputStream();){
            ByteStreams.copy((InputStream)toStreamFrom, (OutputStream)buffered);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getContent() {
        throw new UnsupportedOperationException("getContent");
    }

    public String getContentString() {
        throw new UnsupportedOperationException("getContentString");
    }

    public InputStream consumeContentStream() {
        throw new UnsupportedOperationException("consumeContentStream");
    }
}

