/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.Map;
import org.openqa.grid.internal.exception.NewSessionException;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonException;

public class ExternalSessionKey {
    private final String key;

    public ExternalSessionKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalSessionKey that = (ExternalSessionKey)o;
        return this.key.equals(that.key);
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.getKey();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static ExternalSessionKey fromSe1Request(String piece) {
        if (piece.startsWith("sessionId=")) {
            return new ExternalSessionKey(piece.replace("sessionId=", ""));
        }
        return null;
    }

    public static ExternalSessionKey fromWebDriverRequest(String path) {
        int sessionIndex = path.indexOf("/session/");
        if (sessionIndex != -1) {
            String session;
            int nextSlash = path.indexOf("/", sessionIndex += "/session/".length());
            if ("".equals(session = nextSlash != -1 ? path.substring(sessionIndex, nextSlash) : path.substring(sessionIndex, path.length()))) {
                return null;
            }
            return new ExternalSessionKey(session);
        }
        return null;
    }

    public static ExternalSessionKey fromJsonResponseBody(String responseBody) {
        try {
            Map value;
            Map json = (Map)new Json().toType((Object)responseBody, Json.MAP_TYPE);
            if (json.get("sessionId") instanceof String) {
                return new ExternalSessionKey((String)json.get("sessionId"));
            }
            if (json.get("value") instanceof Map && (value = (Map)json.get("value")).get("sessionId") instanceof String) {
                return new ExternalSessionKey((String)value.get("sessionId"));
            }
        }
        catch (ClassCastException | JsonException e) {
            return null;
        }
        return null;
    }

    public static ExternalSessionKey fromResponseBody(String responseBody) throws NewSessionException {
        if (responseBody != null && responseBody.startsWith("OK,")) {
            return new ExternalSessionKey(responseBody.replace("OK,", ""));
        }
        throw new NewSessionException("The server returned an error : " + responseBody);
    }

    public static ExternalSessionKey fromString(String keyString) {
        return new ExternalSessionKey(keyString);
    }

    public static ExternalSessionKey fromJSON(String keyString) {
        return new ExternalSessionKey(keyString);
    }
}

