/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web.servlet;

import com.google.common.io.ByteStreams;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.openqa.selenium.internal.BuildInfo;

public class DisplayHelpServlet
extends HttpServlet {
    private static final long serialVersionUID = 8484071790930378855L;
    private static final Logger log = Logger.getLogger(DisplayHelpServlet.class.getName());
    private static String coreVersion;

    public DisplayHelpServlet() {
        coreVersion = new BuildInfo().getReleaseLabel();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.process(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        response.setStatus(200);
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        builder.append("<head>");
        builder.append("<title>Selenium Grid ").append(coreVersion).append(" help</title>");
        builder.append("</head>");
        builder.append("<body>");
        builder.append("You are using grid ").append(coreVersion);
        builder.append("<br>Find help on the official selenium wiki : <a href='https://github.com/SeleniumHQ/selenium/wiki/Grid2'>more help here</a>");
        builder.append("<br>default monitoring page : <a href='/grid/console'>console</a>");
        builder.append("</body>");
        builder.append("</html>");
        ByteArrayInputStream in = new ByteArrayInputStream(builder.toString().getBytes("UTF-8"));
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)response.getOutputStream());
        }
        finally {
            ((InputStream)in).close();
            response.flushBuffer();
        }
    }
}

