/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import org.openqa.grid.common.JSONConfigurationUtils;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.utils.CapabilityMatcher;
import org.openqa.grid.internal.utils.DefaultCapabilityMatcher;
import org.openqa.grid.internal.utils.configuration.GridConfiguration;
import org.openqa.grid.internal.utils.configuration.GridNodeConfiguration;

public class GridHubConfiguration
extends GridConfiguration {
    @Parameter(names={"-hubConfig"}, description="<String> filename: a JSON file (following grid2 format), which defines the hub properties")
    public String hubConfig;
    @Parameter(names={"-jettyMaxThreads"}, description="<Integer> : max number of thread for Jetty. Default is 255")
    public Integer jettyMaxThreads;
    @Parameter(names={"-matcher", "-capabilityMatcher"}, description="<String> class name : a class implementing the CapabilityMatcher interface. Specifies the logic the hub will follow to define whether a request can be assigned to a node. For example, if you want to have the matching process use regular expressions instead of exact match when specifying browser version. ALL nodes of a grid ecosystem would then use the same capabilityMatcher, as defined here. Default is org.openqa.grid.internal.utils.DefaultCapabilityMatcher", converter=CapabilityMatcherString.class)
    public CapabilityMatcher capabilityMatcher = new DefaultCapabilityMatcher();
    @Parameter(names={"-newSessionWaitTimeout"}, description="<Integer> in ms : The time after which a new test waiting for a node to become available will time out. When that happens, the test will throw an exception before attempting to start a browser. Defaults to no timeout ( -1 )")
    public Integer newSessionWaitTimeout = -1;
    @Parameter(names={"-prioritizer"}, description="<String> class name : a class implementing the Prioritizer interface. Specify a custom Prioritizer if you want to sort the order in which new session requests are processed when there is a queue. Default to null ( no priority = FIFO )", converter=PrioritizerString.class)
    public Prioritizer prioritizer = null;
    @Parameter(names={"-throwOnCapabilityNotPresent"}, description="<Boolean> true or false : If true, the hub will reject all test requests if no compatible proxy is currently registered. If set to false, the request will queue until a node supporting the capability is registered with the grid. Default is true")
    public Boolean throwOnCapabilityNotPresent = true;
    private static final GridHubConfiguration DEFAULT_CONFIG = GridHubConfiguration.loadFromJSON(JSONConfigurationUtils.loadJSON("defaults/DefaultHub.json"));

    public GridHubConfiguration() {
        if (DEFAULT_CONFIG != null) {
            this.merge(DEFAULT_CONFIG);
        }
    }

    public static GridHubConfiguration loadFromJSON(JsonObject json) {
        try {
            GsonBuilder builder = new GsonBuilder();
            GridHubConfiguration.staticAddJsonTypeAdapter(builder);
            return (GridHubConfiguration)builder.create().fromJson((JsonElement)json, GridHubConfiguration.class);
        }
        catch (Throwable e) {
            throw new GridConfigurationException("Error with the JSON of the config : " + e.getMessage(), e);
        }
    }

    public void merge(GridNodeConfiguration other) {
        super.merge(other);
    }

    public void merge(GridHubConfiguration other) {
        super.merge(other);
        if (other.jettyMaxThreads != null) {
            this.jettyMaxThreads = other.jettyMaxThreads;
        }
        this.capabilityMatcher = other.capabilityMatcher;
        if (other.newSessionWaitTimeout != null) {
            this.newSessionWaitTimeout = other.newSessionWaitTimeout;
        }
        if (other.prioritizer != null) {
            this.prioritizer = other.prioritizer;
        }
        if (other.throwOnCapabilityNotPresent != this.throwOnCapabilityNotPresent) {
            this.throwOnCapabilityNotPresent = other.throwOnCapabilityNotPresent;
        }
    }

    @Override
    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(format));
        sb.append((CharSequence)this.toString(format, "hubConfig", this.hubConfig));
        sb.append((CharSequence)this.toString(format, "jettyMaxThreads", this.jettyMaxThreads));
        sb.append((CharSequence)this.toString(format, "capabilityMatcher", this.capabilityMatcher.getClass().getCanonicalName()));
        sb.append((CharSequence)this.toString(format, "newSessionWaitTimeout", this.newSessionWaitTimeout));
        sb.append((CharSequence)this.toString(format, "prioritizer", this.prioritizer != null ? this.prioritizer.getClass().getCanonicalName() : null));
        sb.append((CharSequence)this.toString(format, "throwOnCapabilityNotPresent", this.throwOnCapabilityNotPresent));
        return sb.toString();
    }

    @Override
    protected void addJsonTypeAdapter(GsonBuilder builder) {
        super.addJsonTypeAdapter(builder);
        GridHubConfiguration.staticAddJsonTypeAdapter(builder);
    }

    protected static void staticAddJsonTypeAdapter(GsonBuilder builder) {
        builder.registerTypeAdapter(CapabilityMatcher.class, (Object)new CapabilityMatcherAdapter().nullSafe());
        builder.registerTypeAdapter(Prioritizer.class, (Object)new PrioritizerAdapter().nullSafe());
    }

    protected static class PrioritizerAdapter
    extends SimpleClassNameAdapter<Prioritizer> {
        protected PrioritizerAdapter() {
        }
    }

    protected static class CapabilityMatcherAdapter
    extends SimpleClassNameAdapter<CapabilityMatcher> {
        protected CapabilityMatcherAdapter() {
        }
    }

    protected static class SimpleClassNameAdapter<T>
    extends TypeAdapter<T> {
        protected SimpleClassNameAdapter() {
        }

        public void write(JsonWriter out, T value) throws IOException {
            out.value(value.getClass().getCanonicalName());
        }

        public T read(JsonReader in) throws IOException {
            String value = in.nextString();
            try {
                return (T)Class.forName(value).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("String %s could not be coerced to class: %s", value, Class.class.getName()), e);
            }
        }
    }

    private class CapabilityMatcherString
    implements IStringConverter<CapabilityMatcher> {
        private CapabilityMatcherString() {
        }

        public CapabilityMatcher convert(String capabilityMatcherClass) {
            try {
                return (CapabilityMatcher)Class.forName(capabilityMatcherClass).newInstance();
            }
            catch (Throwable e) {
                throw new GridConfigurationException("Error creating Prioritizer from class " + capabilityMatcherClass + " : " + e.getMessage(), e);
            }
        }
    }

    private class PrioritizerString
    implements IStringConverter<Prioritizer> {
        private PrioritizerString() {
        }

        public Prioritizer convert(String prioritizerClass) {
            try {
                return (Prioritizer)Class.forName(prioritizerClass).newInstance();
            }
            catch (Throwable e) {
                throw new GridConfigurationException("Error creating Prioritizer from class " + prioritizerClass + " : " + e.getMessage(), e);
            }
        }
    }
}

