/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.thoughtworks.selenium.CommandProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import org.openqa.selenium.server.browserlaunchers.ProcessorCommands;

public class ServerHttpChannel
implements Runnable {
    private static final Logger log = Logger.getLogger(ServerHttpChannel.class.getName());
    private final String serverUrl;
    private final String sessionId;
    private final CommandProcessor processor;
    private final ProcessorCommands commands = new ProcessorCommands();
    private int sequenceNumber;
    private HttpURLConnection connection;
    private volatile boolean carryOn = true;

    public ServerHttpChannel(String sessionId, int serverPort, CommandProcessor processor) {
        this.sessionId = sessionId;
        this.processor = processor;
        this.serverUrl = String.format("http://localhost:%d/selenium-server/driver/?localFrameAddress=top&seleniumWindowName=&uniqueId=%s", serverPort, UUID.randomUUID());
    }

    @Override
    public void run() {
        try {
            this.send("OK," + this.sessionId, null);
            while (this.carryOn) {
                String raw = this.read();
                log.fine("read complete: " + raw);
                if (!this.carryOn) continue;
                this.carryOn = this.execute(this.processor, raw);
            }
            this.send("OK", null);
        }
        catch (ConnectException e) {
            log.warning("Unable to connect to server. Assuming shutdown.");
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
    }

    private boolean execute(CommandProcessor processor, String raw) throws IOException {
        String[] args;
        Map<String, String> command = this.parse(raw);
        if (command == null) {
            return false;
        }
        if (command.containsKey("value")) {
            args = new String[]{command.get("target"), command.get("value")};
        } else {
            args = new String[1];
            args[1] = command.get("target");
        }
        String commandName = command.get("command");
        if ("retryLast".equals(commandName)) {
            this.send("RETRY", "retry=true");
            return true;
        }
        StringBuilder value = new StringBuilder();
        try {
            String result = this.commands.execute(processor, commandName, args);
            value.append("OK");
            if (result != null) {
                value.append(",").append(result);
            }
        }
        catch (Throwable e) {
            value.append("ERROR,").append(e.getMessage());
        }
        this.send(value.toString(), null);
        return true;
    }

    private Map<String, String> parse(String raw) {
        if (!raw.startsWith("json=")) {
            return null;
        }
        JsonObject converted = new JsonParser().parse(raw.substring("json=".length())).getAsJsonObject();
        HashMap toReturn = Maps.newHashMap();
        for (Map.Entry entry : converted.entrySet()) {
            toReturn.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
        }
        return toReturn;
    }

    public void kill() {
        this.carryOn = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String postedData, String urlParams) throws IOException {
        log.fine("Sending a response: " + postedData);
        StringBuilder builder = new StringBuilder(this.serverUrl).append("&sessionId=").append(this.sessionId);
        if (this.sequenceNumber == 0) {
            builder.append("&seleniumStart=true");
        }
        builder.append("&sequenceNumber=").append(this.sequenceNumber++);
        if (urlParams != null) {
            builder.append("&").append(urlParams);
        }
        StringBuilder response = new StringBuilder("postedData=");
        response.append(URLEncoder.encode(postedData, Charsets.UTF_8.name()));
        byte[] toSend = response.toString().getBytes(Charsets.UTF_8);
        this.connection = (HttpURLConnection)new URL(builder.toString()).openConnection();
        this.connection.setUseCaches(false);
        this.connection.setDoOutput(true);
        this.connection.setRequestMethod("POST");
        this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF8");
        this.connection.setRequestProperty("Content-Length", String.valueOf(toSend.length));
        try (OutputStream out = this.connection.getOutputStream();){
            out.write(toSend);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read() throws IOException {
        byte[] bytes = null;
        try (InputStream input = this.connection.getInputStream();){
            bytes = ByteStreams.toByteArray((InputStream)input);
        }
        this.connection.disconnect();
        this.connection = null;
        return new String(bytes, Charsets.UTF_8);
    }
}

