/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.common;

import java.util.ArrayList;
import java.util.List;
import org.openqa.grid.common.exception.GridConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GridRole {
    NOT_GRID,
    HUB,
    REMOTE_CONTROL,
    WEBDRIVER;


    public static GridRole find(String[] args) {
        if (args == null) {
            return NOT_GRID;
        }
        for (int i = 0; i < args.length; ++i) {
            if (!"-role".equals(args[i])) continue;
            if (i == args.length) {
                throw new GridConfigurationException("-role needs to be followed by the role of this component in the grid.");
            }
            String role = args[i + 1].toLowerCase();
            if (GridRole.RCAliases().contains(role)) {
                return REMOTE_CONTROL;
            }
            if (GridRole.WDAliases().contains(role)) {
                return WEBDRIVER;
            }
            if ("hub".equals(role)) {
                return HUB;
            }
            throw new GridConfigurationException("The role specified :" + role + " doesn't match a recognized role for grid.");
        }
        return NOT_GRID;
    }

    private static List<String> RCAliases() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("rc");
        res.add("remotecontrol");
        res.add("remote-control");
        return res;
    }

    private static List<String> WDAliases() {
        ArrayList<String> res = new ArrayList<String>();
        res.add("wd");
        res.add("webdriver");
        return res;
    }
}

