/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.selenium;

import java.util.logging.Logger;
import org.openqa.grid.common.CommandLineOptionHelper;
import org.openqa.grid.common.GridDocHelper;
import org.openqa.grid.common.GridRole;
import org.openqa.grid.common.RegistrationRequest;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.internal.utils.SelfRegisteringRemote;
import org.openqa.grid.web.Hub;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.cli.RemoteControlLauncher;

public class GridLauncher {
    private static final Logger log = Logger.getLogger(GridLauncher.class.getName());

    public static void main(String[] args) throws Exception {
        CommandLineOptionHelper helper = new CommandLineOptionHelper(args);
        if (helper.isParamPresent("-help") || helper.isParamPresent("-h")) {
            String separator = "\n----------------------------------\n";
            RemoteControlLauncher.usage(separator + "To use as a standalone server" + separator);
            GridDocHelper.printHelp(separator + "To use in a grid environement :" + separator, false);
            return;
        }
        GridRole role = GridRole.find(args);
        switch (role) {
            case NOT_GRID: {
                log.info("Launching a standalone server");
                SeleniumServer.main(args);
                break;
            }
            case HUB: {
                log.info("Launching a selenium grid server");
                try {
                    GridHubConfiguration c = GridHubConfiguration.build(args);
                    Hub h = new Hub(c);
                    h.start();
                }
                catch (GridConfigurationException e) {
                    e.printStackTrace();
                    GridDocHelper.printHelp(e.getMessage());
                }
                break;
            }
            case NODE: {
                log.info("Launching a selenium grid node");
                try {
                    RegistrationRequest c = RegistrationRequest.build(args);
                    SelfRegisteringRemote remote = new SelfRegisteringRemote(c);
                    remote.startRemoteServer();
                    remote.startRegistrationProcess();
                }
                catch (GridConfigurationException e) {
                    e.printStackTrace();
                    GridDocHelper.printHelp(e.getMessage());
                }
                break;
            }
            default: {
                throw new RuntimeException("NI");
            }
        }
    }
}

