/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.jetty.jmx;

import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.jmx.HttpServerMBean;
import org.openqa.jetty.jetty.Server;
import org.openqa.jetty.log.LogFactory;

public class ServerMBean
extends HttpServerMBean {
    private static Log log = LogFactory.getLog(ServerMBean.class);
    private Server _jettyServer;
    private String _configuration;

    public ServerMBean(Server jettyServer) throws MBeanException, InstanceNotFoundException {
        super(jettyServer);
    }

    public ServerMBean() throws MBeanException, InstanceNotFoundException {
        this(new Server());
    }

    public ServerMBean(String configuration) throws IOException, MBeanException, InstanceNotFoundException {
        this(new Server());
        this._configuration = configuration;
    }

    protected ObjectName newObjectName(MBeanServer server) {
        return this.uniqueObjectName(server, ServerMBean.getDefaultDomain() + ":Server=");
    }

    protected void defineManagedResource() {
        super.defineManagedResource();
        this.defineAttribute("configuration");
        this.defineAttribute("rootWebApp");
        this.defineAttribute("webApplicationConfigurationClassNames");
        this.defineOperation("addWebApplication", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("addWebApplication", new String[]{"java.lang.String", "java.lang.String", "java.lang.String"}, 1);
        this.defineOperation("addWebApplications", new String[]{"java.lang.String", "java.lang.String"}, 1);
        this._jettyServer = (Server)this.getManagedResource();
    }

    public void postRegister(Boolean ok) {
        super.postRegister(ok);
        if (ok.booleanValue() && this._configuration != null) {
            try {
                this._jettyServer.configure(this._configuration);
                this._jettyServer.start();
            }
            catch (Exception e) {
                log.warn((Object)"EXCEPTION ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDeregister() {
        this._configuration = null;
        try {
            block4: {
                try {
                    if (null == this._jettyServer) break block4;
                    this._jettyServer.stop();
                }
                catch (Exception e) {
                    log.warn((Object)e);
                    Object var3_2 = null;
                    super.postDeregister();
                }
            }
            Object var3_1 = null;
            super.postDeregister();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            super.postDeregister();
            throw throwable;
        }
    }
}

