/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.html;

import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import org.openqa.jetty.html.Composite;
import org.openqa.jetty.html.Element;
import org.openqa.jetty.html.Form;
import org.openqa.jetty.html.Input;
import org.openqa.jetty.html.Select;
import org.openqa.jetty.html.Table;
import org.openqa.jetty.html.TextArea;

public class TableForm
extends Form {
    private Table table = null;
    private Table column = null;
    private int columns = 1;
    private Composite hidden = new Composite();
    private Composite buttons = null;
    private Composite bottomButtons = null;
    private String fieldAttributes = null;
    private boolean extendRow = false;

    public TableForm(String target) {
        super(target);
        this.newTable();
        super.add(this.hidden);
    }

    public void addText(String label, String value) {
        Composite c = new Composite();
        c.add(value);
        this.addField(label, c);
    }

    public Input addTextField(String tag, String label, int length, String value) {
        Input i = new Input("text", tag, value);
        i.setSize(length);
        this.addField(label, i);
        return i;
    }

    public TextArea addTextArea(String tag, String label, int width, int height, String value) {
        TextArea ta = new TextArea(tag, value);
        ta.setSize(width, height);
        this.addField(label, ta);
        return ta;
    }

    public Input addFileField(String tag, String label) {
        Input i = new Input("file", tag);
        this.addField(label, i);
        return i;
    }

    public void addInfoField(String tag, String label, String value) {
        this.addText(label, value);
        this.addHiddenField(tag, value);
    }

    public void addHiddenField(String tag, String value) {
        Input e = new Input("hidden", tag, value);
        this.hidden.add(e);
    }

    public void addPassword(String tag, String label, int length) {
        Input i = new Input("password", tag);
        i.setSize(length);
        this.addField(label, i);
    }

    public void addCheckbox(String tag, String label, boolean checked) {
        Input cb = new Input("checkbox", tag);
        this.addField(label, cb);
        if (checked) {
            cb.check();
        }
    }

    public Select addSelect(String tag, String label, boolean multiple, int size) {
        Select s = new Select(tag, multiple);
        s.setSize(size);
        this.addField(label, s);
        return s;
    }

    public Select addSelect(String tag, String label, boolean multiple, int size, Enumeration values) {
        Select s = this.addSelect(tag, label, multiple, size);
        s.setSize(size);
        while (values.hasMoreElements()) {
            s.add(values.nextElement().toString());
        }
        return s;
    }

    public void addButtonArea(String label) {
        this.buttons = new Composite();
        this.addField(label, this.buttons);
    }

    public void addButtonArea() {
        this.buttons = new Composite();
        this.addField(null, this.buttons);
    }

    public void addButtonRow() {
        this.buttons = new Composite();
        if (!this.extendRow) {
            this.column.newRow();
            this.column.addCell(this.buttons).left().middle();
            this.column.cell().attribute("colspan", "2");
        }
        this.extendRow = false;
    }

    public void buttonsAtBottom() {
        if (this.bottomButtons != null) {
            this.buttons = this.bottomButtons;
        } else {
            this.bottomButtons = this.buttons = new Composite();
        }
    }

    public Input addButton(String tag, String label) {
        if (this.buttons == null) {
            this.buttonsAtBottom();
        }
        Input e = new Input("submit", tag, label);
        if (this.extendRow) {
            this.addField(null, e);
        } else {
            this.buttons.add(e);
        }
        return e;
    }

    public void addReset(String label) {
        if (this.buttons == null) {
            this.buttonsAtBottom();
        }
        Input e = new Input("reset", "Reset", label);
        if (this.extendRow) {
            this.addField(null, e);
        } else {
            this.buttons.add(e);
        }
    }

    public void useAttributes(String attr) {
        this.fieldAttributes = attr;
    }

    public Table table() {
        return this.column;
    }

    public Table outerTable() {
        return this.table;
    }

    public TableForm extendRow() {
        this.extendRow = true;
        return this;
    }

    public void addField(String label, Element field) {
        label = label == null ? "&nbsp;" : "<b>" + label + ":</b>";
        if (this.extendRow) {
            this.column.add(field);
            this.extendRow = false;
        } else {
            this.column.newRow();
            this.column.addCell(label);
            this.column.cell().right();
            if (this.fieldAttributes != null) {
                this.column.addCell(field, this.fieldAttributes);
                this.fieldAttributes = null;
            } else {
                this.column.addCell(field);
            }
        }
    }

    public void addColumn() {
        this.column = new Table(0);
        this.table.addCell(this.column).top();
        ++this.columns;
    }

    public void addColumn(int spacing) {
        this.table.addCell("&nbsp", "width=" + spacing);
        this.column = new Table(0);
        this.table.addCell(this.column);
        this.table.cell().top();
        ++this.columns;
    }

    public void newColumns() {
        this.column = new Table(0);
        this.columns = 1;
        this.table.newRow();
        this.table.addCell(this.column);
        this.table.cell().top();
    }

    public void setColumnSpan(int span) {
        this.table.cell().attribute("colspan", "" + span);
    }

    public void newTable() {
        this.table = new Table(0);
        this.column = new Table(0);
        this.columns = 1;
        super.add(this.table);
        this.table.newRow();
        this.table.addCell(this.column).top();
    }

    public void write(Writer out) throws IOException {
        if (this.bottomButtons != null) {
            this.table.newRow();
            this.table.addCell(this.bottomButtons).attribute("colspan", this.columns);
        }
        super.write(out);
    }
}

