/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.internal.ActiveTestSessions;
import org.openqa.grid.internal.ExternalSessionKey;
import org.openqa.grid.internal.NewSessionRequestQueue;
import org.openqa.grid.internal.ProxySet;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.SessionTerminationReason;
import org.openqa.grid.internal.TestSession;
import org.openqa.grid.internal.TestSlot;
import org.openqa.grid.internal.listeners.Prioritizer;
import org.openqa.grid.internal.listeners.RegistrationListener;
import org.openqa.grid.internal.listeners.SelfHealingProxy;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.web.Hub;
import org.openqa.grid.web.servlet.handler.RequestHandler;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.internal.HttpClientFactory;
import org.openqa.selenium.server.log.LoggingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class Registry {
    public static final String KEY = Registry.class.getName();
    private static final Logger log = Logger.getLogger(Registry.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition testSessionAvailable = this.lock.newCondition();
    private final ProxySet proxies;
    private final ActiveTestSessions activeTestSessions = new ActiveTestSessions();
    private final GridHubConfiguration configuration;
    private final HttpClientFactory httpClientFactory;
    private final NewSessionRequestQueue newSessionQueue;
    private final Matcher matcherThread = new Matcher();
    private final List<RemoteProxy> registeringProxies = new CopyOnWriteArrayList<RemoteProxy>();
    private volatile boolean stop = false;
    private volatile int newSessionWaitTimeout;
    private volatile Prioritizer prioritizer;
    private volatile Hub hub;

    private Registry(Hub hub, GridHubConfiguration config) {
        this.hub = hub;
        this.newSessionWaitTimeout = config.getNewSessionWaitTimeout();
        this.prioritizer = config.getPrioritizer();
        this.newSessionQueue = new NewSessionRequestQueue();
        this.configuration = config;
        this.httpClientFactory = new HttpClientFactory();
        this.proxies = new ProxySet(config.isThrowOnCapabilityNotPresent());
        this.matcherThread.setUncaughtExceptionHandler(new UncaughtExceptionHandler());
    }

    public static Registry newInstance() {
        return Registry.newInstance(null, new GridHubConfiguration());
    }

    public static Registry newInstance(Hub hub, GridHubConfiguration config) {
        Registry registry = new Registry(hub, config);
        registry.matcherThread.start();
        try {
            Thread.sleep(250L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return registry;
    }

    public GridHubConfiguration getConfiguration() {
        return this.configuration;
    }

    public int getNewSessionWaitTimeout() {
        return this.newSessionWaitTimeout;
    }

    public void setNewSessionWaitTimeout(int newSessionWaitTimeout) {
        this.newSessionWaitTimeout = newSessionWaitTimeout;
    }

    public void terminate(final TestSession session, final SessionTerminationReason reason) {
        new Thread(new Runnable(){

            public void run() {
                Registry.this._release(session.getSlot(), reason);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _release(TestSlot testSlot, SessionTerminationReason reason) {
        if (!testSlot.startReleaseProcess()) {
            return;
        }
        if (!testSlot.performAfterSessionEvent()) {
            return;
        }
        String internalKey = testSlot.getInternalKey();
        try {
            this.lock.lock();
            testSlot.finishReleaseProcess();
            this.release(internalKey, reason);
            Object var5_4 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    void terminateSynchronousFOR_TEST_ONLY(TestSession testSession) {
        this._release(testSession.getSlot(), SessionTerminationReason.CLIENT_STOPPED_SESSION);
    }

    public void removeIfPresent(RemoteProxy proxy) {
        if (this.proxies.contains(proxy)) {
            log.warning(String.format("Proxy '%s' was previously registered.  Cleaning up any stale test sessions.", proxy));
            RemoteProxy p = this.proxies.remove(proxy);
            for (TestSlot slot : p.getTestSlots()) {
                this.forceRelease(slot, SessionTerminationReason.PROXY_REREGISTRATION);
            }
            p.teardown();
        }
    }

    public void forceRelease(TestSlot testSlot, SessionTerminationReason reason) {
        if (testSlot.getSession() == null) {
            return;
        }
        String internalKey = testSlot.getInternalKey();
        this.release(internalKey, reason);
        testSlot.doFinishRelease();
    }

    public void stop() {
        this.stop = true;
        this.matcherThread.interrupt();
        this.newSessionQueue.stop();
        this.proxies.teardown();
        this.httpClientFactory.close();
    }

    public Hub getHub() {
        return this.hub;
    }

    public void setHub(Hub hub) {
        this.hub = hub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNewSessionRequest(RequestHandler request) {
        try {
            this.lock.lock();
            this.proxies.verifyAbilityToHandleDesiredCapabilities(request.getDesiredCapabilities());
            this.newSessionQueue.add(request);
            this.fireMatcherStateChanged();
            Object var3_2 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void assignRequestToProxy() {
        while (!this.stop) {
            try {
                this.testSessionAvailable.await(5L, TimeUnit.SECONDS);
                this.newSessionQueue.processQueue(new Predicate<RequestHandler>(){

                    public boolean apply(RequestHandler input) {
                        return Registry.this.takeRequestHandler(input);
                    }
                }, this.prioritizer);
                LoggingManager.perSessionLogHandler().clearThreadTempLogs();
            }
            catch (InterruptedException e) {
                log.info("Shutting down registry.");
            }
            catch (Throwable t) {
                log.log(Level.SEVERE, "Unhandled exception in Matcher thread.", t);
            }
        }
    }

    private boolean takeRequestHandler(RequestHandler request) {
        boolean sessionCreated;
        TestSession session = this.proxies.getNewSession(request.getDesiredCapabilities());
        boolean bl = sessionCreated = session != null;
        if (sessionCreated) {
            this.activeTestSessions.add(session);
            request.bindSession(session);
        }
        return sessionCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(TestSession session, SessionTerminationReason reason) {
        try {
            this.lock.lock();
            boolean removed = this.activeTestSessions.remove(session, reason);
            if (removed) {
                this.fireMatcherStateChanged();
            }
            Object var5_4 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    private void release(String internalKey, SessionTerminationReason reason) {
        if (internalKey == null) {
            return;
        }
        TestSession session1 = this.activeTestSessions.findSessionByInternalKey(internalKey);
        if (session1 != null) {
            this.release(session1, reason);
            return;
        }
        log.warning("Tried to release session with internal key " + internalKey + " but couldn't find it.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RemoteProxy proxy) {
        if (proxy == null) {
            return;
        }
        log.fine("adding  " + proxy);
        try {
            this.lock.lock();
            this.removeIfPresent(proxy);
            if (this.registeringProxies.contains(proxy)) {
                log.warning(String.format("Proxy '%s' is already queued for registration.", proxy));
                Object var3_2 = null;
                this.lock.unlock();
                return;
            }
            this.registeringProxies.add(proxy);
            this.fireMatcherStateChanged();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.lock.unlock();
            throw throwable;
        }
        Object var3_3 = null;
        this.lock.unlock();
        boolean listenerOk = true;
        try {
            if (proxy instanceof RegistrationListener) {
                ((RegistrationListener)((Object)proxy)).beforeRegistration();
            }
        }
        catch (Throwable t) {
            log.severe("Error running the registration listener on " + proxy + ", " + t.getMessage());
            t.printStackTrace();
            listenerOk = false;
        }
        try {
            this.lock.lock();
            this.registeringProxies.remove(proxy);
            if (listenerOk) {
                if (proxy instanceof SelfHealingProxy) {
                    ((SelfHealingProxy)((Object)proxy)).startPolling();
                }
                this.proxies.add(proxy);
                this.fireMatcherStateChanged();
            }
            Object var5_8 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.lock.unlock();
            throw throwable;
        }
    }

    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.proxies.setThrowOnCapabilityNotPresent(throwOnCapabilityNotPresent);
    }

    private void fireMatcherStateChanged() {
        this.testSessionAvailable.signalAll();
    }

    public ProxySet getAllProxies() {
        return this.proxies;
    }

    public List<RemoteProxy> getUsedProxies() {
        return this.proxies.getBusyProxies();
    }

    public TestSession getSession(ExternalSessionKey externalKey) {
        return this.activeTestSessions.findSessionByExternalKey(externalKey);
    }

    public TestSession getExistingSession(ExternalSessionKey externalKey) {
        return this.activeTestSessions.getExistingSession(externalKey);
    }

    public int getNewSessionRequestCount() {
        return this.newSessionQueue.getNewSessionRequestCount();
    }

    public void clearNewSessionRequests() {
        this.newSessionQueue.clearNewSessionRequests();
    }

    public boolean removeNewSessionRequest(RequestHandler request) {
        return this.newSessionQueue.removeNewSessionRequest(request);
    }

    public Iterable<DesiredCapabilities> getDesiredCapabilities() {
        return this.newSessionQueue.getDesiredCapabilities();
    }

    public Set<TestSession> getActiveSessions() {
        return this.activeTestSessions.unmodifiableSet();
    }

    public void setPrioritizer(Prioritizer prioritizer) {
        this.prioritizer = prioritizer;
    }

    public Prioritizer getPrioritizer() {
        return this.prioritizer;
    }

    public RemoteProxy getProxyById(String id) {
        return this.proxies.getProxyById(id);
    }

    HttpClientFactory getHttpClientFactory() {
        return this.httpClientFactory;
    }

    private static class UncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtExceptionHandler() {
        }

        public void uncaughtException(Thread t, Throwable e) {
            log.log(Level.SEVERE, "Matcher thread dying due to unhandled exception.", e);
        }
    }

    class Matcher
    extends Thread {
        Matcher() {
            super("Matcher thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Registry.this.lock.lock();
                Registry.this.assignRequestToProxy();
                Object var2_1 = null;
                Registry.this.lock.unlock();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Registry.this.lock.unlock();
                throw throwable;
            }
        }
    }
}

