/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.openqa.grid.common.exception.CapabilityNotPresentOnTheGridException;
import org.openqa.grid.common.exception.GridException;
import org.openqa.grid.internal.RemoteProxy;
import org.openqa.grid.internal.TestSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ProxySet
implements Iterable<RemoteProxy> {
    private final Set<RemoteProxy> proxies = new CopyOnWriteArraySet<RemoteProxy>();
    private static final Logger log = Logger.getLogger(ProxySet.class.getName());
    private volatile boolean throwOnCapabilityNotPresent = true;

    public ProxySet(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }

    public void teardown() {
        for (RemoteProxy proxy : this.proxies) {
            proxy.teardown();
        }
    }

    public boolean hasCapability(Map<String, Object> requestedCapability) {
        for (RemoteProxy proxy : this.proxies) {
            if (!proxy.hasCapability(requestedCapability)) continue;
            return true;
        }
        return false;
    }

    public RemoteProxy remove(RemoteProxy proxy) {
        for (RemoteProxy p : this.proxies) {
            if (!p.equals(proxy)) continue;
            this.proxies.remove(p);
            return p;
        }
        throw new IllegalStateException("Did not contain proxy" + proxy);
    }

    public void add(RemoteProxy proxy) {
        this.proxies.add(proxy);
    }

    public boolean contains(RemoteProxy o) {
        return this.proxies.contains(o);
    }

    public List<RemoteProxy> getBusyProxies() {
        ArrayList<RemoteProxy> res = new ArrayList<RemoteProxy>();
        for (RemoteProxy proxy : this.proxies) {
            if (!proxy.isBusy()) continue;
            res.add(proxy);
        }
        return res;
    }

    public RemoteProxy getProxyById(String id) {
        if (id == null) {
            return null;
        }
        for (RemoteProxy p : this.proxies) {
            if (!id.equals(p.getId())) continue;
            return p;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.proxies.isEmpty();
    }

    private List<RemoteProxy> getSorted() {
        ArrayList<RemoteProxy> sorted = new ArrayList<RemoteProxy>(this.proxies);
        Collections.sort(sorted);
        return sorted;
    }

    public TestSession getNewSession(Map<String, Object> desiredCapabilities) {
        List<RemoteProxy> sorted = this.getSorted();
        for (RemoteProxy proxy : sorted) {
            TestSession session = proxy.getNewSession(desiredCapabilities);
            if (session == null) continue;
            return session;
        }
        return null;
    }

    @Override
    public Iterator<RemoteProxy> iterator() {
        return this.proxies.iterator();
    }

    public int size() {
        return this.proxies.size();
    }

    public void verifyAbilityToHandleDesiredCapabilities(Map<String, Object> desiredCapabilities) {
        if (this.proxies.isEmpty()) {
            if (this.throwOnCapabilityNotPresent) {
                throw new GridException("Empty pool of VM for setup " + desiredCapabilities);
            }
            log.warning("Empty pool of nodes.");
        }
        if (!this.hasCapability(desiredCapabilities)) {
            if (this.throwOnCapabilityNotPresent) {
                throw new CapabilityNotPresentOnTheGridException(desiredCapabilities);
            }
            log.warning("grid doesn't contain " + desiredCapabilities + " at the moment.");
        }
    }

    public void setThrowOnCapabilityNotPresent(boolean throwOnCapabilityNotPresent) {
        this.throwOnCapabilityNotPresent = throwOnCapabilityNotPresent;
    }
}

