/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Platform;
import org.openqa.selenium.Rotatable;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.html5.ApplicationCache;
import org.openqa.selenium.html5.BrowserConnection;
import org.openqa.selenium.html5.DatabaseStorage;
import org.openqa.selenium.html5.LocationContext;
import org.openqa.selenium.html5.WebStorage;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.server.DriverFactory;
import org.openqa.selenium.remote.server.KnownElements;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.SnapshotScreenListener;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.events.WebDriverEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSession
implements Session {
    private final SessionId sessionId;
    private final WebDriver driver;
    private final KnownElements knownElements = new KnownElements();
    private final ThreadPoolExecutor executor;
    private final Capabilities capabilities;
    private volatile String base64EncodedImage;
    private volatile long lastAccess;
    private final BrowserCreator browserCreator;
    private TemporaryFilesystem tempFs;

    public static Session createSession(DriverFactory factory, SessionId sessionId, Capabilities capabilities) throws Exception {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), sessionId.toString());
        if (!tmpDir.mkdir()) {
            throw new WebDriverException("Cannot create temp directory: " + tmpDir);
        }
        TemporaryFilesystem tempFs = TemporaryFilesystem.getTmpFsBasedOn((File)tmpDir);
        return new DefaultSession(factory, tempFs, sessionId, capabilities);
    }

    @VisibleForTesting
    public static Session createSession(DriverFactory factory, TemporaryFilesystem tempFs, SessionId sessionId, Capabilities capabilities) throws Exception {
        return new DefaultSession(factory, tempFs, sessionId, capabilities);
    }

    private DefaultSession(DriverFactory factory, TemporaryFilesystem tempFs, SessionId sessionId, Capabilities capabilities) throws Exception {
        this.sessionId = sessionId;
        this.tempFs = tempFs;
        this.browserCreator = new BrowserCreator(factory, capabilities);
        FutureTask<EventFiringWebDriver> webDriverFutureTask = new FutureTask<EventFiringWebDriver>(this.browserCreator);
        this.executor = new ThreadPoolExecutor(1, 1, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        EventFiringWebDriver initialDriver = this.execute(webDriverFutureTask);
        if (!this.browserCreator.isAndroid()) {
            initialDriver.register((WebDriverEventListener)new SnapshotScreenListener(this));
        }
        this.driver = initialDriver;
        this.capabilities = this.browserCreator.getCapabilityDescription();
        this.updateLastAccessTime();
    }

    @Override
    public void updateLastAccessTime() {
        this.lastAccess = System.currentTimeMillis();
    }

    @Override
    public boolean isTimedOut(int timeout) {
        return this.lastAccess + (long)timeout < System.currentTimeMillis();
    }

    @Override
    public void close() {
        this.executor.shutdown();
        this.tempFs.deleteTemporaryFiles();
        this.tempFs.deleteBaseDir();
    }

    @Override
    public <X> X execute(FutureTask<X> future) throws Exception {
        this.executor.execute(future);
        return future.get();
    }

    @Override
    public WebDriver getDriver() {
        this.updateLastAccessTime();
        return this.driver;
    }

    @Override
    public KnownElements getKnownElements() {
        return this.knownElements;
    }

    @Override
    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public void attachScreenshot(String base64EncodedImage) {
        this.base64EncodedImage = base64EncodedImage;
    }

    @Override
    public String getAndClearScreenshot() {
        String temp = this.base64EncodedImage;
        this.base64EncodedImage = null;
        return temp;
    }

    @Override
    public SessionId getSessionId() {
        return this.sessionId;
    }

    @Override
    public TemporaryFilesystem getTemporaryFileSystem() {
        return this.tempFs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BrowserCreator
    implements Callable<EventFiringWebDriver> {
        private final DriverFactory factory;
        private final Capabilities capabilities;
        private volatile Capabilities describedCapabilities;
        private volatile boolean isAndroid = false;

        BrowserCreator(DriverFactory factory, Capabilities capabilities) {
            this.factory = factory;
            this.capabilities = capabilities;
        }

        @Override
        public EventFiringWebDriver call() throws Exception {
            WebDriver rawDriver = this.factory.newInstance(this.capabilities);
            Capabilities actualCapabilities = this.capabilities;
            if (rawDriver instanceof RemoteWebDriver) {
                actualCapabilities = ((RemoteWebDriver)rawDriver).getCapabilities();
                this.isAndroid = actualCapabilities.getPlatform().is(Platform.ANDROID);
            }
            this.describedCapabilities = this.getDescription(rawDriver, actualCapabilities);
            return new EventFiringWebDriver(rawDriver);
        }

        public Capabilities getCapabilityDescription() {
            return this.describedCapabilities;
        }

        public boolean isAndroid() {
            return this.isAndroid;
        }

        private DesiredCapabilities getDescription(WebDriver instance, Capabilities capabilities) {
            DesiredCapabilities caps = new DesiredCapabilities(capabilities.asMap());
            caps.setJavascriptEnabled(instance instanceof JavascriptExecutor);
            if (instance instanceof TakesScreenshot) {
                caps.setCapability("takesScreenshot", true);
            }
            if (instance instanceof DatabaseStorage) {
                caps.setCapability("databaseEnabled", true);
            }
            if (instance instanceof LocationContext) {
                caps.setCapability("locationContextEnabled", true);
            }
            if (instance instanceof ApplicationCache) {
                caps.setCapability("applicationCacheEnabled", true);
            }
            if (instance instanceof BrowserConnection) {
                caps.setCapability("browserConnectionEnabled", true);
            }
            if (instance instanceof WebStorage) {
                caps.setCapability("webStorageEnabled", true);
            }
            if (instance instanceof FindsByCssSelector) {
                caps.setCapability("cssSelectorsEnabled", true);
            }
            if (instance instanceof Rotatable) {
                caps.setCapability("rotatable", true);
            }
            return caps;
        }
    }
}

