/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.jetty.http.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.openqa.jetty.http.HttpConnection;
import org.openqa.jetty.http.Version;
import org.openqa.jetty.http.ajp.AJP13InputStream;
import org.openqa.jetty.http.ajp.AJP13Listener;
import org.openqa.jetty.http.ajp.AJP13OutputStream;
import org.openqa.jetty.log.LogFactory;
import org.openqa.jetty.util.LineInput;
import org.openqa.jetty.util.LogSupport;
import org.openqa.jetty.util.URI;

public class AJP13Connection
extends HttpConnection {
    private static Log log = LogFactory.getLog(AJP13Connection.class);
    private AJP13Listener _listener;
    private AJP13InputStream _ajpIn;
    private AJP13OutputStream _ajpOut;
    private String _remoteHost;
    private String _remoteAddr;
    private String _serverName;
    private int _serverPort;
    private boolean _isSSL;

    public AJP13Connection(AJP13Listener listener, InputStream in, OutputStream out, Socket socket, int bufferSize) throws IOException {
        super(listener, null, new AJP13InputStream(in, out, bufferSize), out, socket);
        LineInput lin = (LineInput)this.getInputStream().getInputStream();
        this._ajpIn = (AJP13InputStream)lin.getInputStream();
        this._ajpOut = new AJP13OutputStream(this.getOutputStream().getOutputStream(), bufferSize);
        this._ajpOut.setCommitObserver(this);
        this.getOutputStream().setBufferedOutputStream(this._ajpOut);
        this._listener = listener;
    }

    public InetAddress getRemoteInetAddress() {
        return null;
    }

    public void destroy() {
        if (this._ajpIn != null) {
            this._ajpIn.destroy();
        }
        this._ajpIn = null;
        if (this._ajpOut != null) {
            this._ajpOut.destroy();
        }
        this._ajpOut = null;
        this._remoteHost = null;
        this._remoteAddr = null;
        this._serverName = null;
    }

    public String getRemoteAddr() {
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        return this._remoteHost;
    }

    public String getServerName() {
        return this._serverName;
    }

    public int getServerPort() {
        return this._serverPort;
    }

    public String getDefaultScheme() {
        return this._isSSL ? "https" : super.getDefaultScheme();
    }

    public boolean isSSL() {
        return this._isSSL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handleNext() {
        block80: {
            block74: {
                block79: {
                    block73: {
                        block78: {
                            block71: {
                                packet = null;
                                request = this.getRequest();
                                response = this.getResponse();
                                context = null;
                                gotRequest = false;
                                this._persistent = true;
                                this._keepAlive = true;
                                try {
                                    try {
                                        block72: {
                                            try {
                                                packet = null;
                                                packet = this._ajpIn.nextPacket();
                                                if (packet == null) {
                                                    var6_6 = false;
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            catch (IOException e) {
                                                LogSupport.ignore(AJP13Connection.log, e);
                                                var7_40 = false;
                                                var18_14 = null;
                                                if (packet == null) return false;
                                                if (!gotRequest) {
                                                    return false;
                                                }
                                                try {
                                                    try {
                                                        this.getOutputStream().close();
                                                        if (!this._persistent) {
                                                            this._ajpOut.end();
                                                        }
                                                        this._ajpOut.close();
                                                        this.getOutputStream().resetStream();
                                                        this.getOutputStream().addObserver(this);
                                                        this.getInputStream().resetStream();
                                                        this._ajpIn.resetStream();
                                                        this._ajpOut.resetStream();
                                                        v0 = null;
                                                    }
                                                    catch (Exception e) {
                                                        AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                                                        this._persistent = false;
                                                        v0 = null;
                                                    }
                                                }
                                                catch (Throwable var20_28) {
                                                    v0 = null;
                                                }
                                                var21_35 = v0;
                                                this.statsRequestEnd();
                                                if (context == null) return var7_40;
                                                context.log(request, response, -1);
                                                return var7_40;
                                            }
                                            var18_12 = null;
                                            if (packet == null) return false;
                                            if (!gotRequest) {
                                                return false;
                                            }
                                            break block71;
lbl-1000:
                                            // 1 sources

                                            {
                                                if (packet.getDataSize() != 0) break block72;
                                                var6_7 = true;
                                            }
                                            break block73;
                                        }
                                        type = packet.getByte();
                                        if (AJP13Connection.log.isDebugEnabled()) {
                                            AJP13Connection.log.debug((Object)("AJP13 type=" + type + " size=" + packet.unconsumedData()));
                                        }
                                        switch (type) {
                                            case 2: {
                                                request.setTimeStamp(System.currentTimeMillis());
                                                request.setState(0);
                                                request.setMethod(packet.getMethod());
                                                request.setVersion(packet.getString());
                                                version = packet.getString();
                                                try {
                                                    request.setVersion(version);
                                                }
                                                catch (Exception e) {
                                                    AJP13Connection.log.warn((Object)("Bad version" + version), (Throwable)e);
                                                    AJP13Connection.log.warn((Object)packet.toString());
                                                }
                                                path = packet.getString();
                                                sc = path.lastIndexOf(";");
                                                if (sc < 0) {
                                                    request.setPath(URI.encodePath(path));
                                                } else {
                                                    request.setPath(URI.encodePath(path.substring(0, sc)) + path.substring(sc));
                                                }
                                                this._remoteAddr = packet.getString();
                                                this._remoteHost = packet.getString();
                                                this._serverName = packet.getString();
                                                this._serverPort = packet.getInt();
                                                this._isSSL = packet.getBoolean();
                                                this._keepAlive = request.getDotVersion() >= 1;
                                                h = packet.getInt();
                                                for (i = 0; i < h; ++i) {
                                                    hdr = packet.getHeader();
                                                    val = packet.getString();
                                                    request.addField(hdr, val);
                                                    if (this._keepAlive || !hdr.equalsIgnoreCase("Connection") || !val.equalsIgnoreCase("keep-alive")) continue;
                                                    this._keepAlive = true;
                                                }
                                                attr = packet.getByte();
                                                while ((255 & attr) != 255) {
                                                    value = attr == 11 ? null : packet.getString();
                                                    switch (attr) {
                                                        case 11: {
                                                            request.setAttribute("javax.servlet.request.key_size", new Integer(packet.getInt()));
                                                            break;
                                                        }
                                                        case 10: {
                                                            request.setAttribute(value, packet.getString());
                                                            break;
                                                        }
                                                        case 9: {
                                                            request.setAttribute("javax.servlet.request.ssl_session", value);
                                                            break;
                                                        }
                                                        case 8: {
                                                            request.setAttribute("javax.servlet.request.cipher_suite", value);
                                                            break;
                                                        }
                                                        case 7: {
                                                            cf = CertificateFactory.getInstance("X.509");
                                                            certstream = new ByteArrayInputStream(value.getBytes());
                                                            cert = (X509Certificate)cf.generateCertificate(certstream);
                                                            certs = new X509Certificate[]{cert};
                                                            request.setAttribute("javax.servlet.request.X509Certificate", certs);
                                                            break;
                                                        }
                                                        case 6: {
                                                            request.setAttribute("org.openqa.jetty.http.ajp.JVMRoute", value);
                                                            break;
                                                        }
                                                        case 5: {
                                                            request.setQuery(value);
                                                            break;
                                                        }
                                                        case 4: {
                                                            request.setAuthType(value);
                                                            break;
                                                        }
                                                        case 3: {
                                                            request.setAuthUser(value);
                                                            break;
                                                        }
                                                        default: {
                                                            AJP13Connection.log.warn((Object)("Unknown attr: " + attr + "=" + value));
                                                        }
                                                    }
                                                    attr = packet.getByte();
                                                }
                                                this._listener.customizeRequest(this, request);
                                                gotRequest = true;
                                                this.statsRequestStart();
                                                request.setState(2);
                                                if (request.getContentLength() == 0 && request.getField("Transfer-Encoding") == null) {
                                                    this._ajpIn.close();
                                                }
                                                response.setState(0);
                                                response.setVersion("HTTP/1.1");
                                                response.setDateField("Date", this._request.getTimeStamp());
                                                if (!Version.isParanoid()) {
                                                    response.setField("Server", Version.getDetail());
                                                }
                                                if (AJP13Connection.log.isDebugEnabled()) {
                                                    AJP13Connection.log.debug((Object)("REQUEST:\n" + request));
                                                }
                                                context = this.service(request, response);
                                                if (!AJP13Connection.log.isDebugEnabled()) break;
                                                AJP13Connection.log.debug((Object)("RESPONSE:\n" + response));
                                                break;
                                            }
                                            default: {
                                                if (AJP13Connection.log.isDebugEnabled()) {
                                                    AJP13Connection.log.debug((Object)("Ignored: " + packet));
                                                }
                                                this._persistent = false;
                                                break;
                                            }
                                        }
                                        break block74;
                                    }
                                    catch (SocketException e) {
                                        block75: {
                                            LogSupport.ignore(AJP13Connection.log, e);
                                            this._persistent = false;
                                            var18_16 = null;
                                            if (packet == null) return false;
                                            if (!gotRequest) {
                                                return false;
                                            }
                                            ** try [egrp 6[TRYBLOCK] [20 : 1067->1162)] { 
lbl178:
                                            // 1 sources

                                            ** try [egrp 7[TRYBLOCK] [19 : 1067->1131)] { 
lbl179:
                                            // 1 sources

                                            this.getOutputStream().close();
                                            if (!this._persistent) {
                                                this._ajpOut.end();
                                            }
                                            this._ajpOut.close();
                                            this.getOutputStream().resetStream();
                                            this.getOutputStream().addObserver(this);
                                            this.getInputStream().resetStream();
                                            this._ajpIn.resetStream();
                                            this._ajpOut.resetStream();
                                            v1 = null;
lbl190:
                                            // 1 sources

                                            catch (Exception e) {
                                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                                                this._persistent = false;
                                                v1 = null;
                                            }
                                            break block75;
lbl195:
                                            // 1 sources

                                            catch (Throwable var20_30) {
                                                v1 = null;
                                            }
                                        }
                                        var21_37 = v1;
                                        this.statsRequestEnd();
                                        if (context == null) return this._persistent;
                                        context.log(request, response, -1);
                                        return this._persistent;
                                    }
                                    catch (Exception e) {
                                        block76: {
                                            AJP13Connection.log.warn((Object)"EXCEPTION ", (Throwable)e);
                                            this._persistent = false;
                                            try {
                                                if (gotRequest) {
                                                    this._ajpOut.close();
                                                }
                                            }
                                            catch (IOException e2) {
                                                LogSupport.ignore(AJP13Connection.log, e2);
                                            }
                                            var18_17 = null;
                                            if (packet == null) return false;
                                            if (!gotRequest) {
                                                return false;
                                            }
                                            ** try [egrp 6[TRYBLOCK] [20 : 1067->1162)] { 
lbl218:
                                            // 1 sources

                                            ** try [egrp 7[TRYBLOCK] [19 : 1067->1131)] { 
lbl219:
                                            // 1 sources

                                            this.getOutputStream().close();
                                            if (!this._persistent) {
                                                this._ajpOut.end();
                                            }
                                            this._ajpOut.close();
                                            this.getOutputStream().resetStream();
                                            this.getOutputStream().addObserver(this);
                                            this.getInputStream().resetStream();
                                            this._ajpIn.resetStream();
                                            this._ajpOut.resetStream();
                                            v2 = null;
lbl230:
                                            // 1 sources

                                            catch (Exception e) {
                                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                                                this._persistent = false;
                                                v2 = null;
                                            }
                                            break block76;
lbl235:
                                            // 1 sources

                                            catch (Throwable var20_31) {
                                                v2 = null;
                                            }
                                        }
                                        var21_38 = v2;
                                        this.statsRequestEnd();
                                        if (context == null) return this._persistent;
                                        context.log(request, response, -1);
                                        return this._persistent;
                                    }
                                }
                                catch (Throwable var17_53) {
                                    block77: {
                                        var18_18 = null;
                                        if (packet == null) return false;
                                        if (!gotRequest) {
                                            return false;
                                        }
                                        ** try [egrp 6[TRYBLOCK] [20 : 1067->1162)] { 
lbl250:
                                        // 1 sources

                                        ** try [egrp 7[TRYBLOCK] [19 : 1067->1131)] { 
lbl251:
                                        // 1 sources

                                        this.getOutputStream().close();
                                        if (!this._persistent) {
                                            this._ajpOut.end();
                                        }
                                        this._ajpOut.close();
                                        this.getOutputStream().resetStream();
                                        this.getOutputStream().addObserver(this);
                                        this.getInputStream().resetStream();
                                        this._ajpIn.resetStream();
                                        this._ajpOut.resetStream();
                                        v3 = null;
lbl262:
                                        // 1 sources

                                        catch (Exception e) {
                                            AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                                            this._persistent = false;
                                            v3 = null;
                                        }
                                        break block77;
lbl267:
                                        // 1 sources

                                        catch (Throwable var20_32) {
                                            v3 = null;
                                        }
                                    }
                                    var21_39 = v3;
                                    this.statsRequestEnd();
                                    if (context == null) throw var17_53;
                                    context.log(request, response, -1);
                                    throw var17_53;
                                }
                            }
                            ** try [egrp 6[TRYBLOCK] [20 : 1067->1162)] { 
lbl277:
                            // 1 sources

                            ** try [egrp 7[TRYBLOCK] [19 : 1067->1131)] { 
lbl278:
                            // 1 sources

                            this.getOutputStream().close();
                            if (!this._persistent) {
                                this._ajpOut.end();
                            }
                            this._ajpOut.close();
                            this.getOutputStream().resetStream();
                            this.getOutputStream().addObserver(this);
                            this.getInputStream().resetStream();
                            this._ajpIn.resetStream();
                            this._ajpOut.resetStream();
                            v4 = null;
lbl289:
                            // 1 sources

                            catch (Exception e) {
                                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                                this._persistent = false;
                                v4 = null;
                            }
                            break block78;
lbl294:
                            // 1 sources

                            catch (Throwable var20_26) {
                                v4 = null;
                            }
                        }
                        var21_33 = v4;
                        this.statsRequestEnd();
                        if (context == null) return var6_6;
                        context.log(request, response, -1);
                        return var6_6;
                    }
                    var18_13 = null;
                    if (packet == null) return false;
                    if (!gotRequest) {
                        return false;
                    }
                    ** try [egrp 6[TRYBLOCK] [20 : 1067->1162)] { 
lbl308:
                    // 1 sources

                    ** try [egrp 7[TRYBLOCK] [19 : 1067->1131)] { 
lbl309:
                    // 1 sources

                    this.getOutputStream().close();
                    if (!this._persistent) {
                        this._ajpOut.end();
                    }
                    this._ajpOut.close();
                    this.getOutputStream().resetStream();
                    this.getOutputStream().addObserver(this);
                    this.getInputStream().resetStream();
                    this._ajpIn.resetStream();
                    this._ajpOut.resetStream();
                    v5 = null;
lbl320:
                    // 1 sources

                    catch (Exception e) {
                        AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                        this._persistent = false;
                        v5 = null;
                    }
                    break block79;
lbl325:
                    // 1 sources

                    catch (Throwable var20_27) {
                        v5 = null;
                    }
                }
                var21_34 = v5;
                this.statsRequestEnd();
                if (context == null) return var6_7;
                context.log(request, response, -1);
                return var6_7;
            }
            var18_15 = null;
            if (packet == null) return false;
            if (!gotRequest) {
                return false;
            }
            ** try [egrp 6[TRYBLOCK] [20 : 1067->1162)] { 
lbl339:
            // 1 sources

            ** try [egrp 7[TRYBLOCK] [19 : 1067->1131)] { 
lbl340:
            // 1 sources

            this.getOutputStream().close();
            if (!this._persistent) {
                this._ajpOut.end();
            }
            this._ajpOut.close();
            this.getOutputStream().resetStream();
            this.getOutputStream().addObserver(this);
            this.getInputStream().resetStream();
            this._ajpIn.resetStream();
            this._ajpOut.resetStream();
            v6 = null;
lbl351:
            // 1 sources

            catch (Exception e) {
                AJP13Connection.log.debug((Object)"EXCEPTION ", (Throwable)e);
                this._persistent = false;
                v6 = null;
            }
            break block80;
lbl356:
            // 1 sources

            catch (Throwable var20_29) {
                v6 = null;
            }
        }
        var21_36 = v6;
        this.statsRequestEnd();
        if (context == null) return this._persistent;
        context.log(request, response, -1);
        return this._persistent;
    }

    protected void firstWrite() throws IOException {
        log.debug((Object)"ajp13 firstWrite()");
    }

    protected void commit() throws IOException {
        log.debug((Object)"ajp13 commit()");
        if (this._response.isCommitted()) {
            return;
        }
        this._request.setHandled(true);
        this.getOutputStream().writeHeader(this._response);
    }

    protected void setupOutputStream() throws IOException {
        if ("HEAD".equals(this.getRequest().getMethod())) {
            this.getOutputStream().nullOutput();
        }
    }
}

