/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.handler.BySelector;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindElements
extends WebDriverHandler
implements JsonParametersAware {
    private volatile By by;
    private volatile Response response;

    public FindElements(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        String method = (String)allParameters.get("using");
        String selector = (String)allParameters.get("value");
        this.by = new BySelector().pickFrom(method, selector);
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        List elements = this.getDriver().findElements(this.by);
        LinkedHashSet elementIds = Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)elements, (Function)new Function<WebElement, Map<String, String>>(){

            public Map<String, String> apply(WebElement element) {
                return ImmutableMap.of((Object)"ELEMENT", (Object)FindElements.this.getKnownElements().add(element));
            }
        }));
        this.response.setValue((Object)elementIds);
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("[find elements: %s", this.by);
    }
}

