/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.server.DriverSessions;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;
import org.openqa.selenium.remote.server.handler.internal.ArgumentConverter;
import org.openqa.selenium.remote.server.handler.internal.ResultConverter;
import org.openqa.selenium.remote.server.rest.ResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteScript
extends WebDriverHandler
implements JsonParametersAware {
    private volatile Response response;
    private volatile String script;
    private volatile List<Object> args = new ArrayList<Object>();

    public ExecuteScript(DriverSessions sessions) {
        super(sessions);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        this.script = (String)allParameters.get("script");
        List params = (List)allParameters.get("args");
        this.args = Lists.newArrayList((Iterable)Iterables.transform((Iterable)params, (Function)new ArgumentConverter(this.getKnownElements())));
    }

    @Override
    public ResultType call() throws Exception {
        this.response = this.newResponse();
        Object value = this.args.size() > 0 ? ((JavascriptExecutor)this.getDriver()).executeScript(this.script, this.args.toArray()) : ((JavascriptExecutor)this.getDriver()).executeScript(this.script, new Object[0]);
        Object result = new ResultConverter(this.getKnownElements()).apply(value);
        this.response.setValue(result);
        return ResultType.SUCCESS;
    }

    public Response getResponse() {
        return this.response;
    }

    public String toString() {
        return String.format("[execute script: %s, %s]", this.script, this.args);
    }
}

