/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.browserlaunchers;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.util.FileUtils;
import org.openqa.selenium.server.BrowserConfigurationOptions;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;
import org.openqa.selenium.server.browserlaunchers.ResourceExtractor;
import org.openqa.selenium.server.browserlaunchers.SafariCustomProfileLauncher;

public class SafariFileBasedLauncher
extends SafariCustomProfileLauncher {
    public SafariFileBasedLauncher(BrowserConfigurationOptions browserOptions, RemoteControlConfiguration configuration, String sessionId, String browserLaunchLocation) {
        super(browserOptions, configuration, sessionId, browserLaunchLocation);
    }

    protected void launch(String url) {
        String query = LauncherUtils.getQueryString(url);
        query = query + "&driverUrl=http://localhost:" + this.getPort() + "/selenium-server/driver/";
        try {
            if (this.browserConfigurationOptions.is("ensureCleanSession")) {
                this.ensureCleanSession();
            }
            String fileUrl = this.createExtractedFiles().toURL() + "?" + query;
            this.launchSafari(fileUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File createExtractedFiles() {
        File coreDir = new File(this.customProfileDir, "core");
        try {
            coreDir.mkdirs();
            ResourceExtractor.extractResourcePath(SafariFileBasedLauncher.class, "/core", coreDir);
            File userExtensions = this.browserConfigurationOptions.getFile("userExtensions");
            if (userExtensions != null) {
                File userExtensionsJavascriptFile = new File(coreDir, "scripts/user-extensions.js");
                FileUtils.getFileUtils().copyFile(userExtensions, userExtensionsJavascriptFile, null, true);
            }
            return new File(coreDir, "RemoteRunner.html");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

