/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.commands;

import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.openqa.jetty.log.LogFactory;
import org.openqa.selenium.server.RobotRetriever;
import org.openqa.selenium.server.commands.Command;

public class CaptureScreenshotCommand
extends Command {
    public static final String ID = "captureScreenshot";
    private static final Log LOGGER = LogFactory.getLog(CaptureScreenshotCommand.class);
    private final File file;

    public CaptureScreenshotCommand(String fileName) {
        this(new File(fileName));
    }

    CaptureScreenshotCommand(File file) {
        this.file = file;
    }

    private void createNecessaryDirectories() {
        File parentDir = this.file.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            parentDir.mkdirs();
        }
    }

    public String execute() {
        try {
            this.captureSystemScreenshot();
            return "OK";
        }
        catch (Exception e) {
            LOGGER.error((Object)"Problem capturing screenshot", (Throwable)e);
            return "ERROR: Problem capturing screenshot: " + e.getMessage();
        }
    }

    public void captureSystemScreenshot() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Robot robot = RobotRetriever.getRobot();
        Rectangle captureSize = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        BufferedImage bufferedImage = robot.createScreenCapture(captureSize);
        this.createNecessaryDirectories();
        ImageIO.write((RenderedImage)bufferedImage, "png", this.file);
    }
}

