/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server.handler;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.remote.server.JsonParametersAware;
import org.openqa.selenium.remote.server.Session;
import org.openqa.selenium.remote.server.handler.WebDriverHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CookieHandler
extends WebDriverHandler
implements JsonParametersAware {
    private volatile Map<String, Object> rawCookie;

    protected CookieHandler(Session session) {
        super(session);
    }

    @Override
    public void setJsonParameters(Map<String, Object> allParameters) throws Exception {
        if (allParameters == null) {
            return;
        }
        this.rawCookie = Maps.newHashMap((Map)((Map)allParameters.get("cookie")));
    }

    protected Cookie createCookie() {
        if (this.rawCookie == null) {
            return null;
        }
        String name = (String)this.rawCookie.get("name");
        String value = (String)this.rawCookie.get("value");
        String path = (String)this.rawCookie.get("path");
        String domain = (String)this.rawCookie.get("domain");
        Boolean secure = (Boolean)this.rawCookie.get("secure");
        Number expiryNum = (Number)this.rawCookie.get("expiry");
        Date expiry = expiryNum == null ? null : new Date(TimeUnit.SECONDS.toMillis(expiryNum.longValue()));
        return new Cookie.Builder(name, value).path(path).domain(domain).isSecure(secure.booleanValue()).expiresOn(expiry).build();
    }
}

