/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.server.DriverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDriverFactory
implements DriverFactory {
    private Map<Capabilities, Class<? extends WebDriver>> capabilitiesToDriver = new ConcurrentHashMap<Capabilities, Class<? extends WebDriver>>();

    @Override
    public void registerDriver(Capabilities capabilities, Class<? extends WebDriver> implementation) {
        this.capabilitiesToDriver.put(capabilities, implementation);
    }

    protected Class<? extends WebDriver> getBestMatchFor(Capabilities desired) {
        int numberOfFieldsMatched = 0;
        Class<? extends WebDriver> bestMatch = null;
        for (Map.Entry<Capabilities, Class<? extends WebDriver>> entry : this.capabilitiesToDriver.entrySet()) {
            int count = 0;
            Capabilities caps = entry.getKey();
            if (this.matches(caps.getBrowserName(), desired.getBrowserName())) {
                ++count;
            }
            if (this.matches(caps.getVersion(), desired.getVersion())) {
                ++count;
            }
            if (caps.isJavascriptEnabled() == desired.isJavascriptEnabled()) {
                ++count;
            }
            Platform capPlatform = caps.getPlatform();
            Platform desiredPlatform = desired.getPlatform();
            if (capPlatform != null && desiredPlatform != null && capPlatform.is(desiredPlatform)) {
                ++count;
            }
            if (count <= numberOfFieldsMatched) continue;
            numberOfFieldsMatched = count;
            bestMatch = entry.getValue();
        }
        return bestMatch;
    }

    private boolean matches(String value, String value2) {
        return value != null && value.equals(value2);
    }

    @Override
    public WebDriver newInstance(Capabilities capabilities) {
        Class<? extends WebDriver> clazz = this.getBestMatchFor(capabilities);
        return this.callConstructor(clazz, capabilities);
    }

    private WebDriver callConstructor(Class<? extends WebDriver> from, Capabilities capabilities) {
        try {
            Constructor<? extends WebDriver> constructor = from.getConstructor(Capabilities.class);
            return constructor.newInstance(capabilities);
        }
        catch (NoSuchMethodException e) {
            try {
                return from.newInstance();
            }
            catch (InstantiationException e1) {
                throw new WebDriverException((Throwable)e);
            }
            catch (IllegalAccessException e1) {
                throw new WebDriverException((Throwable)e);
            }
        }
        catch (InvocationTargetException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WebDriverException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    @Override
    public boolean hasMappingFor(Capabilities capabilities) {
        return this.capabilitiesToDriver.containsKey(capabilities);
    }
}

