/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.web;

import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.openqa.grid.internal.Registry;
import org.openqa.grid.internal.utils.GridHubConfiguration;
import org.openqa.grid.web.servlet.ConsoleServlet;
import org.openqa.grid.web.servlet.DisplayHelpServlet;
import org.openqa.grid.web.servlet.DriverServlet;
import org.openqa.grid.web.servlet.Grid1HeartbeatServlet;
import org.openqa.grid.web.servlet.ProxyStatusServlet;
import org.openqa.grid.web.servlet.RegistrationServlet;
import org.openqa.grid.web.servlet.ResourceServlet;
import org.openqa.grid.web.servlet.TestSessionStatusServlet;
import org.openqa.grid.web.utils.ExtraServletUtil;
import org.openqa.jetty.http.SocketListener;
import org.openqa.jetty.jetty.Server;
import org.openqa.jetty.jetty.servlet.WebApplicationContext;
import org.openqa.selenium.net.NetworkUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hub {
    private static final Logger log = Logger.getLogger(Hub.class.getName());
    private GridHubConfiguration config;
    private int port;
    private String host;
    private Server server;
    private Registry registry;
    private Map<String, Class<? extends Servlet>> extraServlet = Maps.newHashMap();
    private NetworkUtils utils = new NetworkUtils();

    private void addServlet(String key, Class<? extends Servlet> s) {
        this.extraServlet.put(key, s);
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Hub(GridHubConfiguration config) {
        this.config = config;
        this.registry = new Registry(this, config);
        this.host = config.getHost() != null ? config.getHost() : this.utils.getIp4NonLoopbackAddressOfThisMachine().getHostAddress();
        this.port = config.getPort();
        for (String s : config.getServlets()) {
            Class<? extends Servlet> servletClass = ExtraServletUtil.createServlet(s);
            if (s == null) continue;
            String path = "/grid/admin/" + servletClass.getSimpleName() + "/*";
            log.info("binding " + servletClass.getCanonicalName() + " to " + path);
            this.addServlet(path, servletClass);
        }
        this.initServer();
    }

    private void initServer() {
        try {
            this.server = new Server();
            SocketListener socketListener = new SocketListener();
            socketListener.setMaxIdleTimeMs(60000);
            socketListener.setPort(this.port);
            this.server.addListener(socketListener);
            WebApplicationContext root = this.server.addWebApplication("", ".");
            root.setAttribute(Registry.KEY, this.registry);
            root.addServlet("/*", DisplayHelpServlet.class.getName());
            root.addServlet("/grid/console/*", ConsoleServlet.class.getName());
            root.addServlet("/grid/register/*", RegistrationServlet.class.getName());
            root.addServlet("/grid/driver/*", DriverServlet.class.getName());
            root.addServlet("/wd/hub/*", DriverServlet.class.getName());
            root.addServlet("/selenium-server/driver/*", DriverServlet.class.getName());
            root.addServlet("/grid/resources/*", ResourceServlet.class.getName());
            root.addServlet("/grid/api/proxy/*", ProxyStatusServlet.class.getName());
            root.addServlet("/grid/api/testsession/*", TestSessionStatusServlet.class.getName());
            root.addServlet("/registration-manager/register/*", RegistrationServlet.class.getName());
            root.addServlet("/heartbeat", Grid1HeartbeatServlet.class.getName());
            for (Map.Entry<String, Class<? extends Servlet>> entry : this.extraServlet.entrySet()) {
                root.addServlet(entry.getKey(), entry.getValue().getName());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("Error initializing the hub" + e.getMessage(), e);
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void start() throws Exception {
        this.initServer();
        this.server.start();
    }

    public void stop() throws Exception {
        this.server.stop();
    }

    public URL getUrl() {
        try {
            return new URL("http://" + this.getHost() + ":" + this.getPort());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public URL getRegistrationURL() {
        String uri = "http://" + this.getHost() + ":" + this.getPort() + "/grid/register/";
        try {
            return new URL(uri);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

