/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import org.openqa.selenium.net.Urls;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.FrameAddress;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.RemoteCommandException;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.WindowClosedException;

public class FrameGroupCommandQueueSet {
    private static final Logger log = Logger.getLogger(FrameGroupCommandQueueSet.class.getName());
    private static final Map<String, FrameGroupCommandQueueSet> queueSets = new ConcurrentHashMap<String, FrameGroupCommandQueueSet>();
    private static Lock dataLock = new ReentrantLock();
    private static Condition resultArrivedOnAnyQueue = dataLock.newCondition();
    private String currentLocalFrameAddress;
    private String currentSeleniumWindowName;
    private FrameAddress currentFrameAddress = null;
    private String currentUniqueId = null;
    private final Set<File> tempFilesForSession = Collections.synchronizedSet(new HashSet());
    private Map<String, CommandQueue> uniqueIdToCommandQueue = new ConcurrentHashMap<String, CommandQueue>();
    private Map<String, Boolean> frameAddressToJustLoaded = new ConcurrentHashMap<String, Boolean>();
    private int pageLoadTimeoutInMilliseconds = 30000;
    private AtomicInteger millisecondDelayBetweenOperations;
    private final String sessionId;
    private final boolean proxyInjectionMode;
    private Set<CommandQueue> orphanedQueues = new HashSet<CommandQueue>();
    public static final String DEFAULT_LOCAL_FRAME_ADDRESS = "top";
    public static final String DEFAULT_SELENIUM_WINDOW_NAME = "";
    private int portDriversShouldContact;
    private RemoteControlConfiguration configuration;
    private String extensionJs;

    public FrameGroupCommandQueueSet(String sessionId, int portDriversShouldContact, RemoteControlConfiguration configuration) {
        this.sessionId = sessionId;
        this.portDriversShouldContact = portDriversShouldContact;
        this.configuration = configuration;
        this.extensionJs = DEFAULT_SELENIUM_WINDOW_NAME;
        this.proxyInjectionMode = configuration.getProxyInjectionModeArg();
        this.millisecondDelayBetweenOperations = new AtomicInteger(CommandQueue.getSpeed());
    }

    private String selectWindow(String seleniumWindowName) {
        if (!this.proxyInjectionMode) {
            String result;
            try {
                result = this.doCommand("selectWindow", seleniumWindowName, DEFAULT_SELENIUM_WINDOW_NAME);
            }
            catch (RemoteCommandException rce) {
                result = rce.getMessage();
            }
            return result;
        }
        if (seleniumWindowName == null) {
            seleniumWindowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if (seleniumWindowName.startsWith("title=")) {
            return this.selectWindowByRemoteTitle(seleniumWindowName.substring(6));
        }
        if (seleniumWindowName.startsWith("name=")) {
            seleniumWindowName = seleniumWindowName.substring(5);
            return this.selectWindowByNameOrVar(seleniumWindowName);
        }
        if (seleniumWindowName.startsWith("var=")) {
            seleniumWindowName = seleniumWindowName.substring(4);
            return this.selectWindowByNameOrVar(seleniumWindowName);
        }
        String match = this.findMatchingFrameAddress(this.uniqueIdToCommandQueue.keySet(), seleniumWindowName, DEFAULT_LOCAL_FRAME_ADDRESS);
        if (match == null) {
            return this.selectWindowByRemoteTitle(seleniumWindowName);
        }
        this.setCurrentFrameAddress(match);
        return "OK";
    }

    private String selectWindowByNameOrVar(String seleniumWindowName) {
        String match = this.findMatchingFrameAddress(this.uniqueIdToCommandQueue.keySet(), seleniumWindowName, DEFAULT_LOCAL_FRAME_ADDRESS);
        if (match == null) {
            return "ERROR: could not find window " + seleniumWindowName;
        }
        this.setCurrentFrameAddress(match);
        return "OK";
    }

    private String selectWindowByRemoteTitle(String title) {
        String match = null;
        boolean windowFound = false;
        for (String uniqueId : this.uniqueIdToCommandQueue.keySet()) {
            String windowName;
            CommandQueue commandQueue = this.uniqueIdToCommandQueue.get(uniqueId);
            try {
                windowName = this.getRemoteWindowTitle(commandQueue);
            }
            catch (WindowClosedException windowClosedException) {
                continue;
            }
            if (!windowName.equals(title)) continue;
            windowFound = true;
            match = uniqueId;
            break;
        }
        if (!windowFound) {
            return "ERROR: could not find window " + title;
        }
        this.setCurrentFrameAddress(match);
        return "OK";
    }

    public CommandQueue getCommandQueue() {
        return this.getCommandQueue(this.currentUniqueId);
    }

    public static FrameGroupCommandQueueSet getQueueSet(String sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("sessionId should not be null; has this session been started yet?");
        }
        FrameGroupCommandQueueSet queueSet = queueSets.get(sessionId);
        if (queueSet == null) {
            throw new RuntimeException("sessionId " + sessionId + " doesn't exist; perhaps this session was already stopped?");
        }
        return queueSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameGroupCommandQueueSet makeQueueSet(String sessionId, int portDriversShouldContact, RemoteControlConfiguration configuration) {
        Map<String, FrameGroupCommandQueueSet> map = queueSets;
        synchronized (map) {
            FrameGroupCommandQueueSet queueSet = queueSets.get(sessionId);
            if (queueSet != null) {
                throw new RuntimeException("sessionId " + sessionId + " already exists");
            }
            queueSet = new FrameGroupCommandQueueSet(sessionId, portDriversShouldContact, configuration);
            queueSets.put(sessionId, queueSet);
            return queueSet;
        }
    }

    public static void clearQueueSet(String sessionId) {
        log.fine("clearing queue set");
        FrameGroupCommandQueueSet queue = queueSets.get(sessionId);
        if (queue != null) {
            queue.endOfLife();
            queueSets.remove(sessionId);
        }
    }

    public CommandQueue getCommandQueue(String uniqueId) {
        CommandQueue q = this.uniqueIdToCommandQueue.get(uniqueId);
        if (q == null) {
            log.fine("---------allocating new CommandQueue for " + uniqueId);
            q = new CommandQueue(this.sessionId, uniqueId, this.millisecondDelayBetweenOperations.get(), this.configuration);
            this.uniqueIdToCommandQueue.put(uniqueId, q);
        } else {
            log.fine("---------retrieving CommandQueue for " + uniqueId);
        }
        return this.uniqueIdToCommandQueue.get(uniqueId);
    }

    protected void setSpeed(int i) {
        this.millisecondDelayBetweenOperations.set(i);
        for (CommandQueue queue : this.uniqueIdToCommandQueue.values()) {
            queue.setQueueDelay(i);
        }
    }

    protected int getSpeed() {
        return this.millisecondDelayBetweenOperations.get();
    }

    public String doCommand(String command, String arg, String value) throws RemoteCommandException {
        if (this.proxyInjectionMode) {
            String t;
            if ("selectFrame".equals(command)) {
                if (DEFAULT_SELENIUM_WINDOW_NAME.equals(arg)) {
                    arg = DEFAULT_LOCAL_FRAME_ADDRESS;
                }
                boolean newFrameFound = false;
                Set<String> idSet = this.uniqueIdToCommandQueue.keySet();
                Object[] ids = idSet.toArray(new String[0]);
                Arrays.sort(ids);
                Object[] objectArray = ids;
                int n = ids.length;
                int n2 = 0;
                while (n2 < n) {
                    FrameAddress frameAddress;
                    Object uniqueId = objectArray[n2];
                    CommandQueue frameQ = this.uniqueIdToCommandQueue.get(uniqueId);
                    if (!frameQ.isClosed() && (frameAddress = frameQ.getFrameAddress()).getWindowName().equals(this.currentSeleniumWindowName) && this.queueMatchesFrameAddress(frameQ, this.currentLocalFrameAddress, arg)) {
                        this.setCurrentFrameAddress((String)uniqueId);
                        newFrameFound = true;
                        break;
                    }
                    ++n2;
                }
                if (!newFrameFound) {
                    return "ERROR: starting from frame " + this.currentFrameAddress + ", could not find frame " + arg;
                }
                return "OK";
            }
            if ("selectWindow".equals(command)) {
                return this.selectWindow(arg);
            }
            if ("waitForPopUp".equals(command)) {
                String uniqueId;
                String waitingForThisWindowName = arg;
                long timeoutInMilliseconds = Long.parseLong(value);
                try {
                    uniqueId = this.waitForLoad(waitingForThisWindowName, DEFAULT_LOCAL_FRAME_ADDRESS, (int)(timeoutInMilliseconds / 1000L));
                }
                catch (RemoteCommandException ex) {
                    return ex.getResult();
                }
                this.setCurrentFrameAddress(uniqueId);
                return "OK";
            }
            if ("waitForPageToLoad".equals(command)) {
                return this.waitForLoad(arg);
            }
            if ("waitForFrameToLoad".equals(command)) {
                String result;
                String waitingForThisFrameName = arg;
                long timeoutInMilliseconds = Long.parseLong(value);
                String currentWindowName = this.getCommandQueue().getFrameAddress().getWindowName();
                try {
                    result = this.waitForLoad(currentWindowName, waitingForThisFrameName, (int)(timeoutInMilliseconds / 1000L));
                }
                catch (RemoteCommandException e) {
                    return e.getMessage();
                }
                this.setCurrentFrameAddress(result);
                return "OK";
            }
            if ("setTimeout".equals(command)) {
                try {
                    this.pageLoadTimeoutInMilliseconds = Integer.parseInt(arg);
                }
                catch (NumberFormatException numberFormatException) {
                    return "ERROR: setTimeout arg is not a number: " + arg;
                }
                return "OK";
            }
            if ("getAllWindowNames".equals(command)) {
                return this.getAttributeFromAllWindows("name");
            }
            if ("getAllWindowTitles".equals(command)) {
                return this.getAttributeFromAllWindows("document.title");
            }
            if ("getAllWindowIds".equals(command)) {
                return this.getAttributeFromAllWindows("id");
            }
            if ("getAttributeFromAllWindows".equals(command)) {
                return this.getAttributeFromAllWindows(arg);
            }
            CommandQueue queue = this.getCommandQueue();
            if (queue.isClosed()) {
                try {
                    String uniqueId = this.waitForLoad(this.currentSeleniumWindowName, this.currentLocalFrameAddress, 1);
                    this.setCurrentFrameAddress(uniqueId);
                }
                catch (RemoteCommandException remoteCommandException) {
                    return "Current window or frame is closed!";
                }
            }
            if ("open".equals(command)) {
                this.markWhetherJustLoaded(this.currentUniqueId, false);
                t = this.getCommandQueue().doCommand(command, arg, value);
                if (!"OK".equals(t)) {
                    return t;
                }
                return this.waitForLoad(this.pageLoadTimeoutInMilliseconds);
            }
            if (command.endsWith("AndWait")) {
                this.markWhetherJustLoaded(this.currentUniqueId, false);
                command = command.substring(0, command.length() - "AndWait".length());
                t = this.getCommandQueue().doCommand(command, arg, value);
                if (!t.startsWith("OK")) {
                    return t;
                }
                return this.waitForLoad(this.pageLoadTimeoutInMilliseconds);
            }
        }
        this.markWhetherJustLoaded(this.currentUniqueId, false);
        return this.getCommandQueue().doCommand(command, arg, value);
    }

    public String getStringArrayAccessorCSV(String[] stringArray) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < stringArray.length) {
            String str = stringArray[i];
            str = str.replaceAll("\\\\", "\\\\\\\\");
            str = str.replaceAll(",", "\\\\,");
            sb.append(str);
            if (i + 1 < stringArray.length) {
                sb.append('\\');
                sb.append(',');
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    private String getAttributeFromAllWindows(String attributeName) {
        if (!this.proxyInjectionMode) {
            String result;
            try {
                result = this.doCommand("getAttributeFromAllWindows", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
            }
            catch (RemoteCommandException rce) {
                result = rce.getMessage();
            }
            return result;
        }
        Set<String> frameAddressSet = this.uniqueIdToCommandQueue.keySet();
        ArrayList<String> windowTitles = new ArrayList<String>();
        for (String uniqueId : frameAddressSet) {
            String attribute;
            CommandQueue q = this.uniqueIdToCommandQueue.get(uniqueId);
            try {
                attribute = this.getRemoteString(q, "getEval", "window." + attributeName, DEFAULT_SELENIUM_WINDOW_NAME);
            }
            catch (WindowClosedException windowClosedException) {
                continue;
            }
            windowTitles.add(attribute);
        }
        String frameAddressCSV = this.getStringArrayAccessorCSV(windowTitles.toArray(new String[0]));
        return "OK," + frameAddressCSV;
    }

    private String getRemoteWindowTitle(CommandQueue queue) throws WindowClosedException {
        return this.getRemoteString(queue, "getTitle", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
    }

    private String getRemoteString(CommandQueue queue, String command, String arg1, String arg2) throws WindowClosedException {
        String cmdResult = queue.doCommand(command, arg1, arg2);
        if (cmdResult == null) {
            cmdResult = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if (cmdResult.startsWith("OK,")) {
            cmdResult = cmdResult.substring(3);
            return cmdResult;
        }
        if ("Current window or frame is closed!".equals(cmdResult)) {
            throw new WindowClosedException();
        }
        throw new RuntimeException("unexpected browser error from getTitle: " + cmdResult);
    }

    public String waitForLoad(long timeoutInMilliseconds) throws RemoteCommandException {
        int timeoutInSeconds = (int)(timeoutInMilliseconds / 1000L);
        if (timeoutInSeconds == 0) {
            timeoutInSeconds = 1;
        }
        String uniqueId = this.waitForLoad(this.currentSeleniumWindowName, this.currentLocalFrameAddress, timeoutInSeconds);
        this.setCurrentFrameAddress(uniqueId);
        if (uniqueId == null) {
            throw new RuntimeException("uniqueId is null in waitForLoad...this should not happen.");
        }
        return "OK";
    }

    private String waitForLoad(String timeoutInMilliseconds) throws RemoteCommandException {
        return this.waitForLoad(Long.parseLong(timeoutInMilliseconds));
    }

    private String waitForLoad(String waitingForThisWindowName, String waitingForThisLocalFrame, int timeoutInSeconds) throws RemoteCommandException {
        String matchingFrameAddress = null;
        while (timeoutInSeconds >= 0) {
            dataLock.lock();
            try {
                log.fine("waiting for window '" + waitingForThisWindowName + "' local frame '" + waitingForThisLocalFrame + "' for " + timeoutInSeconds + " more secs");
                matchingFrameAddress = this.findMatchingFrameAddress(this.frameAddressToJustLoaded.keySet(), waitingForThisWindowName, waitingForThisLocalFrame);
                if (matchingFrameAddress != null) {
                    log.fine("wait is over: window '" + waitingForThisWindowName + "' was seen at last (" + matchingFrameAddress + ")");
                    this.markWhetherJustLoaded(matchingFrameAddress, false);
                    String string = matchingFrameAddress;
                    return string;
                }
                FrameGroupCommandQueueSet.waitUntilSignalOrNumSecondsPassed(resultArrivedOnAnyQueue, 1);
            }
            finally {
                dataLock.unlock();
            }
            --timeoutInSeconds;
        }
        String result = "timed out waiting for window '" + waitingForThisWindowName + "' to appear";
        throw new RemoteCommandException(result, result);
    }

    protected static boolean waitUntilSignalOrNumSecondsPassed(Condition condition, int numSeconds) {
        boolean result = false;
        if (numSeconds > 0) {
            long now = System.currentTimeMillis();
            long deadline = now + (long)(numSeconds * 1000);
            while (now < deadline) {
                try {
                    log.fine("waiting for condition for " + (deadline - now) + " more ms");
                    result = condition.await(deadline - now, TimeUnit.MILLISECONDS);
                    log.fine("got condition? : " + result);
                    now = deadline;
                }
                catch (InterruptedException interruptedException) {
                    now = System.currentTimeMillis();
                }
            }
        }
        return result;
    }

    protected static void sleepForAtLeast(long ms) {
        if (ms > 0L) {
            long now = System.currentTimeMillis();
            long deadline = now + ms;
            while (now < deadline) {
                try {
                    Thread.sleep(deadline - now);
                    now = deadline;
                }
                catch (InterruptedException interruptedException) {
                    now = System.currentTimeMillis();
                }
            }
        }
    }

    private String findMatchingFrameAddress(Set<String> uniqueIds, String windowName, String localFrame) {
        for (String uniqueId : uniqueIds) {
            if (!this.matchesFrameAddress(uniqueId, windowName, localFrame)) continue;
            return uniqueId;
        }
        return null;
    }

    private boolean matchesFrameAddress(String uniqueId, String windowName, String localFrame) {
        String actualWindowName;
        CommandQueue queue;
        if (windowName == null || windowName.equals("null")) {
            windowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        if (localFrame == null) {
            localFrame = DEFAULT_LOCAL_FRAME_ADDRESS;
        }
        if ((queue = this.uniqueIdToCommandQueue.get(uniqueId)).isClosed()) {
            return false;
        }
        boolean windowJustLoaded = this.justLoaded(uniqueId);
        FrameAddress frameAddress = queue.getFrameAddress();
        if (!frameAddress.getLocalFrameAddress().equals(localFrame)) {
            return false;
        }
        if (windowJustLoaded) {
            String title;
            try {
                title = this.getRemoteWindowTitle(queue);
            }
            catch (WindowClosedException windowClosedException) {
                return false;
            }
            this.markWhetherJustLoaded(uniqueId, true);
            if (title.equals(windowName)) {
                return true;
            }
        }
        if (windowName.equals(actualWindowName = frameAddress.getWindowName())) {
            return true;
        }
        if (windowName.equals("_blank") && actualWindowName.startsWith("selenium_blank")) {
            return true;
        }
        return this.uniqueIdToCommandQueue.get(uniqueId).isWindowPointedToByJsVariable(windowName);
    }

    public RemoteCommand handleCommandResult(String commandResult, FrameAddress incomingFrameAddress, String uniqueId, boolean justLoaded, List<?> jsWindowNameVars) {
        CommandQueue queue = this.getCommandQueue(uniqueId);
        queue.setFrameAddress(incomingFrameAddress);
        if (jsWindowNameVars != null) {
            for (Object jsWindowNameVar : jsWindowNameVars) {
                queue.addJsWindowNameVar((String)jsWindowNameVar);
            }
        }
        if (justLoaded) {
            this.markWhetherJustLoaded(uniqueId, true);
            commandResult = null;
        }
        if ("Current window or frame is closed!".equals(commandResult)) {
            queue.declareClosed();
            return new DefaultRemoteCommand("testComplete", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
        }
        return queue.handleCommandResult(commandResult);
    }

    public void endOfLife() {
        this.removeTemporaryFiles();
        for (CommandQueue frameQ : this.uniqueIdToCommandQueue.values()) {
            frameQ.endOfLife();
        }
    }

    private boolean justLoaded(String uniqueId) {
        boolean result = false;
        if (uniqueId != null) {
            result = this.frameAddressToJustLoaded.containsKey(uniqueId);
        }
        return result;
    }

    private void markWhetherJustLoaded(String frameAddress, boolean justLoaded) {
        boolean oldState = this.justLoaded(frameAddress);
        if (oldState != justLoaded) {
            dataLock.lock();
            try {
                if (justLoaded) {
                    log.fine(String.valueOf(frameAddress) + " marked as just loaded");
                    this.frameAddressToJustLoaded.put(frameAddress, true);
                } else {
                    log.fine(String.valueOf(frameAddress) + " marked as NOT just loaded");
                    this.frameAddressToJustLoaded.remove(frameAddress);
                }
                resultArrivedOnAnyQueue.signalAll();
            }
            finally {
                dataLock.unlock();
            }
        }
    }

    private void setCurrentFrameAddress(String uniqueId) {
        assert (uniqueId != null);
        FrameAddress frameAddress = this.uniqueIdToCommandQueue.get(uniqueId).getFrameAddress();
        this.currentUniqueId = uniqueId;
        this.currentFrameAddress = frameAddress;
        this.currentSeleniumWindowName = frameAddress.getWindowName();
        this.currentLocalFrameAddress = frameAddress.getLocalFrameAddress();
        this.markWhetherJustLoaded(uniqueId, false);
        log.fine("Current uniqueId set to " + uniqueId + ", frameAddress = " + frameAddress);
    }

    public static FrameAddress makeFrameAddress(String seleniumWindowName, String localFrameAddress) {
        if (seleniumWindowName == null) {
            seleniumWindowName = DEFAULT_SELENIUM_WINDOW_NAME;
        }
        return FrameAddress.make(seleniumWindowName, localFrameAddress);
    }

    public void reset(String baseUrl) {
        log.fine("resetting frame group");
        if (this.proxyInjectionMode) {
            LinkedList<FrameAddress> newOrphans = new LinkedList<FrameAddress>();
            for (String uniqueId : this.uniqueIdToCommandQueue.keySet()) {
                CommandQueue q = this.getCommandQueue(uniqueId);
                FrameAddress frameAddress = q.getFrameAddress();
                if (frameAddress.getLocalFrameAddress().equals(DEFAULT_LOCAL_FRAME_ADDRESS) && frameAddress.getWindowName().equals(DEFAULT_SELENIUM_WINDOW_NAME)) continue;
                if (frameAddress.getLocalFrameAddress().equals(DEFAULT_LOCAL_FRAME_ADDRESS)) {
                    log.fine("Trying to close " + frameAddress);
                    try {
                        q.doCommandWithoutWaitingForAResponse("close", DEFAULT_SELENIUM_WINDOW_NAME, DEFAULT_SELENIUM_WINDOW_NAME);
                    }
                    catch (WindowClosedException windowClosedException) {
                        log.fine("Window was already closed");
                    }
                }
                this.orphanedQueues.add(q);
                newOrphans.add(frameAddress);
            }
            for (FrameAddress frameAddress : newOrphans) {
                this.uniqueIdToCommandQueue.remove(frameAddress);
            }
        }
        this.removeTemporaryFiles();
        this.selectWindow(DEFAULT_SELENIUM_WINDOW_NAME);
        StringBuilder openUrl = new StringBuilder();
        if (this.proxyInjectionMode) {
            openUrl.append("http://localhost:");
            openUrl.append(this.portDriversShouldContact);
            openUrl.append("/selenium-server/core/InjectedRemoteRunner.html");
        } else {
            openUrl.append(Urls.toProtocolHostAndPort(baseUrl));
        }
        try {
            this.doCommand("open", openUrl.toString(), DEFAULT_SELENIUM_WINDOW_NAME);
        }
        catch (RemoteCommandException rce) {
            log.fine("RemoteCommandException in reset: " + rce.getMessage());
        }
    }

    protected void removeTemporaryFiles() {
        for (File file : this.tempFilesForSession) {
            boolean deleteSuccessful = file.delete();
            if (deleteSuccessful) continue;
            log.warning("temp file for session " + this.sessionId + " not deleted " + file.getAbsolutePath());
        }
        this.tempFilesForSession.clear();
    }

    protected void addTemporaryFile(File tf) {
        this.tempFilesForSession.add(tf);
    }

    private boolean queueMatchesFrameAddress(CommandQueue queue, String localFrameAddress, String newFrameAddressExpression) {
        boolean result;
        try {
            result = this.doBooleanCommand(queue, "getWhetherThisFrameMatchFrameExpression", localFrameAddress, newFrameAddressExpression);
        }
        catch (WindowClosedException windowClosedException) {
            return false;
        }
        return result;
    }

    private boolean doBooleanCommand(CommandQueue queue, String command, String arg1, String arg2) throws WindowClosedException {
        boolean result;
        String booleanResult = queue.doCommand(command, arg1, arg2);
        if ("OK,true".equals(booleanResult)) {
            result = true;
        } else if ("OK,false".equals(booleanResult)) {
            result = false;
        } else {
            if ("Current window or frame is closed!".equals(booleanResult)) {
                throw new WindowClosedException();
            }
            throw new RuntimeException("unexpected return " + booleanResult + " from boolean command " + command);
        }
        log.fine("doBooleancommand(" + command + "(" + arg1 + ", " + arg2 + ") -> " + result);
        return result;
    }

    public void setExtensionJs(String extensionJs) {
        this.extensionJs = extensionJs;
    }

    public String getExtensionJs() {
        return this.extensionJs;
    }
}

