/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.safari;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.io.TemporaryFilesystem;

class SafariDriverExtension {
    private static final Logger logger = Logger.getLogger(SafariDriverExtension.class.getName());
    public static final String EXTENSION_LOCATION_PROPERTY = "webdriver.safari.driver";
    private static final String EXTENSION_PLIST_LINES = Joiner.on("\n").join("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<!DOCTYPE plist PUBLIC \"-//Apple//DTD PLIST 1.0//EN\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">", "<plist version=\"1.0\">", "<dict>", "\t<key>Available Updates</key>", "\t<dict>", "\t\t<key>Last Update Check Time</key>", "\t\t<real>370125644.75941497</real>", "\t\t<key>Updates List</key>", "\t\t<array/>", "\t</dict>", "\t<key>Installed Extensions</key>", "\t<array>", "\t\t<dict>", "\t\t\t<key>Added Non-Default Toolbar Items</key>", "\t\t\t<array/>", "\t\t\t<key>Archive File Name</key>", "\t\t\t<string>WebDriver.safariextz</string>", "\t\t\t<key>Bundle Directory Name</key>", "\t\t\t<string>WebDriver.safariextension</string>", "\t\t\t<key>Enabled</key>", "\t\t\t<true/>", "\t\t\t<key>Hidden Bars</key>", "\t\t\t<array/>", "\t\t\t<key>Removed Default Toolbar Items</key>", "\t\t\t<array/>", "\t\t</dict>", "\t</array>", "\t<key>Version</key>", "\t<integer>1</integer>", "</dict>", "</plist>");
    private final Runtime runtime = Runtime.getRuntime();
    private final Backup backup = new Backup();
    private UninstallThread uninstallThread;
    private File installedExtension;

    SafariDriverExtension() {
    }

    private static File getSafariDataDirectory() {
        Platform current = Platform.getCurrent();
        if (Platform.MAC.is(current)) {
            return new File("/Users/" + System.getenv("USER"), "Library/Safari");
        }
        if (Platform.WINDOWS.is(current)) {
            return new File(System.getenv("APPDATA"), "Apple Computer/Safari");
        }
        throw new IllegalStateException("The current platform is not supported: " + (Object)((Object)current));
    }

    private static File getInstallDirectory() throws IOException {
        File dataDir = SafariDriverExtension.getSafariDataDirectory();
        Preconditions.checkState(dataDir.isDirectory(), "The expected Safari data directory does not exist: %s", dataDir.getAbsolutePath());
        File extensionsDir = new File(dataDir, "Extensions");
        if (!extensionsDir.isDirectory()) {
            extensionsDir.mkdir();
        }
        return extensionsDir;
    }

    public synchronized void install() throws IOException {
        if (this.uninstallThread != null) {
            return;
        }
        String extensionPath = System.getProperty(EXTENSION_LOCATION_PROPERTY);
        if (Strings.isNullOrEmpty(extensionPath)) {
            return;
        }
        File extensionSrc = new File(extensionPath);
        Preconditions.checkState(extensionSrc.isFile(), "The SafariDriver extension specified through the %s system property does not exist: %s", EXTENSION_LOCATION_PROPERTY, extensionPath);
        Preconditions.checkState(extensionSrc.canRead(), "The SafariDriver extension specified through the %s system property is not readable: %s", EXTENSION_LOCATION_PROPERTY, extensionPath);
        logger.info(String.format("Installing %s defined extension: %s", EXTENSION_LOCATION_PROPERTY, extensionSrc.getAbsolutePath()));
        this.installedExtension = new File(SafariDriverExtension.getInstallDirectory(), "WebDriver.safariextz");
        if (this.installedExtension.exists()) {
            this.backup.backup(this.installedExtension);
        }
        Files.copy(extensionSrc, this.installedExtension);
        File extensionPlist = new File(SafariDriverExtension.getInstallDirectory(), "Extensions.plist");
        if (extensionPlist.exists()) {
            this.backup.backup(extensionPlist);
        }
        Files.write(EXTENSION_PLIST_LINES, extensionPlist, Charsets.UTF_8);
        this.uninstallThread = new UninstallThread();
        this.runtime.addShutdownHook(this.uninstallThread);
    }

    public synchronized void uninstall() throws IOException {
        if (this.uninstallThread != null) {
            try {
                this.runtime.removeShutdownHook(this.uninstallThread);
            }
            catch (IllegalStateException illegalStateException) {}
            this.uninstallThread = null;
            this.installedExtension.delete();
            this.backup.restoreAll();
        }
    }

    private static class Backup {
        private final TemporaryFilesystem filesystem = TemporaryFilesystem.getDefaultTmpFS();
        private final Map<File, File> backups = Maps.newHashMap();
        private File backupDir;

        private Backup() {
        }

        File backup(File file) throws IOException {
            if (this.backupDir == null) {
                this.backupDir = this.filesystem.createTempDir("SafariBackups", "webdriver");
            }
            File backup = new File(this.backupDir, file.getName());
            Files.copy(file, backup);
            this.backups.put(file, backup);
            return backup;
        }

        void restoreAll() throws IOException {
            for (Map.Entry<File, File> entry : this.backups.entrySet()) {
                File originalLocation = entry.getKey();
                File backup = entry.getValue();
                Files.copy(backup, originalLocation);
            }
        }
    }

    private class UninstallThread
    extends Thread {
        private UninstallThread() {
        }

        @Override
        public void run() {
            try {
                SafariDriverExtension.this.uninstall();
            }
            catch (IOException e) {
                throw new WebDriverException("Unable to uninstall extension", e);
            }
        }
    }
}

